/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ConverterPropertyEditorBase;
import com.sun.faces.application.ConverterPropertyEditorFor_XXXX;
import com.sun.faces.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterPropertyEditorFactory {
    private static final Logger logger = Util.getLogger(ConverterPropertyEditorFactory.class.getName());
    private static final Pattern UnderscorePattern = Pattern.compile("_+");
    private static final Pattern SingleUnderscorePattern = Pattern.compile("([^_])_([^_])");
    private static final Pattern MultipleUnderscorePattern = Pattern.compile("_(_+)");
    private static ConverterPropertyEditorFactory defaultInstance;
    private ClassTemplateInfo templateInfo;
    private Map<ClassLoader, WeakReference<DisposableClassLoader>> classLoaderCache;
    private static final Map<Character, String> PRIM_MAP;

    public ConverterPropertyEditorFactory() {
        this.templateInfo = new ClassTemplateInfo();
    }

    public ConverterPropertyEditorFactory(Class<? extends ConverterPropertyEditorBase> templateClass) {
        this.templateInfo = new ClassTemplateInfo(templateClass);
    }

    public static synchronized ConverterPropertyEditorFactory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ConverterPropertyEditorFactory();
        }
        return defaultInstance;
    }

    private ClassTemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public Class<? extends ConverterPropertyEditorBase> definePropertyEditorClassFor(final Class<?> targetClass) {
        try {
            DisposableClassLoader loader;
            WeakReference<DisposableClassLoader> loaderRef;
            String className = this.getTemplateInfo().generateClassNameFor(targetClass, false);
            if (this.classLoaderCache == null) {
                this.classLoaderCache = new WeakHashMap<ClassLoader, WeakReference<DisposableClassLoader>>();
            }
            if ((loaderRef = this.classLoaderCache.get(targetClass.getClassLoader())) == null || (loader = (DisposableClassLoader)loaderRef.get()) == null) {
                loader = (DisposableClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new DisposableClassLoader(targetClass.getClassLoader());
                    }
                });
                if (loader == null) {
                    return null;
                }
                this.classLoaderCache.put(targetClass.getClassLoader(), new WeakReference<DisposableClassLoader>(loader));
            }
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "definePropertyEditorClassFor: ClassNotFoundException: " + e.getMessage(), e);
            return null;
        }
    }

    private static String getVMClassName(Class<?> c) {
        return c.getName().replace('.', '/');
    }

    private static byte[] getUtf8InfoBytes(String text) {
        byte[] utf8;
        try {
            utf8 = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            utf8 = text.getBytes();
        }
        byte[] info = new byte[utf8.length + 3];
        info[0] = 1;
        info[1] = (byte)(utf8.length >> 8 & 0xFF);
        info[2] = (byte)(utf8.length & 0xFF);
        System.arraycopy(utf8, 0, info, 3, utf8.length);
        return info;
    }

    static {
        PRIM_MAP = new HashMap<Character, String>(8, 1.0f);
        PRIM_MAP.put(Character.valueOf('B'), "byte");
        PRIM_MAP.put(Character.valueOf('C'), "char");
        PRIM_MAP.put(Character.valueOf('S'), "short");
        PRIM_MAP.put(Character.valueOf('I'), "int");
        PRIM_MAP.put(Character.valueOf('F'), "float");
        PRIM_MAP.put(Character.valueOf('J'), "long");
        PRIM_MAP.put(Character.valueOf('D'), "double");
        PRIM_MAP.put(Character.valueOf('Z'), "boolean");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTemplateInfo {
        private Class<? extends ConverterPropertyEditorBase> templateClass;
        private byte[] templateBytes;
        private int constant_pool_count;
        private Utf8InfoRef classNameConstant;
        private Utf8InfoRef classNameRefConstant;
        private Utf8InfoRef targetClassConstant;

        public ClassTemplateInfo() {
            this(ConverterPropertyEditorFor_XXXX.class);
        }

        public ClassTemplateInfo(Class<? extends ConverterPropertyEditorBase> templateClass) {
            this.templateClass = templateClass;
            try {
                ConverterPropertyEditorBase tc = templateClass.newInstance();
                Class<?> templateTargetClass = tc.getTargetClass();
                this.loadTemplateBytes();
                this.classNameConstant = this.findConstant(ConverterPropertyEditorFactory.getVMClassName(templateClass));
                this.classNameRefConstant = this.findConstant(new StringBuilder(64).append('L').append(ConverterPropertyEditorFactory.getVMClassName(templateClass)).append(';').toString());
                this.targetClassConstant = this.findConstant(ConverterPropertyEditorFactory.getVMClassName(templateTargetClass));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean matchAtIndex(byte[] targetBytes, int index) {
            if (index < 0 || index + targetBytes.length > this.templateBytes.length) {
                return false;
            }
            for (int i = 0; i < targetBytes.length; ++i) {
                if (targetBytes[i] == this.templateBytes[index + i]) continue;
                return false;
            }
            return true;
        }

        private Utf8InfoRef findConstant(String text) {
            byte[] utf8InfoBytes = ConverterPropertyEditorFactory.getUtf8InfoBytes(text);
            assert (utf8InfoBytes[0] == 1);
            int off = 10;
            block6: for (int i = 1; i < this.constant_pool_count && off < this.templateBytes.length; ++i) {
                if (this.matchAtIndex(utf8InfoBytes, off)) {
                    return new Utf8InfoRef(off, utf8InfoBytes.length);
                }
                switch (this.templateBytes[off]) {
                    case 1: {
                        int len = (this.templateBytes[off + 1] & 0xFF00) + (this.templateBytes[off + 2] & 0xFF);
                        off += 3 + len;
                        continue block6;
                    }
                    case 7: 
                    case 8: {
                        off += 3;
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        off += 5;
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        off += 9;
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized class file constant pool tag " + this.templateBytes[off]);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadTemplateBytes() throws IOException {
            String resourceName = '/' + this.templateClass.getName().replace('.', '/') + ".class";
            InputStream in = ConverterPropertyEditorFactory.class.getResourceAsStream(resourceName);
            if (in != null) {
                try {
                    int more;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buff = new byte[1024];
                    while ((more = in.read(buff)) > 0) {
                        baos.write(buff, 0, more);
                    }
                    this.templateBytes = baos.toByteArray();
                    assert (this.templateBytes.length > 9);
                    assert (this.templateBytes[0] == -54);
                    assert (this.templateBytes[1] == -2);
                    assert (this.templateBytes[2] == -70);
                    assert (this.templateBytes[3] == -66);
                    this.constant_pool_count = ((this.templateBytes[8] & 0xFF) << 8) + (this.templateBytes[9] & 0xFF);
                }
                finally {
                    in.close();
                }
            }
        }

        public String generateClassNameFor(Class<?> targetClass, boolean vmFormat) {
            String name = targetClass.getName();
            if (targetClass.isArray()) {
                int idx = name.lastIndexOf(91);
                int bracketCount = idx + 1;
                int semiIdx = name.indexOf(59);
                name = semiIdx == -1 ? (String)PRIM_MAP.get(Character.valueOf(name.charAt(idx + 1))) : name.substring(idx + 2, semiIdx);
                name = name + "Array" + bracketCount + 'd';
            }
            Matcher m = UnderscorePattern.matcher(name);
            name = m.replaceAll("$0_");
            name = name.replace('.', '_');
            if (vmFormat) {
                return ConverterPropertyEditorFactory.getVMClassName(this.templateClass).replace("XXXX", name);
            }
            return this.templateClass.getName().replace("XXXX", name);
        }

        public String getTargetClassName(String className) {
            String prefix = this.templateClass.getName().replace("XXXX", "");
            if (className.startsWith(prefix)) {
                String name = className.substring(prefix.length());
                name = SingleUnderscorePattern.matcher(name).replaceAll("$1.$2");
                name = MultipleUnderscorePattern.matcher(name).replaceAll("$1");
                return name;
            }
            return null;
        }

        private byte[] replaceInTemplate(Utf8InfoReplacement ... replacements) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TreeSet<Utf8InfoReplacement> sorted = new TreeSet<Utf8InfoReplacement>();
            for (Utf8InfoReplacement r : replacements) {
                if (r.ref == null || r.replacement == null) continue;
                sorted.add(r);
            }
            int from = 0;
            for (Utf8InfoReplacement r : sorted) {
                baos.write(this.templateBytes, from, r.ref.index - from);
                from = r.ref.index + r.ref.length;
                baos.write(r.replacement, 0, r.replacement.length);
            }
            baos.write(this.templateBytes, from, this.templateBytes.length - from);
            return baos.toByteArray();
        }

        public byte[] generateClassBytesFor(String newClassName, String targetClassName) {
            return this.replaceInTemplate(new Utf8InfoReplacement(this.classNameConstant, newClassName), new Utf8InfoReplacement(this.classNameRefConstant, new StringBuilder(32).append('L').append(newClassName).append(';').toString()), new Utf8InfoReplacement(this.targetClassConstant, targetClassName));
        }

        private static class Utf8InfoRef {
            int index;
            int length;

            public Utf8InfoRef(int index, int length) {
                this.index = index;
                this.length = length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Utf8InfoReplacement
        implements Comparable<Utf8InfoReplacement> {
            Utf8InfoRef ref;
            byte[] replacement;

            public Utf8InfoReplacement(Utf8InfoRef ref, String replacement) {
                this.ref = ref;
                this.replacement = ConverterPropertyEditorFactory.getUtf8InfoBytes(replacement);
            }

            @Override
            public int compareTo(Utf8InfoReplacement rhs) {
                return this.ref.index - rhs.ref.index;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisposableClassLoader
    extends ClassLoader {
        private ClassLoader targetLoader;
        private ClassLoader myLoader;

        public DisposableClassLoader(ClassLoader targetLoader) {
            super(targetLoader);
            this.targetLoader = targetLoader;
            this.myLoader = ConverterPropertyEditorBase.class.getClassLoader();
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && this.myLoader != null && this.myLoader != this.targetLoader) {
                try {
                    c = this.myLoader.loadClass(name);
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = super.loadClass(name, false);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            String targetClassName = ConverterPropertyEditorFactory.this.getTemplateInfo().getTargetClassName(className);
            if (targetClassName != null) {
                byte[] classBytes = ConverterPropertyEditorFactory.this.getTemplateInfo().generateClassBytesFor(className.replace('.', '/'), targetClassName.replace('.', '/'));
                Class<?> editorClass = this.defineClass(className, classBytes, 0, classBytes.length);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Defined editorClass " + editorClass);
                }
                return editorClass;
            }
            return super.findClass(className);
        }
    }
}

