/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.GenerationUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class STSWizardCreator {
    protected static final int JSE_PROJECT_TYPE = 0;
    protected static final int WEB_PROJECT_TYPE = 1;
    protected static final int EJB_PROJECT_TYPE = 2;
    public static final String STS_WEBSERVICE = "sts-webservice";
    private int projectType;
    private Project project;
    private WizardDescriptor wiz;
    public boolean wsitSupported;
    public boolean jsr109Supported;
    private static final Logger logger = Logger.getLogger(STSWizardCreator.class.getName());

    public STSWizardCreator(Project project, WizardDescriptor wizardDescriptor) {
        this.project = project;
        this.wiz = wizardDescriptor;
    }

    public STSWizardCreator(Project project) {
        this.project = project;
    }

    public void createSTS() {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(STSWizardCreator.class, (String)"TXT_StsGeneration"));
        this.initProjectInfo(this.project);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    progressHandle.start(100);
                    STSWizardCreator.this.generateWsFromWsdl15(progressHandle);
                }
                catch (Exception exception) {
                    progressHandle.finish();
                    String string = exception.getLocalizedMessage();
                    if (string != null) {
                        logger.log(Level.INFO, null, exception);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    }
                    logger.log(Level.INFO, null, exception);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private void initProjectInfo(Project project) {
        J2eeModuleProvider j2eeModuleProvider;
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            this.jsr109Supported = wsitProvider.isJsr109Project();
            this.wsitSupported = wsitProvider.isWsitSupported();
        }
        if ((j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            J2eeModule.Type type = j2eeModuleProvider.getJ2eeModule().getType();
            if (J2eeModule.Type.EJB.equals(type)) {
                this.projectType = 2;
            } else if (J2eeModule.Type.WAR.equals(type)) {
                this.projectType = 1;
                Util.checkMetroRtLibrary(project, false);
            } else {
                this.projectType = J2eeModule.Type.CAR.equals(type) ? 3 : 0;
            }
        } else {
            WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
            EjbJar ejbJar = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
            this.projectType = webModule != null ? 1 : (ejbJar != null ? 2 : 0);
        }
    }

    private void generateWsFromWsdl15(final ProgressHandle progressHandle) throws Exception {
        String string = (String)this.wiz.getProperty("wsdlFilePath");
        File file = FileUtil.normalizeFile((File)new File(string));
        final URL uRL = file.toURI().toURL();
        final WsdlService wsdlService = (WsdlService)this.wiz.getProperty("wsdlService");
        if (wsdlService == null) {
            progressHandle.finish();
            return;
        }
        final WsdlPort wsdlPort = (WsdlPort)this.wiz.getProperty("wsdlPort");
        WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
        wsdlModeler.generateWsdlModel(new WsdlModelListener(){

            public void modelCreated(WsdlModel wsdlModel) {
                WsdlService wsdlService2 = wsdlModel.getServiceByName(wsdlService.getName());
                WsdlPort wsdlPort2 = wsdlService2.getPortByName(wsdlPort.getName());
                wsdlPort2.setSOAPVersion(wsdlPort.getSOAPVersion());
                FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)STSWizardCreator.this.wiz);
                String string = Templates.getTargetName((WizardDescriptor)STSWizardCreator.this.wiz);
                try {
                    STSWizardCreator.this.generateProviderImplClass(STSWizardCreator.this.project, fileObject, string, wsdlService2, wsdlPort2, uRL);
                    progressHandle.finish();
                }
                catch (Exception exception) {
                    progressHandle.finish();
                    logger.log(Level.SEVERE, null, exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProviderImplClass(Project project, FileObject fileObject, final String string, final WsdlService wsdlService, final WsdlPort wsdlPort, URL uRL) throws Exception {
        FileObject fileObject2;
        FileObject fileObject3;
        this.initProjectInfo(project);
        String string2 = wsdlService.getName();
        final JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        FileObject fileObject4 = GenerationUtils.createClass(fileObject, string, null);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject4, (String)"classpath/source");
        String string3 = classPath.getResourceName(fileObject4, '.', false);
        String string4 = wsdlPort.getJavaName();
        String string5 = string4.substring(0, string4.lastIndexOf(46));
        string2 = jAXWSSupport.addService(string, string3, uRL.toString(), wsdlService.getName(), wsdlPort.getName(), string5, this.jsr109Supported && Util.isJavaEE5orHigher(project), true);
        final String string6 = jAXWSSupport.getWsdlLocation(string2);
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject4);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                GenerationUtils generationUtils = GenerationUtils.newInstance(workingCopy);
                if (generationUtils != null) {
                    Object object;
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ClassTree classTree = generationUtils.getClassTree();
                    Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), classTree));
                    if (element instanceof TypeElement) {
                        stringArray[0] = ((TypeElement)element).getQualifiedName().toString();
                    }
                    String string = "com.sun.xml.ws.security.trust.sts.BaseSTSImpl";
                    ArrayList<AnnotationTree> arrayList = new ArrayList<AnnotationTree>();
                    AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent("javax.annotation.Resource"), Collections.emptyList());
                    arrayList.add(annotationTree);
                    ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
                    arrayList2.add(treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet(), arrayList), (CharSequence)"context", (Tree)treeMaker.QualIdent("javax.xml.ws.WebServiceContext"), null));
                    ClassTree classTree2 = generationUtils.addClassFields(classTree, arrayList2);
                    ParameterizedTypeTree parameterizedTypeTree = treeMaker.ParameterizedType((Tree)treeMaker.QualIdent("javax.xml.ws.Provider"), Collections.singletonList(treeMaker.QualIdent("javax.xml.transform.Source")));
                    classTree2 = treeMaker.addClassImplementsClause(classTree2, (Tree)parameterizedTypeTree);
                    classTree2 = treeMaker.setExtends(classTree2, (ExpressionTree)treeMaker.Identifier((CharSequence)string));
                    ArrayList<AssignmentTree> arrayList3 = new ArrayList<AssignmentTree>();
                    arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"serviceName"), (ExpressionTree)treeMaker.Literal((Object)wsdlService.getName())));
                    arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"portName"), (ExpressionTree)treeMaker.Literal((Object)wsdlPort.getName())));
                    arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)treeMaker.Literal((Object)wsdlPort.getNamespaceURI())));
                    arrayList3.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)treeMaker.Literal((Object)string6)));
                    AnnotationTree annotationTree2 = treeMaker.Annotation((Tree)treeMaker.QualIdent("javax.xml.ws.WebServiceProvider"), arrayList3);
                    classTree2 = generationUtils.addAnnotation(classTree2, annotationTree2);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.xml.ws.ServiceMode");
                    ArrayList<AssignmentTree> arrayList4 = new ArrayList<AssignmentTree>();
                    MemberSelectTree memberSelectTree = treeMaker.MemberSelect(treeMaker.QualIdent("javax.xml.ws.Service.Mode"), (CharSequence)"PAYLOAD");
                    arrayList4.add(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"value"), (ExpressionTree)memberSelectTree));
                    AnnotationTree annotationTree3 = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), arrayList4);
                    classTree2 = generationUtils.addAnnotation(classTree2, annotationTree3);
                    if (STSWizardCreator.this.projectType == 2) {
                        object = treeMaker.Annotation((Tree)treeMaker.QualIdent("javax.ejb.Stateless"), Collections.emptyList());
                        classTree2 = generationUtils.addAnnotation(classTree2, (AnnotationTree)object);
                    }
                    object = new ArrayList<VariableTree>();
                    object.add(treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)"rstElement", (Tree)treeMaker.QualIdent("javax.xml.transform.Source"), null));
                    ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                    ArrayList arrayList5 = new ArrayList();
                    MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)"invoke", (Tree)treeMaker.QualIdent("javax.xml.transform.Source"), Collections.emptyList(), (List)object, arrayList5, "{ return super.invoke(rstElement); }", null);
                    classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree);
                    ModifiersTree modifiersTree2 = treeMaker.Modifiers(Collections.singleton(Modifier.PROTECTED), Collections.emptyList());
                    ArrayList arrayList6 = new ArrayList();
                    MethodTree methodTree2 = treeMaker.Method(modifiersTree2, (CharSequence)"getMessageContext", (Tree)treeMaker.QualIdent("javax.xml.ws.handler.MessageContext"), Collections.emptyList(), Collections.emptyList(), arrayList6, "{ MessageContext msgCtx = context.getMessageContext();\nreturn msgCtx; }", null);
                    classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree2);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
        String string7 = "/" + string + "Service";
        String string8 = string7 + "/mex";
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            wsitProvider.addServiceDDEntry(string3, string8, string);
        }
        if ((fileObject3 = (fileObject2 = jAXWSSupport.getDeploymentDescriptorFolder()).getFileObject("sun-jaxws.xml")) == null) {
            WSUtils.generateSunJaxwsFile((FileObject)fileObject2);
            fileObject3 = fileObject2.getFileObject("sun-jaxws.xml");
        }
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject3);
        Endpoint endpoint = endpoints.newEndpoint();
        endpoint.setEndpointName("MEXEndpoint");
        endpoint.setImplementation("com.sun.xml.ws.mex.server.MEXEndpoint");
        endpoint.setUrlPattern(string8);
        endpoints.addEnpoint(endpoint);
        if (stringArray[0] != null) {
            endpoint = endpoints.newEndpoint();
            endpoint.setEndpointName(string);
            endpoint.setImplementation(stringArray[0]);
            endpoint.setUrlPattern(string7);
            endpoints.addEnpoint(endpoint);
        }
        FileLock fileLock = null;
        OutputStream outputStream = null;
        STSWizardCreator sTSWizardCreator = this;
        synchronized (sTSWizardCreator) {
            try {
                fileLock = fileObject3.lock();
                outputStream = fileObject3.getOutputStream(fileLock);
                endpoints.write(outputStream);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        sTSWizardCreator = DataObject.find((FileObject)fileObject4);
        fileObject4.setAttribute(STS_WEBSERVICE, (Object)Boolean.TRUE);
        fileObject4.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                try {
                    jAXWSSupport.removeNonJsr109Entries("MEXEndpoint");
                    jAXWSSupport.removeNonJsr109Entries(stringArray[0]);
                    jAXWSSupport.removeNonJsr109Entries(string);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, null, iOException);
                }
            }
        });
        STSWizardCreator.openFileInEditor((DataObject)sTSWizardCreator);
    }

    private static void openFileInEditor(DataObject dataObject) {
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                editorCookie.open();
            }
        }, 1000);
    }
}

