/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.StoreFileFilter;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class KeystorePanel
extends JPanel {
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";
    public static final String DEFAULT_PASSWORD = "changeit";
    public static final String DEFAULT_PASSWORD2 = "adminadmin";
    private WSDLComponent comp;
    private boolean jsr109 = false;
    private Project project = null;
    private boolean client;
    private String keystoreType = "JKS";
    private boolean inSync = false;
    private ConfigVersion cfgVersion = null;
    String keyStoreLocation = null;
    String ksType = null;
    String keyStorePassword = null;
    String keyStoreAlias = null;
    String keyPassword = null;
    String aliasSelector = null;
    private JButton aliasSelectorButton;
    private JTextField aliasSelectorField;
    private JLabel aliasSelectorLbl;
    private JComboBox keyAliasCombo;
    private JLabel keyAliasLabel;
    private JPasswordField keyPasswordField;
    private JLabel keyPasswordLabel;
    private JButton keystoreLocationButton;
    private JLabel keystoreLocationLabel;
    private JTextField keystoreLocationTextField;
    private JPasswordField keystorePasswordField;
    private JLabel keystorePasswordLabel;
    private JButton loadkeysButton;

    public KeystorePanel(WSDLComponent comp, Project p, boolean jsr109, boolean client, ConfigVersion cfgVersion) {
        this.comp = comp;
        this.jsr109 = jsr109;
        this.project = p;
        this.client = client;
        this.cfgVersion = cfgVersion;
        this.initComponents();
        this.keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyPasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyPasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystoreLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystorePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystorePasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.aliasSelectorLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.aliasSelectorField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getKeystoreAlias() {
        return (String)this.keyAliasCombo.getSelectedItem();
    }

    private void setKeystoreAlias(String alias) {
        this.keyAliasCombo.setSelectedItem(alias);
    }

    private String getKeyPassword() {
        return String.valueOf(this.keyPasswordField.getPassword());
    }

    private void setKeyPassword(String password) {
        this.keyPasswordField.setText(password);
    }

    private String getSelector() {
        String path = this.aliasSelectorField.getText();
        if ("".equals(path) || path == null) {
            return null;
        }
        return path;
    }

    private void setSelector(String selector) {
        this.aliasSelectorField.setText(selector);
    }

    private char[] getCharKeystorePassword() {
        return this.keystorePasswordField.getPassword();
    }

    private String getKeystorePassword() {
        return String.valueOf(this.keystorePasswordField.getPassword());
    }

    private void setKeystorePassword(String password) {
        this.keystorePasswordField.setText(password);
    }

    private void setKeystorePath(String path) {
        this.keystoreLocationTextField.setText(path);
    }

    private String getKeystorePath() {
        String path = this.keystoreLocationTextField.getText();
        if ("".equals(path) || path == null) {
            return null;
        }
        return path;
    }

    private void setKeystoreType(String type) {
        this.keystoreType = type;
    }

    public void sync() {
        this.inSync = true;
        this.keyStoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(this.comp, false);
        if (this.keyStoreLocation != null) {
            this.setKeystorePath(this.keyStoreLocation);
        } else if (this.jsr109) {
            this.setKeystorePath(ServerUtils.getStoreLocation(this.project, false, this.client));
        }
        this.ksType = ProprietarySecurityPolicyModelHelper.getStoreType(this.comp, false);
        if (this.ksType != null) {
            this.setKeystoreType(this.ksType);
        }
        this.keyStorePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(this.comp, false);
        if (this.keyStorePassword != null) {
            this.setKeystorePassword(this.keyStorePassword);
            this.reloadAliases();
        } else if (this.jsr109) {
            this.keyStorePassword = DEFAULT_PASSWORD;
            this.setKeystorePassword(DEFAULT_PASSWORD);
            if (!this.reloadAliases()) {
                String adminPassword;
                this.keyStorePassword = adminPassword = Util.getPassword(this.project);
                this.setKeystorePassword(this.keyStorePassword);
            }
            if (!this.reloadAliases()) {
                this.keyStorePassword = "";
                this.setKeystorePassword("");
            }
        }
        this.keyStoreAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(this.comp, false);
        this.setKeystoreAlias(this.keyStoreAlias);
        this.keyPassword = ProprietarySecurityPolicyModelHelper.getKeyPassword(this.comp);
        if (this.keyPassword != null) {
            this.setKeyPassword(this.keyPassword);
        }
        this.aliasSelector = ProprietarySecurityPolicyModelHelper.getAliasSelector(this.comp);
        if (this.aliasSelector != null) {
            this.setSelector(this.aliasSelector);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
    }

    public void storeState() {
        String keystoreAlias = this.getKeystoreAlias();
        if (keystoreAlias == null || keystoreAlias.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(this.comp, keystoreAlias, this.client);
        }
        String keyPasswd = this.getKeyPassword();
        String keyStorePasswd = this.getKeystorePassword();
        String keyStoreLoc = this.getKeystorePath();
        if (keyPasswd == null || keyPasswd.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setKeyPassword(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setKeyPassword(this.comp, keyPasswd, this.client);
        }
        if (keyStorePasswd == null || keyStorePasswd.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, null, false, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, keyStorePasswd, false, this.client);
        }
        ProprietarySecurityPolicyModelHelper.setStoreType(this.comp, this.keystoreType, false, this.client);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(this.comp, keyStoreLoc, false, this.client);
        String selector = this.getSelector();
        ProprietarySecurityPolicyModelHelper.setAliasSelector(this.comp, selector, false);
    }

    private void initComponents() {
        this.keystoreLocationLabel = new JLabel();
        this.keystorePasswordLabel = new JLabel();
        this.keystoreLocationTextField = new JTextField();
        this.keystoreLocationButton = new JButton();
        this.keyAliasLabel = new JLabel();
        this.keyPasswordLabel = new JLabel();
        this.keyAliasCombo = new JComboBox();
        this.keystorePasswordField = new JPasswordField();
        this.keyPasswordField = new JPasswordField();
        this.loadkeysButton = new JButton();
        this.aliasSelectorLbl = new JLabel();
        this.aliasSelectorField = new JTextField();
        this.aliasSelectorButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.keystoreLocationLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeyStorePanel_LocationLabel"));
        Mnemonics.setLocalizedText((JLabel)this.keystorePasswordLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_StorePanel_StorePassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.keystoreLocationButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystorePanel_Browse"));
        this.keystoreLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeystorePanel.this.keystoreLocationButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeyStorePanel_KeyAliasLabel"));
        Mnemonics.setLocalizedText((JLabel)this.keyPasswordLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_Keystore_KeyPasswordLabel"));
        this.keyAliasCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.loadkeysButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_LoadKeys"));
        this.loadkeysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeystorePanel.this.loadkeysButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.aliasSelectorLbl, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_Keystore_KeySelectorLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.aliasSelectorButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystorePanel_Browse"));
        this.aliasSelectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeystorePanel.this.aliasSelectorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keystoreLocationLabel).addComponent(this.keystorePasswordLabel).addComponent(this.keyAliasLabel).addComponent(this.keyPasswordLabel).addComponent(this.aliasSelectorLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.keystoreLocationTextField, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keystoreLocationButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.keyAliasCombo, GroupLayout.Alignment.LEADING, 0, 169, Short.MAX_VALUE).addComponent(this.keystorePasswordField, -1, 169, Short.MAX_VALUE).addComponent(this.keyPasswordField, GroupLayout.Alignment.LEADING, -1, 169, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadkeysButton).addGap(68, 68, 68)).addGroup(layout.createSequentialGroup().addComponent(this.aliasSelectorField, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aliasSelectorButton))).addGap(4, 4, 4)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keystoreLocationLabel).addComponent(this.keystoreLocationButton).addComponent(this.keystoreLocationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keystorePasswordLabel).addComponent(this.keystorePasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyAliasLabel).addComponent(this.keyAliasCombo, -2, -1, -2).addComponent(this.loadkeysButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyPasswordLabel).addComponent(this.keyPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aliasSelectorLbl).addComponent(this.aliasSelectorField, -2, -1, -2).addComponent(this.aliasSelectorButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.keyAliasCombo, this.keyPasswordField, this.keystoreLocationTextField, this.keystorePasswordField);
    }

    private void loadkeysButtonActionPerformed(ActionEvent evt) {
        boolean success = this.reloadAliases();
        if (!success) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KeystorePanel.class, (String)"MSG_WrongPassword")));
        }
    }

    private void keystoreLocationButtonActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystoreBrowse_Title"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new StoreFileFilter());
        File f = new File(this.keystoreLocationTextField.getText());
        if (f != null && f.exists()) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.setKeystorePath(file.getPath());
            String extension = FileUtil.getExtension((String)file.getName());
            this.keystoreType = "jks".equals(extension) ? JKS : PKCS12;
        }
    }

    private void aliasSelectorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "com.sun.xml.wss.AliasSelector");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setSelector(selectedClass);
                ProprietarySecurityPolicyModelHelper.setAliasSelector(this.comp, selectedClass, false);
            }
        }
    }

    private boolean reloadAliases() {
        List<String> aliasList;
        try {
            aliasList = Util.getAliases(this.getKeystorePath(), this.getCharKeystorePassword(), this.keystoreType);
        }
        catch (IOException ex) {
            return false;
        }
        this.keyAliasCombo.removeAllItems();
        if (aliasList != null) {
            this.keyAliasCombo.addItem("");
            for (String alias : aliasList) {
                this.keyAliasCombo.addItem(alias);
            }
            if (this.keyAliasCombo.getItemCount() > 1) {
                this.keyAliasCombo.setSelectedIndex(1);
            }
        }
        return true;
    }
}

