/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TxModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OperationPanel
extends SectionInnerPanel {
    private WSDLModel model;
    private Node node;
    private BindingOperation operation;
    private boolean inSync = false;
    private Project project;
    private ConfigVersion cfgVersion;
    private JComboBox txCombo;
    private JLabel txLbl;

    public OperationPanel(SectionView view, Node node, Project p, BindingOperation operation) {
        super(view);
        this.model = operation.getModel();
        this.node = node;
        this.project = p;
        this.operation = operation;
        this.cfgVersion = PolicyModelHelper.getWrittenConfigVersion((WSDLComponent)operation.getParent());
        if (this.cfgVersion == null) {
            this.cfgVersion = ConfigVersion.getDefault();
        }
        this.initComponents();
        this.txCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.txLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.txCombo);
        this.inSync = true;
        this.txCombo.removeAllItems();
        this.txCombo.addItem(ComboConstants.TX_NOTSUPPORTED);
        this.txCombo.addItem(ComboConstants.TX_MANDATORY);
        this.txCombo.addItem(ComboConstants.TX_REQUIRED);
        this.txCombo.addItem(ComboConstants.TX_REQUIRESNEW);
        this.txCombo.addItem(ComboConstants.TX_SUPPORTED);
        this.inSync = false;
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent evt) {
                OperationPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent evt) {
                OperationPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent evt) {
                OperationPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.inSync = true;
        String txValue = TxModelHelper.getTx(this.operation, this.node);
        this.txCombo.setSelectedItem(txValue);
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent source, Object value) {
        if (this.inSync) {
            return;
        }
        if (source.equals(this.txCombo)) {
            String selected;
            this.cfgVersion = PolicyModelHelper.getWrittenConfigVersion((WSDLComponent)this.operation.getParent());
            if (this.cfgVersion == null) {
                this.cfgVersion = ConfigVersion.getDefault();
            }
            if ((selected = (String)this.txCombo.getSelectedItem()) != null && !selected.equals(TxModelHelper.getTx(this.operation, this.node))) {
                TxModelHelper.getInstance(this.cfgVersion).setTx(this.operation, this.node, selected);
            }
        }
        this.enableDisable();
    }

    public void documentChanged(JTextComponent comp, String value) {
        SectionView view = this.getSectionView();
        this.enableDisable();
        if (view != null) {
            view.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return new JButton();
    }

    private void enableDisable() {
        boolean isTomcat = ServerUtils.isTomcat(this.project);
        boolean txConfigEnabled = !isTomcat;
        this.txCombo.setEnabled(txConfigEnabled);
        this.txLbl.setEnabled(txConfigEnabled);
    }

    private void initComponents() {
        this.txLbl = new JLabel();
        this.txCombo = new JComboBox();
        this.txLbl.setLabelFor(this.txCombo);
        Mnemonics.setLocalizedText((JLabel)this.txLbl, (String)NbBundle.getMessage(OperationPanel.class, (String)"LBL_Section_Operation_Tx"));
        this.txCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Not Supported", "Required", "Requires New", "Mandatory", "Supported"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.txLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txCombo, -2, -1, -2).addContainerGap(156, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txLbl).addComponent(this.txCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.txLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_Tx_ACSD"));
        this.txCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_TxCombo_ACSN"));
        this.txCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_TxCombo_ACSD"));
    }
}

