/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.client.PanelEnabler;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.DynamicCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.KerberosConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.StaticCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.ValidatorsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.BindingPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.X509Token;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class CallbackPanel
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private Project project;
    private SectionView view;
    private JaxWsModel jaxwsmodel;
    private WSDLModel serviceModel;
    private WsitProvider wsitProvider;
    private boolean jsr109 = false;
    private String profile;
    private DefaultFormatterFactory tstampff = null;
    private ConfigVersion cfgVersion = null;
    private JFormattedTextField cbTimestampField;
    private JLabel cbTimestampLbl;
    private JPanel credPanel;
    private JComboBox credTypeCombo;
    private JLabel credTypeLabel;
    private JCheckBox devDefaultsChBox;
    private JFormattedTextField iterationField;
    private JLabel iterationLabel;
    private JSeparator jSeparator1;
    private JButton kerberosCfgButton;
    private JButton keyStoreButton;
    private JButton samlBrowseButton;
    private JTextField samlHandlerField;
    private JLabel samlHandlerLabel;
    private JButton trustStoreButton;
    private JButton validatorCfgButton;

    public CallbackPanel(SectionView sectionView, Node node, Binding binding, JaxWsModel jaxWsModel, WSDLModel wSDLModel) {
        super(sectionView);
        Object object;
        this.view = sectionView;
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.serviceModel = wSDLModel;
        this.cfgVersion = PolicyModelHelper.getConfigVersion((WSDLComponent)binding);
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (object = (JAXWSLightSupport)node.getLookup().lookup(JAXWSLightSupport.class)) != null) {
            fileObject = object.getWsdlFolder(false);
        }
        if (fileObject == null) {
            throw new IllegalArgumentException("Cannot find corresponding project: " + node);
        }
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        this.wsitProvider = (WsitProvider)this.project.getLookup().lookup(WsitProvider.class);
        if (this.wsitProvider != null) {
            this.jsr109 = this.wsitProvider.isJsr109Project();
        }
        this.tstampff = new DefaultFormatterFactory();
        object = NumberFormat.getIntegerInstance();
        ((NumberFormat)object).setGroupingUsed(false);
        ((NumberFormat)object).setParseIntegerOnly(true);
        ((NumberFormat)object).setMaximumIntegerDigits(8);
        ((NumberFormat)object).setMaximumFractionDigits(0);
        NumberFormatter numberFormatter = new NumberFormatter((NumberFormat)object);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(99999999));
        this.tstampff.setDefaultFormatter(numberFormatter);
        this.initComponents();
        this.samlHandlerField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlHandlerLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.iterationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.iterationField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.devDefaultsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampField.setFocusLostBehavior(1);
        this.inSync = true;
        this.credTypeCombo.removeAllItems();
        this.credTypeCombo.addItem(ComboConstants.STATIC);
        this.credTypeCombo.addItem(ComboConstants.DYNAMIC);
        this.inSync = false;
        this.addImmediateModifier(this.samlHandlerField);
        this.addImmediateModifier(this.credTypeCombo);
        this.addImmediateModifier(this.devDefaultsChBox);
        this.addImmediateModifier(this.cbTimestampField);
        this.addImmediateModifier(this.iterationField);
        this.sync();
    }

    public void sync() {
        String string;
        this.inSync = true;
        Binding binding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
        this.profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)binding);
        boolean bl = ProfilesModelHelper.isClientDefaultSetupSupported(this.profile);
        boolean bl2 = false;
        if (bl) {
            bl2 = ProfilesModelHelper.isClientDefaultSetupUsed(this.profile, this.binding, (WSDLComponent)binding, this.project);
        }
        this.setChBox(this.devDefaultsChBox, bl2);
        String string2 = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "samlHandler");
        if (string2 != null) {
            this.setCallbackHandler(string2);
        }
        if ((string = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "usernameHandler")) != null && string.length() > 0) {
            this.setCredType(ComboConstants.DYNAMIC, bl2);
            this.credTypeCombo.setSelectedItem(ComboConstants.DYNAMIC);
        } else {
            this.setCredType(ComboConstants.STATIC, bl2);
            this.credTypeCombo.setSelectedItem(ComboConstants.STATIC);
        }
        String string3 = ProprietarySecurityPolicyModelHelper.getHandlerTimestampTimeout(this.binding);
        if (string3 == null) {
            this.cbTimestampField.setText("300");
        } else {
            this.cbTimestampField.setText(string3);
        }
        String string4 = ProprietarySecurityPolicyModelHelper.getHandlerIterations(this.binding);
        if (string4 == null) {
            this.iterationField.setText("1000");
        } else {
            this.iterationField.setText(string4);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private JPanel getPanel(String string, boolean bl) {
        boolean bl2 = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        if (ComboConstants.DYNAMIC.equals(string)) {
            return new DynamicCredsPanel(this.binding, this.project, !bl2 && !bl);
        }
        return new StaticCredsPanel(this.binding, !bl2 && !bl);
    }

    private void setCredType(String string, boolean bl) {
        Object object;
        this.remove(this.credPanel);
        this.credPanel = this.getPanel(string, bl);
        boolean bl2 = true;
        if (this.view != null) {
            object = this.view.getActivePanel();
            bl2 = object == null ? false : object.isActive();
        }
        object = bl2 ? SectionVisualTheme.getSectionActiveBackgroundColor() : SectionVisualTheme.getDocumentBackgroundColor();
        this.credPanel.setBackground((Color)object);
        this.refreshLayout();
    }

    public void setValue(JComponent jComponent, Object object) {
        String string;
        if (this.inSync) {
            return;
        }
        Util.checkMetroLibrary(this.project);
        if (jComponent.equals(this.credTypeCombo)) {
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", null, null, true);
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", null, null, true);
            this.setCredType((String)this.credTypeCombo.getSelectedItem(), this.devDefaultsChBox.isSelected());
        }
        if (jComponent.equals(this.samlHandlerField)) {
            String string2 = this.getCallbackHandler();
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", string2, null, true);
            return;
        }
        if (jComponent.equals(this.iterationField)) {
            string = (String)this.iterationField.getValue();
            if (string == null || string.length() == 0) {
                ProprietarySecurityPolicyModelHelper.setHandlerIterations(this.binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerIterations(this.binding, string, true);
            }
        }
        if (jComponent.equals(this.cbTimestampField)) {
            string = ((Integer)this.cbTimestampField.getValue()).toString();
            if (string == null || string.length() == 0 || "300".equals(string.toString())) {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, string, true);
            }
        }
        if (jComponent.equals(this.devDefaultsChBox)) {
            if (this.devDefaultsChBox.isSelected()) {
                DefaultSettings.fillDefaults(this.project, true, true);
                string = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
                ProfilesModelHelper.setClientDefaults(this.profile, this.binding, (WSDLComponent)string, this.project);
                this.sync();
                this.refreshLayout();
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(false);
                this.credPanel.revalidate();
                this.credPanel.repaint();
            } else {
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(true);
            }
        }
        this.enableDisable();
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        this.enableDisable();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    private void enableDisable() {
        boolean bl = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl) {
            Component[] componentArray;
            boolean bl4;
            this.devDefaultsChBox.setEnabled(true);
            boolean bl5 = this.devDefaultsChBox.isSelected();
            boolean bl6 = true;
            boolean bl7 = true;
            boolean bl8 = false;
            boolean bl9 = bl4 = ConfigVersion.CONFIG_1_0 == this.cfgVersion;
            if (ComboConstants.PROF_USERNAME.equals(this.profile)) {
                bl7 = false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                bl6 = false;
            }
            if (ComboConstants.PROF_KERBEROS.equals(this.profile)) {
                bl6 = false;
                bl7 = false;
                bl8 = true;
            }
            this.keyStoreButton.setEnabled(bl7 && !bl5);
            this.trustStoreButton.setEnabled(bl6 && !bl5);
            this.kerberosCfgButton.setEnabled(bl8 && !bl5);
            this.validatorCfgButton.setEnabled(bl4 && !bl5);
            if (ComboConstants.PROF_USERNAME.equals(this.profile) || ComboConstants.PROF_STSISSUED.equals(this.profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(this.profile) || ComboConstants.PROF_STSISSUEDCERT.equals(this.profile) || ComboConstants.PROF_STSISSUEDSUPPORTING.equals(this.profile) || ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                bl2 = false;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile)) {
                bl3 = false;
            }
            this.credTypeLabel.setEnabled(bl3 && !bl5);
            this.credTypeCombo.setEnabled(bl3 && !bl5);
            this.credPanel.setEnabled(bl3 && !bl5);
            for (Component component : componentArray = this.credPanel.getComponents()) {
                component.setEnabled(bl3 && !bl5);
            }
            this.samlBrowseButton.setEnabled(bl2 && !bl5);
            this.samlHandlerField.setEnabled(bl2 && !bl5);
            this.samlHandlerLabel.setEnabled(bl2 && !bl5);
            this.cbTimestampField.setEnabled(!bl5);
            this.cbTimestampLbl.setEnabled(!bl5);
            this.iterationField.setEnabled(!bl5);
            this.iterationLabel.setEnabled(!bl5);
        } else {
            Component[] componentArray;
            this.credPanel.setEnabled(false);
            for (Component component : componentArray = this.credPanel.getComponents()) {
                component.setEnabled(false);
            }
            this.credTypeCombo.setEnabled(false);
            this.credTypeLabel.setEnabled(false);
            this.devDefaultsChBox.setEnabled(false);
            this.validatorCfgButton.setEnabled(false);
            this.jSeparator1.setEnabled(false);
            this.keyStoreButton.setEnabled(false);
            this.samlBrowseButton.setEnabled(false);
            this.samlHandlerField.setEnabled(false);
            this.samlHandlerLabel.setEnabled(false);
            this.trustStoreButton.setEnabled(false);
        }
        this.refreshLayout();
    }

    public static boolean isStoreConfigRequired(String string, boolean bl, Binding binding) {
        Collection collection;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(binding);
        Collection collection2 = binding.getBindingOperations();
        for (BindingOperation bindingOperation : collection2) {
            object2 = bindingOperation.getBindingInput();
            if (object2 != null) {
                arrayList.add(object2);
            }
            if ((object = bindingOperation.getBindingOutput()) != null) {
                arrayList.add(object);
            }
            collection = bindingOperation.getBindingFaults();
            for (BindingFault bindingFault : collection) {
                if (bindingFault == null) continue;
                arrayList.add(bindingFault);
            }
        }
        for (WSDLComponent wSDLComponent : arrayList) {
            object2 = SecurityTokensModelHelper.getSupportingTokens(wSDLComponent);
            if (object2 == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                collection = (WSDLComponent)object.next();
                WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement((WSDLComponent)collection);
                if (!(wSDLComponent2 instanceof X509Token)) continue;
                return true;
            }
        }
        if (ComboConstants.PROF_TRANSPORT.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string)) {
            return false;
        }
        if (!bl) {
            if (ComboConstants.PROF_USERNAME.equals(string)) {
                return false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                // empty if block
            }
        } else if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
            return false;
        }
        return true;
    }

    private void setCallbackHandler(String string) {
        this.samlHandlerField.setText(string);
    }

    private String getCallbackHandler() {
        return this.samlHandlerField.getText();
    }

    private void refreshLayout() {
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.keyStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton).addGap(6, 6, 6).addComponent(this.validatorCfgButton)).addComponent(this.devDefaultsChBox)).addGap(62, 62, 62)).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.credTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credTypeCombo, -2, -1, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.credPanel, GroupLayout.Alignment.LEADING, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbTimestampLbl).addComponent(this.samlHandlerLabel).addComponent(this.iterationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterationField, -2, 78, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.samlHandlerField, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.samlBrowseButton)).addComponent(this.cbTimestampField, -2, 78, -2))))).addComponent(this.jSeparator1, -1, 549, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStoreButton).addComponent(this.trustStoreButton).addComponent(this.kerberosCfgButton).addComponent(this.validatorCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.credTypeLabel).addComponent(this.credTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samlBrowseButton).addComponent(this.samlHandlerField, -2, -1, -2).addComponent(this.samlHandlerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimestampField, -2, -1, -2).addComponent(this.cbTimestampLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterationLabel).addComponent(this.iterationField, -2, -1, -2)).addContainerGap()));
        groupLayout.linkSize(1, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        this.samlHandlerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSN"));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSD"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSN"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSD"));
        this.credTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSN"));
        this.credTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSD"));
        this.keyStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSN"));
        this.keyStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSD"));
        this.trustStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSN"));
        this.trustStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSD"));
    }

    private void initComponents() {
        this.samlHandlerLabel = new JLabel();
        this.samlHandlerField = new JTextField();
        this.samlBrowseButton = new JButton();
        this.credTypeCombo = new JComboBox();
        this.credTypeLabel = new JLabel();
        this.credPanel = new JPanel();
        this.keyStoreButton = new JButton();
        this.trustStoreButton = new JButton();
        this.devDefaultsChBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.cbTimestampLbl = new JLabel();
        this.cbTimestampField = new JFormattedTextField();
        this.kerberosCfgButton = new JButton();
        this.validatorCfgButton = new JButton();
        this.iterationLabel = new JLabel();
        this.iterationField = new JFormattedTextField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CallbackPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                CallbackPanel.this.formAncestorAdded(ancestorEvent);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.samlHandlerLabel.setLabelFor(this.samlHandlerField);
        Mnemonics.setLocalizedText((JLabel)this.samlHandlerLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.samlBrowseButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton"));
        this.samlBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.samlBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.credTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Static", "Dynamic"}));
        this.credTypeLabel.setLabelFor(this.credTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.credTypeLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel"));
        GroupLayout groupLayout = new GroupLayout(this.credPanel);
        this.credPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 424, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.keyStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore"));
        this.keyStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.keyStoreButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.trustStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore"));
        this.trustStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.trustStoreButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.devDefaultsChBox, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults"));
        Mnemonics.setLocalizedText((JLabel)this.cbTimestampLbl, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_CallbackPanel_Timestamp"));
        this.cbTimestampField.setFormatterFactory(this.tstampff);
        Mnemonics.setLocalizedText((AbstractButton)this.kerberosCfgButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KerberosCfg"));
        this.kerberosCfgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.kerberosCfgButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.validatorCfgButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_ValidatorsCfg"));
        this.validatorCfgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.validatorCfgButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.iterationLabel, (String)"Key Obtention Iterations:");
        this.iterationField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.iterationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.iterationFieldActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(12, 12, 12).addComponent(this.keyStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trustStoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kerberosCfgButton).addGap(6, 6, 6).addComponent(this.validatorCfgButton)).addComponent(this.devDefaultsChBox)).addGap(62, 62, 62)).addGroup(groupLayout2.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.credTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credTypeCombo, -2, -1, -2)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.credPanel, GroupLayout.Alignment.LEADING, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbTimestampLbl).addComponent(this.samlHandlerLabel).addComponent(this.iterationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iterationField, -2, 78, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.samlHandlerField, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.samlBrowseButton)).addComponent(this.cbTimestampField, -2, 78, -2))))).addComponent(this.jSeparator1, -1, 572, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.linkSize(0, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.devDefaultsChBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyStoreButton).addComponent(this.trustStoreButton).addComponent(this.kerberosCfgButton).addComponent(this.validatorCfgButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.credTypeLabel).addComponent(this.credTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.credPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samlBrowseButton).addComponent(this.samlHandlerField, -2, -1, -2).addComponent(this.samlHandlerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTimestampField, -2, -1, -2).addComponent(this.cbTimestampLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iterationLabel).addComponent(this.iterationField, -2, -1, -2)).addContainerGap()));
        groupLayout2.linkSize(1, this.kerberosCfgButton, this.keyStoreButton, this.trustStoreButton, this.validatorCfgButton);
        this.samlHandlerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSN"));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSD"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSN"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSD"));
        this.credTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSN"));
        this.credTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSD"));
        this.keyStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSN"));
        this.keyStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSD"));
        this.trustStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSN"));
        this.trustStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSD"));
    }

    private void trustStoreButtonActionPerformed(ActionEvent actionEvent) {
        TruststorePanel truststorePanel = new TruststorePanel((WSDLComponent)this.binding, this.project, this.jsr109, this.profile, true, this.cfgVersion);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)truststorePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Truststore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            truststorePanel.storeState();
        }
    }

    private void keyStoreButtonActionPerformed(ActionEvent actionEvent) {
        KeystorePanel keystorePanel = new KeystorePanel((WSDLComponent)this.binding, this.project, this.jsr109, true, this.cfgVersion);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)keystorePanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_Keystore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            keystorePanel.storeState();
        }
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }

    private void samlBrowseButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "javax.security.auth.callback.CallbackHandler");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setCallbackHandler(string);
                ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", string, null, true);
            }
        }
    }

    private void kerberosCfgButtonActionPerformed(ActionEvent actionEvent) {
        KerberosConfigPanel kerberosConfigPanel = new KerberosConfigPanel((WSDLComponent)this.binding, this.project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)kerberosConfigPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_KerberosConfig_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            kerberosConfigPanel.storeState();
        }
    }

    private void validatorCfgButtonActionPerformed(ActionEvent actionEvent) {
        ValidatorsPanel validatorsPanel = new ValidatorsPanel((WSDLComponent)this.binding, this.project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)validatorsPanel, NbBundle.getMessage(BindingPanel.class, (String)"LBL_KerberosConfig_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            validatorsPanel.storeState();
        }
    }

    private void iterationFieldActionPerformed(ActionEvent actionEvent) {
    }
}

