/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WSITSafeDeleteRefactoringPlugin
extends WSITRefactoringPlugin<SafeDeleteRefactoring> {
    public WSITSafeDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        super(refactoring);
    }

    @Override
    protected RefactoringElementImplementation createMethodRE(String methodName, WSDLModel model) {
        return new MethodRE(methodName, model);
    }

    @Override
    protected RefactoringElementImplementation createClassRE(WSDLModel model) {
        return new ClassRE(model);
    }

    private static class ClassRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private BackupFacility.Handle id;

        public ClassRE(WSDLModel model) {
            super(model);
        }

        public void performChange() {
            FileObject parentFile = this.getParentFile();
            try {
                this.id = BackupFacility.getDefault().backup(new FileObject[]{parentFile});
                parentFile.delete();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                this.id.restore();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.getParentFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(ClassRE.class, (String)"TXT_WsitXmlClassSafeDelete"), args);
        }
    }

    private static class MethodRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String methodName;

        public MethodRE(String methodName, WSDLModel model) {
            super(model);
            this.methodName = methodName;
        }

        public void performChange() {
            Definitions d = this.model.getDefinitions();
            Binding b = (Binding)d.getBindings().toArray()[0];
            Collection messages = d.getMessages();
            Collection bOperations = b.getBindingOperations();
            PortType portType = (PortType)d.getPortTypes().toArray()[0];
            Collection operations = portType.getOperations();
            this.model.startTransaction();
            for (BindingOperation bOperation : bOperations) {
                if (!this.methodName.equals(bOperation.getName())) continue;
                b.removeBindingOperation(bOperation);
            }
            for (Operation o : operations) {
                if (!this.methodName.equals(o.getName())) continue;
                portType.removeOperation(o);
            }
            for (Message m : messages) {
                if (!this.methodName.equals(m.getName()) && !(this.methodName + "Response").equals(m.getName())) continue;
                d.removeMessage(m);
            }
            this.model.endTransaction();
        }

        public void undoChange() {
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.methodName, this.getParentFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(MethodRE.class, (String)"TXT_WsitXmlMethodSafeDelete"), args);
        }
    }
}

