/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

public class WsitPojectOpenedHook
extends ProjectOpenedHook {
    private static Logger LOG = Logger.getLogger(WsitPojectOpenedHook.class.getCanonicalName());
    private Project project;

    public WsitPojectOpenedHook(Project project) {
        this.project = project;
    }

    protected void projectOpened() {
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        FileObject fileObject = jAXWSSupport.getDeploymentDescriptorFolder();
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        if (fileObject2 == null) {
            return;
        }
        try {
            Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2);
            final Endpoint[] endpointArray = endpoints.getEndpoints();
            MetadataModel metadataModel = jAXWSSupport.getWebservicesMetadataModel();
            metadataModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                public Void run(WebservicesMetadata webservicesMetadata) {
                    for (Endpoint endpoint : endpointArray) {
                        Object object;
                        String string = endpoint.getImplementation();
                        FileObject fileObject = WsitPojectOpenedHook.this.getFileObjectFromClassName(string);
                        if (fileObject == null || (object = fileObject.getAttribute("sts-webservice")) == null || !object.toString().equals("true")) continue;
                        WsitPojectOpenedHook.this.addDescriptorsCleaner(fileObject, string, endpoint.getEndpointName());
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    private void addDescriptorsCleaner(FileObject fileObject, final String string, final String string2) {
        fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                try {
                    JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)WsitPojectOpenedHook.this.project.getProjectDirectory());
                    jAXWSSupport.removeNonJsr109Entries("MEXEndpoint");
                    jAXWSSupport.removeNonJsr109Entries(string);
                    jAXWSSupport.removeNonJsr109Entries(string2);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
        });
    }

    public FileObject getFileObjectFromClassName(String string) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            return null;
        }
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)sourceGroupArray[0].getRootFolder());
        ClassIndex classIndex = classpathInfo.getClassIndex();
        int n = string.lastIndexOf(46) + 1;
        String string2 = string.substring(n);
        Set set = classIndex.getDeclaredTypes(string2, ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle elementHandle : set) {
            if (!string.equals(elementHandle.getQualifiedName())) continue;
            return SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
        }
        return null;
    }

    protected void projectClosed() {
    }
}

