/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.api.WebProjectLibrariesModifier;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;

public class WebWsitProvider
extends WsitProvider {
    private static final Logger logger = Logger.getLogger(WebWsitProvider.class.getName());
    protected static final String SERVLET_NAME = "ServletName";
    protected static final String SERVLET_CLASS = "ServletClass";
    protected static final String URL_PATTERN = "UrlPattern";
    private static final String WS_SERVLET = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String WS_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
    private static final String LISTENER = "Listener";
    private static final String LISTENER_CLASS = "ListenerClass";

    public WebWsitProvider(Project project) {
        this.project = project;
    }

    @Override
    public boolean isJsr109Project() {
        J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(this.project);
        if (j2eePlatform != null) {
            Collection collection = j2eePlatform.getLookup().lookupAll(WSStack.class);
            for (WSStack wSStack : collection) {
                if (!wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public FileObject getConfigFilesFolder(boolean bl, boolean bl2) {
        if (!bl) {
            WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            return webModule.getWebInf();
        }
        return super.getConfigFilesFolder(bl, bl2);
    }

    @Override
    public void addServiceDDEntry(String string, String string2, String string3) {
        boolean bl = ServerUtils.isGlassfish(this.project);
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(webModule.getDeploymentDescriptor());
                Servlet servlet = Util.getServlet(webApp, string);
                if (servlet == null) {
                    try {
                        webApp.addBean(LISTENER, new String[]{LISTENER_CLASS}, new Object[]{WS_LISTENER}, LISTENER_CLASS);
                        servlet = (Servlet)webApp.addBean("Servlet", new String[]{SERVLET_NAME, SERVLET_CLASS}, new Object[]{string, WS_SERVLET}, SERVLET_NAME);
                        servlet.setLoadOnStartup(new BigInteger("1"));
                        webApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{string, "/" + string3 + "Service"}, URL_PATTERN);
                        webApp.addBean("ServletMapping", new String[]{SERVLET_NAME, URL_PATTERN}, new Object[]{string, "/" + string3 + "Service/mex"}, URL_PATTERN);
                        webApp.write(webModule.getDeploymentDescriptor());
                    }
                    catch (NameAlreadyUsedException nameAlreadyUsedException) {
                        nameAlreadyUsedException.printStackTrace();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                } else {
                    servlet.setLoadOnStartup(new BigInteger("1"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public boolean addMetroRtLibrary() {
        Library library = LibraryManager.getDefault().getLibrary("metro");
        if (library != null) {
            try {
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
                if (sourceGroupArray != null && sourceGroupArray.length > 0) {
                    WebProjectLibrariesModifier webProjectLibrariesModifier = (WebProjectLibrariesModifier)this.project.getLookup().lookup(WebProjectLibrariesModifier.class);
                    return webProjectLibrariesModifier.addCompileLibraries(new Library[]{library});
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

