/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ErrorTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.MavenWSITModelSupport;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class MavenWSITEditor
implements WSEditor,
UndoManagerHolder {
    private static final Logger logger = Logger.getLogger(MavenWSITEditor.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService jaxWsService;
    private Project project;
    private UndoManager undoManager;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();
    boolean isClient = false;

    public MavenWSITEditor(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService, Project project) {
        this.jaxWsSupport = jAXWSLightSupport;
        this.jaxWsService = jaxWsService;
        this.project = project;
    }

    public String getTitle() {
        return NbBundle.getMessage(MavenWSITEditor.class, (String)"QOS_EDITOR_TITLE");
    }

    public JComponent createWSEditorComponent(Node node) {
        boolean bl = this.isClient = !this.jaxWsService.isServiceProvider();
        if (this.project != null) {
            try {
                WSDLModel wSDLModel = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, true, this.createdFiles);
                if (this.isClient) {
                    WSDLModel wSDLModel2 = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, true, this.createdFiles);
                    wSDLModel = MavenWSITModelSupport.getServiceModelForClient(this.jaxWsSupport, this.jaxWsService);
                    return new ClientTopComponent(this.jaxWsSupport, this.jaxWsService, wSDLModel2, wSDLModel, node);
                }
                return new ServiceTopComponent(node, this.jaxWsService, wSDLModel, this.getUndoManager());
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
        }
        return new ErrorTopComponent(NbBundle.getMessage(MavenWSITEditor.class, (String)"TXT_WSIT_NotSupported"));
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        try {
            WSDLModel wSDLModel = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, false, this.createdFiles);
            if (wSDLModel != null) {
                WSITModelSupport.save(wSDLModel);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cancel(Node node) {
        FileObject fileObject;
        WSDLModel wSDLModel;
        Project project2;
        Object object;
        if (node == null) {
            return;
        }
        WSDLModel wSDLModel2 = null;
        if (this.isClient && (object = (FileObject)node.getLookup().lookup(FileObject.class)) != null && (project2 = FileOwnerQuery.getOwner((FileObject)object)) != null && (wSDLModel = WSITModelSupport.getMainClientModel(fileObject = MavenWSITEditor.getClientConfigFolder(project2))) != null) {
            Collection collection = wSDLModel.getDefinitions().getImports();
            for (Import import_ : collection) {
                try {
                    WSDLModel wSDLModel3 = import_.getImportedWSDLModel();
                    ModelSource modelSource = wSDLModel3.getModelSource();
                    FileObject fileObject2 = Utilities.getFileObject((ModelSource)modelSource);
                    wSDLModel.startTransaction();
                    if (this.createdFiles.contains(fileObject2)) {
                        wSDLModel.getDefinitions().removeImport(import_);
                    }
                    wSDLModel.endTransaction();
                    FileObject fileObject3 = Utilities.getFileObject((ModelSource)wSDLModel.getModelSource());
                    if (fileObject3 == null) {
                        logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + wSDLModel.getModelSource());
                    }
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject3);
                        if (dataObject == null || !dataObject.isModified()) continue;
                        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                        if (saveCookie != null) {
                            saveCookie.save();
                        }
                        dataObject.setModified(false);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    logger.log(Level.SEVERE, null, illegalStateException);
                }
                catch (CatalogModelException catalogModelException) {
                    logger.log(Level.SEVERE, null, catalogModelException);
                }
            }
        }
        try {
            wSDLModel2 = MavenWSITModelSupport.getModel(node, this.project, this.jaxWsSupport, this.jaxWsService, this, false, this.createdFiles);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (wSDLModel2 != null) {
            void var4_9;
            try {
                if (this.getUndoManager() != null) {
                    while (this.getUndoManager().canUndo()) {
                        this.getUndoManager().undo();
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
            object = Utilities.getFileObject((ModelSource)wSDLModel2.getModelSource());
            Object var4_7 = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)object);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                logger.log(Level.SEVERE, null, dataObjectNotFoundException);
            }
            if (var4_9 != null) {
                try {
                    wSDLModel2.sync();
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
                var4_9.setModified(false);
                var4_9.setModified(true);
                var4_9.setModified(false);
            }
        }
        if (this.createdFiles != null && this.createdFiles.size() > 0) {
            for (FileObject fileObject4 : this.createdFiles) {
                if (fileObject4 == null) continue;
                try {
                    fileObject = DataObject.find((FileObject)fileObject4);
                    if (fileObject == null) continue;
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    public static FileObject getClientConfigFolder(Project project) {
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            return wsitProvider.getConfigFilesFolder(true);
        }
        FileObject fileObject = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
            if (fileObject != null) {
                fileObject = fileObject.getFileObject("META-INF");
            }
            if (fileObject == null || !fileObject.isValid()) {
                try {
                    fileObject = sourceGroupArray[0].getRootFolder().createFolder("META-INF");
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
            }
        }
        return fileObject;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public String getDescription() {
        return NbBundle.getMessage(MavenWSITEditor.class, (String)"WSIT_CONFIG_DESC");
    }
}

