/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsruntimemodel;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavaWsdlMapper {
    public static final String RESPONSE = "Response";
    public static final String RETURN = "return";
    public static final String BEAN = "Bean";
    public static final String SERVICE = "Service";
    public static final String PORT = "Port";
    public static final String PORT_TYPE = "PortType";
    public static final String BINDING = "Binding";
    private static final String JAVAX_JWS_WEBSERVICE = "javax.jws.WebService";
    private static final String UTF8 = "UTF-8";
    public static final int UNKNOWN = -1;
    public static final int OUTPUTINPUT = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT = 2;

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                namespace.append('.');
            }
            namespace.append(tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    public static QName getServiceName(FileObject implClass) {
        final String[] serviceNameQNameARR = new String[2];
        if (implClass == null) {
            return null;
        }
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    if (sourceUtils == null) {
                        return;
                    }
                    TypeElement te = sourceUtils.getTypeElement();
                    serviceNameQNameARR[0] = te.getSimpleName().toString() + JavaWsdlMapper.SERVICE;
                    String packageName = JavaWsdlMapper.getPackageFromClass(te.getQualifiedName().toString());
                    serviceNameQNameARR[1] = JavaWsdlMapper.getNamespace(packageName);
                    AnnotationMirror annotation = JavaWsdlMapper.getAnnotation(te, JavaWsdlMapper.JAVAX_JWS_WEBSERVICE);
                    if (annotation != null) {
                        String serviceNameAnnot = null;
                        String targetNamespaceAnnot = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                            ExecutableElement el = ex.getKey();
                            String val = (String)ex.getValue().getValue();
                            if (el.getSimpleName().contentEquals("serviceName")) {
                                serviceNameAnnot = val;
                                if (serviceNameAnnot != null) {
                                    serviceNameAnnot = URLEncoder.encode(serviceNameAnnot, JavaWsdlMapper.UTF8);
                                }
                            } else if (el.getSimpleName().contentEquals("targetNamespace") && (targetNamespaceAnnot = val) != null) {
                                targetNamespaceAnnot = URLEncoder.encode(targetNamespaceAnnot, JavaWsdlMapper.UTF8);
                            }
                            if (targetNamespaceAnnot == null || serviceNameAnnot == null) continue;
                            break;
                        }
                        if (serviceNameAnnot != null) {
                            serviceNameQNameARR[0] = serviceNameAnnot;
                        }
                        if (targetNamespaceAnnot != null) {
                            serviceNameQNameARR[1] = targetNamespaceAnnot;
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (serviceNameQNameARR[0] == null) {
            return null;
        }
        return new QName(serviceNameQNameARR[1], serviceNameQNameARR[0]);
    }

    public static String getBindingName(FileObject implClass, String targetNamespace) {
        QName portName = JavaWsdlMapper.getPortName(implClass, targetNamespace);
        if (portName != null) {
            return portName.getLocalPart() + BINDING;
        }
        return null;
    }

    public static List<String> getOperationFaults(FileObject implClass, final String operationName) {
        if (implClass == null || operationName == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList<String> faults = new ArrayList<String>();
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    TypeElement te = sourceUtils.getTypeElement();
                    List<? extends Element> members = te.getEnclosedElements();
                    List<ExecutableElement> methods = ElementFilter.methodsIn(members);
                    for (ExecutableElement method : methods) {
                        Set<Modifier> modifiers = method.getModifiers();
                        if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                        AnnotationMirror an = JavaWsdlMapper.getAnnotation(method, "javax.jws.WebMethod");
                        boolean hasWebMethodAnnotation = false;
                        String nameAnnot = null;
                        if (hasWebMethodAnnotation) {
                            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = an.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                                ExecutableElement executableElement = ex.getKey();
                                String val = (String)ex.getValue().getValue();
                                if (executableElement.getSimpleName().contentEquals("operationName") && (nameAnnot = val) != null) {
                                    nameAnnot = URLEncoder.encode(nameAnnot, JavaWsdlMapper.UTF8);
                                }
                                if (nameAnnot == null) continue;
                                break;
                            }
                        }
                        String opName = method.getSimpleName().toString();
                        if (hasWebMethodAnnotation && nameAnnot != null) {
                            opName = nameAnnot;
                        }
                        if (!operationName.equals(opName)) continue;
                        List<? extends TypeMirror> excs = method.getThrownTypes();
                        for (TypeMirror typeMirror : excs) {
                            String tName = JavaWsdlMapper.getTypeName(controller, typeMirror);
                            if (tName == null) continue;
                            faults.add(tName);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return faults;
    }

    static String getTypeName(CompilationController controller, TypeMirror typeMirror) {
        TypeKind typeKind = typeMirror.getKind();
        switch (typeKind) {
            case BOOLEAN: {
                return "boolean";
            }
            case BYTE: {
                return "byte";
            }
            case CHAR: {
                return "char";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case VOID: {
                return "void";
            }
            case ERROR: 
            case DECLARED: {
                if (!(typeMirror instanceof DeclaredType)) break;
                Element element = controller.getTypes().asElement(typeMirror);
                return ((TypeElement)element).getSimpleName().toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                Element componentTypeElement = controller.getTypes().asElement(arrayType.getComponentType());
                return ((TypeElement)componentTypeElement).getSimpleName().toString() + "[]";
            }
        }
        return null;
    }

    public static List<String> getOperationNames(FileObject implClass) {
        final ArrayList<String> operations = new ArrayList<String>();
        if (implClass == null) {
            return null;
        }
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    TypeElement te = sourceUtils.getTypeElement();
                    List<? extends Element> members = te.getEnclosedElements();
                    List<ExecutableElement> methods = ElementFilter.methodsIn(members);
                    boolean foundWebMethodAnnotation = false;
                    for (ExecutableElement method : methods) {
                        Set<Modifier> modifiers = method.getModifiers();
                        if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
                        boolean hasWebMethodAnnotation = false;
                        String nameAnnot = null;
                        AnnotationMirror an = JavaWsdlMapper.getAnnotation(method, "javax.jws.WebMethod");
                        boolean bl = hasWebMethodAnnotation = an != null;
                        if (hasWebMethodAnnotation) {
                            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = an.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                                ExecutableElement el = ex.getKey();
                                String val = (String)ex.getValue().getValue();
                                if (el.getSimpleName().contentEquals("operationName") && (nameAnnot = val) != null) {
                                    nameAnnot = URLEncoder.encode(nameAnnot, JavaWsdlMapper.UTF8);
                                }
                                if (nameAnnot == null) continue;
                                break;
                            }
                        }
                        if (hasWebMethodAnnotation) {
                            if (!foundWebMethodAnnotation) {
                                foundWebMethodAnnotation = true;
                                if (!operations.isEmpty()) {
                                    operations.clear();
                                }
                            }
                            if (nameAnnot != null) {
                                operations.add(nameAnnot);
                                continue;
                            }
                            operations.add(method.getSimpleName().toString());
                            continue;
                        }
                        operations.add(method.getSimpleName().toString());
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return operations;
    }

    public static QName getPortTypeName(FileObject implClass) {
        final String[] portTypeQNameARR = new String[2];
        if (implClass == null) {
            return null;
        }
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    TypeElement te = sourceUtils.getTypeElement();
                    portTypeQNameARR[0] = te.getSimpleName().toString();
                    AnnotationMirror annotation = JavaWsdlMapper.getAnnotation(te, JavaWsdlMapper.JAVAX_JWS_WEBSERVICE);
                    if (annotation != null) {
                        String nameAnnot = null;
                        String targetNamespaceAnnot = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                            ExecutableElement el = ex.getKey();
                            String val = (String)ex.getValue().getValue();
                            if (el.getSimpleName().contentEquals("name")) {
                                nameAnnot = val;
                                if (nameAnnot != null) {
                                    nameAnnot = URLEncoder.encode(nameAnnot, JavaWsdlMapper.UTF8);
                                }
                            } else if (el.getSimpleName().contentEquals("targetNamespace") && (targetNamespaceAnnot = val) != null) {
                                targetNamespaceAnnot = URLEncoder.encode(targetNamespaceAnnot, JavaWsdlMapper.UTF8);
                            }
                            if (targetNamespaceAnnot == null || nameAnnot == null) continue;
                            break;
                        }
                        if (nameAnnot != null && nameAnnot.length() > 0) {
                            portTypeQNameARR[0] = nameAnnot;
                        }
                        String pkg = JavaWsdlMapper.getPackageFromClass(te.getQualifiedName().toString());
                        String targetNamespace = targetNamespaceAnnot;
                        if (targetNamespace == null || targetNamespace.length() == 0) {
                            targetNamespace = JavaWsdlMapper.getNamespace(pkg);
                        }
                        portTypeQNameARR[1] = targetNamespace;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new QName(portTypeQNameARR[1], portTypeQNameARR[0]);
    }

    public static String getWsdlLocation(FileObject implClass) {
        final String[] wsdlLocARR = new String[1];
        try {
            if (implClass == null) {
                return null;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    TypeElement te = sourceUtils.getTypeElement();
                    AnnotationMirror annotation = JavaWsdlMapper.getAnnotation(te, JavaWsdlMapper.JAVAX_JWS_WEBSERVICE);
                    if (annotation != null) {
                        String wsdlLoc = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                            ExecutableElement el = ex.getKey();
                            String val = (String)ex.getValue().getValue();
                            if (el.getSimpleName().contentEquals("wsdlLocation") && (wsdlLoc = val) != null) {
                                wsdlLoc = URLEncoder.encode(wsdlLoc, JavaWsdlMapper.UTF8);
                            }
                            if (wsdlLoc == null) continue;
                            break;
                        }
                        wsdlLocARR[1] = wsdlLoc;
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return wsdlLocARR[0];
    }

    public static QName getPortName(FileObject implClass, final String targetNamespace) {
        final String[] portNameQNameARR = new String[2];
        if (implClass == null) {
            return null;
        }
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)implClass);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    TypeElement te = sourceUtils.getTypeElement();
                    String className = te.getSimpleName().toString();
                    AnnotationMirror annotation = JavaWsdlMapper.getAnnotation(te, JavaWsdlMapper.JAVAX_JWS_WEBSERVICE);
                    if (annotation != null) {
                        String portNameAnnot = null;
                        String nameAnnot = null;
                        String targetNamespaceAnnot = null;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ex : expressions.entrySet()) {
                            ExecutableElement el = ex.getKey();
                            String val = (String)ex.getValue().getValue();
                            if (el.getSimpleName().contentEquals("name")) {
                                nameAnnot = val;
                                if (nameAnnot != null) {
                                    nameAnnot = URLEncoder.encode(nameAnnot, JavaWsdlMapper.UTF8);
                                }
                            } else if (el.getSimpleName().contentEquals("portName")) {
                                portNameAnnot = val;
                                if (portNameAnnot != null) {
                                    portNameAnnot = URLEncoder.encode(portNameAnnot, JavaWsdlMapper.UTF8);
                                }
                            } else if (el.getSimpleName().contentEquals("targetNamespace") && (targetNamespaceAnnot = val) != null) {
                                targetNamespaceAnnot = URLEncoder.encode(targetNamespaceAnnot, JavaWsdlMapper.UTF8);
                            }
                            if (targetNamespaceAnnot == null || nameAnnot == null || portNameAnnot == null) continue;
                            break;
                        }
                        portNameQNameARR[0] = portNameAnnot != null && portNameAnnot.length() > 0 ? portNameAnnot : (nameAnnot != null && nameAnnot.length() > 0 ? nameAnnot + JavaWsdlMapper.PORT : className + JavaWsdlMapper.PORT);
                        if (targetNamespace == null) {
                            if (targetNamespaceAnnot != null && targetNamespaceAnnot.length() > 0) {
                                portNameQNameARR[1] = targetNamespaceAnnot;
                            } else {
                                String packageName = JavaWsdlMapper.getPackageFromClass(className);
                                portNameQNameARR[1] = JavaWsdlMapper.getNamespace(packageName);
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new QName(portNameQNameARR[1], portNameQNameARR[0]);
    }

    public static String getPackageFromClass(String fqClassName) {
        return fqClassName.substring(0, fqClassName.lastIndexOf(46));
    }

    private static AnnotationMirror getAnnotation(Element element, String fqn) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Name name;
            Element annotation = annotationMirror.getAnnotationType().asElement();
            if (!(annotation instanceof TypeElement) || !fqn.contentEquals(name = ((TypeElement)annotation).getQualifiedName())) continue;
            return annotationMirror;
        }
        return null;
    }
}

