/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.wadl.config;

import com.sun.jersey.api.wadl.config.WadlGeneratorDescription;
import com.sun.jersey.api.wadl.config.WadlGeneratorLoader;
import com.sun.jersey.server.wadl.WadlGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class WadlGeneratorConfig {
    private WadlGenerator _wadlGenerator;

    public WadlGeneratorConfig() {
    }

    public WadlGeneratorConfig(WadlGenerator wadlGenerator) {
        if (wadlGenerator == null) {
            throw new IllegalArgumentException("The wadl generator must not be null.");
        }
        this._wadlGenerator = wadlGenerator;
    }

    public abstract List<WadlGeneratorDescription> configure();

    public synchronized WadlGenerator getWadlGenerator() {
        if (this._wadlGenerator == null) {
            List<WadlGeneratorDescription> wadlGeneratorDescriptions = this.configure();
            try {
                this._wadlGenerator = WadlGeneratorLoader.loadWadlGeneratorDescriptions(wadlGeneratorDescriptions);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load wadl generators from wadlGeneratorDescriptions.", e);
            }
        }
        return this._wadlGenerator;
    }

    public static WadlGeneratorConfigDescriptionBuilder generator(Class<? extends WadlGenerator> generatorClass) {
        return new WadlGeneratorConfigDescriptionBuilder().generator(generatorClass);
    }

    public static WadlGeneratorConfigBuilder generator(WadlGenerator generator) {
        return new WadlGeneratorConfigBuilder().generator(generator);
    }

    public static class WadlGeneratorConfigBuilder {
        private List<WadlGenerator> _generators = new ArrayList<WadlGenerator>();

        public WadlGeneratorConfigBuilder generator(WadlGenerator generator) {
            if (generator == null) {
                throw new IllegalArgumentException("The wadl generator must not be null.");
            }
            this._generators.add(generator);
            return this;
        }

        public WadlGeneratorConfig build() {
            try {
                WadlGenerator wadlGenerator = WadlGeneratorLoader.loadWadlGenerators(this._generators);
                return new WadlGeneratorConfigGeneratorImpl(wadlGenerator){};
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load wadl generators.", e);
            }
        }
    }

    public static class WadlGeneratorConfigDescriptionBuilder {
        private List<WadlGeneratorDescription> _descriptions = new ArrayList<WadlGeneratorDescription>();
        private WadlGeneratorDescription _description;

        public WadlGeneratorConfigDescriptionBuilder generator(Class<? extends WadlGenerator> generatorClass) {
            if (this._description != null) {
                this._descriptions.add(this._description);
            }
            this._description = new WadlGeneratorDescription();
            this._description.setGeneratorClass(generatorClass);
            return this;
        }

        public WadlGeneratorConfigDescriptionBuilder prop(String propName, Object propValue) {
            if (this._description.getProperties() == null) {
                this._description.setProperties(new Properties());
            }
            this._description.getProperties().put(propName, propValue);
            return this;
        }

        public List<WadlGeneratorDescription> descriptions() {
            if (this._description != null) {
                this._descriptions.add(this._description);
            }
            return this._descriptions;
        }

        public WadlGeneratorConfig build() {
            if (this._description != null) {
                this._descriptions.add(this._description);
            }
            return new WadlGeneratorConfigImpl(this._descriptions);
        }
    }

    static class WadlGeneratorConfigGeneratorImpl
    extends WadlGeneratorConfig {
        private final WadlGenerator _wadlGenerator;

        public WadlGeneratorConfigGeneratorImpl(WadlGenerator wadlGenerator) {
            this._wadlGenerator = wadlGenerator;
        }

        @Override
        public List<WadlGeneratorDescription> configure() {
            throw new UnsupportedOperationException("Must not be called");
        }

        @Override
        public synchronized WadlGenerator getWadlGenerator() {
            return this._wadlGenerator;
        }
    }

    static class WadlGeneratorConfigImpl
    extends WadlGeneratorConfig {
        public List<WadlGeneratorDescription> _descriptions;

        public WadlGeneratorConfigImpl(List<WadlGeneratorDescription> descriptions) {
            this._descriptions = descriptions;
        }

        @Override
        public List<WadlGeneratorDescription> configure() {
            return this._descriptions;
        }
    }
}

