/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.spi.util;

import com.sun.enterprise.container.common.spi.util.JavaEEObjectInputStream;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectOutputStream;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectStreamHandler;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class JavaEEObjectStreamFactory {
    @Inject
    Habitat habitat;
    public static final Logger _logger = LogDomains.getLogger(JavaEEObjectStreamFactory.class, (String)"javax.enterprise.system.util");
    private static Collection<JavaEEObjectStreamHandler> _empty = new ArrayList<JavaEEObjectStreamHandler>();

    public ObjectOutputStream createObjectOutputStream(final OutputStream os, final boolean replaceObject) throws IOException {
        Collection handlers;
        ObjectOutputStream oos = null;
        Collection collection = handlers = replaceObject ? this.habitat.getAllByContract(JavaEEObjectStreamHandler.class) : _empty;
        if (System.getSecurityManager() == null) {
            oos = new JavaEEObjectOutputStream(os, replaceObject, handlers);
        } else {
            try {
                oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new JavaEEObjectOutputStream(os, replaceObject, handlers);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (IOException)ex.getException();
            }
        }
        return oos;
    }

    public ObjectInputStream createObjectInputStream(final InputStream is, final boolean resolveObject, final ClassLoader loader) throws Exception {
        Object ois = null;
        if (loader != null) {
            Collection handlers;
            Collection collection = handlers = resolveObject ? this.habitat.getAllByContract(JavaEEObjectStreamHandler.class) : _empty;
            if (System.getSecurityManager() == null) {
                ois = new JavaEEObjectInputStream(is, loader, resolveObject, handlers);
            } else {
                try {
                    ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new JavaEEObjectInputStream(is, loader, resolveObject, handlers);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
            }
        } else {
            ois = new ObjectInputStream(is);
        }
        return ois;
    }

    public final byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        byte[] data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(bos, replaceObject);
            oos.writeObject(obj);
            oos.flush();
            data = bos.toByteArray();
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception th) {
            IOException ioEx = new IOException(th.toString());
            ioEx.initCause(th);
            throw ioEx;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ex) {}
            }
            try {
                bos.close();
            }
            catch (Exception ex) {}
        }
        return data;
    }

    public final Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader classLoader) throws Exception {
        Object obj = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = this.createObjectInputStream(bis, resolveObject, classLoader);
            obj = ois.readObject();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Error during deserialization", ex);
            throw ex;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Error during ois.close()", ex);
            }
            try {
                bis.close();
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "Error during bis.close()", ex);
            }
        }
        return obj;
    }
}

