/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class LogService {
    private static final Logger logger = Logger.getLogger("com.sun.enterprise.tools.upgrade");
    private static final String LOG_FILE_PATTERN = "upgrade.log";
    private static final Handler defaultHandler = LogService.createLogHandler();

    public static Logger getLogger() {
        return logger;
    }

    public static Formatter createFormatter() {
        return new UpgradeFormatter();
    }

    private static Handler createLogHandler() {
        StreamHandler handler = null;
        try {
            handler = new FileHandler(LOG_FILE_PATTERN, false);
        }
        catch (IOException ioe) {
            System.err.println(String.format("Could not create log '%s' due to error '%s'", LOG_FILE_PATTERN, ioe.getLocalizedMessage()));
            System.err.println("Will send logs to standard.err instead.");
            handler = new StreamHandler(System.err, new UpgradeFormatter());
        }
        return handler;
    }

    static {
        defaultHandler.setFormatter(new UpgradeFormatter());
        logger.addHandler(defaultHandler);
        logger.setUseParentHandlers(false);
    }

    private static class UpgradeFormatter
    extends Formatter {
        private UpgradeFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return record.getMessage() + "\n";
        }
    }
}

