/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Branding {
    private static final Logger logger = LogService.getLogger();
    private static final Level DEBUG_LEVEL = Level.FINE;
    private static final String BUNDLE_PACKAGE = "com.sun.enterprise.tools.upgrade.branding";
    private static final String BUNDLE_NAME = "com.sun.enterprise.tools.upgrade.branding.LocalStrings";
    private static final StringManager sm = Branding.resolveStringManager();

    private static StringManager resolveStringManager() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            if (logger.isLoggable(DEBUG_LEVEL)) {
                logger.fine("Looking for external branding bundle.");
            }
            ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault(), loader);
            if (logger.isLoggable(DEBUG_LEVEL)) {
                logger.fine("Found external branding bundle.");
            }
        }
        catch (MissingResourceException mre) {
            if (logger.isLoggable(DEBUG_LEVEL)) {
                logger.log(DEBUG_LEVEL, "Did not find branding bundle. Will use default strings.", mre);
            }
            return null;
        }
        if (logger.isLoggable(DEBUG_LEVEL)) {
            logger.fine(String.format("Retrieving StringManager with package %s", BUNDLE_PACKAGE));
        }
        return StringManager.getManager(BUNDLE_PACKAGE, loader);
    }

    public static String getString(String key, StringManager defaultSM) {
        if (sm == null) {
            return defaultSM.getString(key);
        }
        return sm.getString(key);
    }

    public static String getString(String key, StringManager defaultSM, Object arg) {
        if (sm == null) {
            return defaultSM.getString(key, arg);
        }
        return sm.getString(key, arg);
    }

    public static URL getWizardUrl(String defaultURLString) {
        String brandedURLString = "com/sun/enterprise/tools/upgrade/branding/Appserv_upgrade_wizard.gif";
        if (sm == null) {
            brandedURLString = defaultURLString;
        }
        return ClassLoader.getSystemClassLoader().getResource(brandedURLString);
    }

    public static String getHSString(String defaultHSString) {
        return sm == null ? defaultHSString : "com/sun/enterprise/tools/upgrade/branding/javahelp/UpgradeToolHelp.hs";
    }

    static {
        if (logger.isLoggable(DEBUG_LEVEL) && sm != null) {
            logger.log(DEBUG_LEVEL, "Test message. Here's GUI title:" + sm.getString("upgrade.gui.mainframe.titleMessage", "---"));
        }
    }
}

