/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;

public class NavigationHistoryManager {
    private HeapFragmentWalker heapFragmentWalker;
    private List<NavigationHistoryItem> backHistory;
    private List<NavigationHistoryItem> forwardHistory;

    public NavigationHistoryManager(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.backHistory = new ArrayList<NavigationHistoryItem>();
        this.forwardHistory = new ArrayList<NavigationHistoryItem>();
    }

    public boolean isNavigationBackAvailable() {
        return !this.backHistory.isEmpty();
    }

    public boolean isNavigationForwardAvailable() {
        return !this.forwardHistory.isEmpty();
    }

    public void createNavigationHistoryPoint() {
        NavigationHistoryCapable source;
        NavigationHistoryItem item = this.createCurrentHistoryItem();
        if (item != null) {
            this.backHistory.add(item);
        }
        if ((source = this.heapFragmentWalker.getNavigationHistorySource()) != null) {
            this.forwardHistory.clear();
        }
    }

    public void navigateBack() {
        if (!this.isNavigationBackAvailable()) {
            return;
        }
        NavigationHistoryItem item = this.backHistory.remove(this.backHistory.size() - 1);
        NavigationHistoryItem reverseItem = this.createCurrentHistoryItem();
        if (reverseItem != null) {
            this.forwardHistory.add(reverseItem);
        }
        try {
            item.getSource().configure(item.getConfiguration());
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
        }
    }

    public void navigateForward() {
        if (!this.isNavigationForwardAvailable()) {
            return;
        }
        NavigationHistoryItem item = this.forwardHistory.remove(this.forwardHistory.size() - 1);
        NavigationHistoryItem reverseItem = this.createCurrentHistoryItem();
        if (reverseItem != null) {
            this.backHistory.add(reverseItem);
        }
        try {
            item.getSource().configure(item.getConfiguration());
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
        }
    }

    private NavigationHistoryItem createCurrentHistoryItem() {
        Configuration configuration;
        NavigationHistoryCapable source = this.heapFragmentWalker.getNavigationHistorySource();
        if (source != null && (configuration = source.getCurrentConfiguration()) != null) {
            return new NavigationHistoryItem(source, configuration);
        }
        return null;
    }

    public static class Configuration {
    }

    public static interface NavigationHistoryCapable {
        public Configuration getCurrentConfiguration();

        public void configure(Configuration var1);
    }

    private static class NavigationHistoryItem {
        private Configuration configuration;
        private NavigationHistoryCapable source;

        public NavigationHistoryItem(NavigationHistoryCapable source, Configuration configuration) {
            this.source = source;
            this.configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public NavigationHistoryCapable getSource() {
            return this.source;
        }
    }
}

