/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.CompareSnapshotsHelper;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesListControllerUI;
import org.openide.util.Lookup;

public class ClassesListController
extends AbstractController {
    public static final int FILTER_SUBCLASS = 1001;
    private ClassesController classesController;
    private JavaClass selectedClass;
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    public long minDiff;
    public long maxDiff;
    private List diffClasses;
    private boolean comparingSnapshot = false;

    public ClassesListController(ClassesController classesController) {
        this.classesController = classesController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public void setColumnVisibility(int column, boolean isColumnVisible) {
        ((ClassesListControllerUI)((Object)this.getPanel())).setColumnVisibility(column, isColumnVisible);
    }

    public Object[][] getData(String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize, int sortingColumn, boolean sortingOrder, int columnCount) {
        boolean diff = this.isDiff();
        long totalLiveInstances = this.classesController.getHeapFragmentWalker().getTotalLiveInstances();
        long totalLiveBytes = this.classesController.getHeapFragmentWalker().getTotalLiveBytes();
        List classes = this.getFilteredSortedClasses(filterStrings, filterType, showZeroInstances, showZeroSize, sortingColumn, sortingOrder);
        Object[][] data = new Object[classes.size()][columnCount + 1];
        this.minDiff = Long.MAX_VALUE;
        this.maxDiff = Long.MIN_VALUE;
        for (int i = 0; i < classes.size(); ++i) {
            JavaClass jClass = (JavaClass)classes.get(i);
            int instancesCount = jClass.getInstancesCount();
            long allInstancesSize = jClass.getAllInstancesSize();
            data[i][0] = jClass.getName();
            if (this.isDiff()) {
                this.minDiff = Math.min(this.minDiff, (long)instancesCount);
                this.maxDiff = Math.max(this.maxDiff, (long)instancesCount);
                data[i][1] = new Long(instancesCount);
                data[i][2] = (instancesCount > 0 ? "+" : "") + numberFormat.format(instancesCount);
                data[i][3] = (allInstancesSize > 0L ? "+" : "") + numberFormat.format(allInstancesSize);
            } else {
                data[i][1] = new Double((double)instancesCount / (double)totalLiveInstances * 100.0);
                data[i][2] = numberFormat.format(instancesCount) + " (" + percentFormat.format((double)instancesCount / (double)totalLiveInstances) + ")";
                data[i][3] = allInstancesSize < 0L ? Bundle.ClassesListController_ResultNotAvailableString() : numberFormat.format(allInstancesSize) + " (" + percentFormat.format((double)allInstancesSize / (double)totalLiveBytes) + ")";
            }
            data[i][4] = diff ? ((DiffJavaClass)jClass).getJavaClass() : jClass;
        }
        if (this.minDiff > 0L && this.maxDiff > 0L) {
            this.minDiff = 0L;
        } else if (this.minDiff < 0L && this.maxDiff < 0L) {
            this.maxDiff = 0L;
        }
        return data;
    }

    public List getFilteredSortedClasses(String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize, int sortingColumn, boolean sortingOrder) {
        List filteredClasses;
        HeapFragmentWalker fragmentWalker = this.classesController.getHeapFragmentWalker();
        Heap heap = fragmentWalker.getHeapFragment();
        if (filterType == 1001 && filterStrings != null && !filterStrings[0].isEmpty()) {
            filteredClasses = ClassesListController.getFilteredClasses(ClassesListController.getSubclasses(heap, this.diffClasses, filterStrings, fragmentWalker.getHeapDumpProject()), null, 0, showZeroInstances, showZeroSize);
        } else {
            List classes = this.diffClasses == null ? heap.getAllClasses() : this.diffClasses;
            filteredClasses = ClassesListController.getFilteredClasses(classes, filterStrings, filterType, showZeroInstances, showZeroSize);
        }
        return ClassesListController.getSortedClasses(filteredClasses, sortingColumn, sortingOrder);
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public void classSelected(JavaClass javaClass) {
        if (this.selectedClass == javaClass) {
            return;
        }
        this.selectedClass = javaClass;
        this.classesController.classSelected();
    }

    public static boolean matchesFilter(JavaClass jClass, String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize) {
        int instancesCount = jClass.getInstancesCount();
        int instanceSize = jClass.getInstanceSize();
        if (!showZeroInstances && instancesCount == 0) {
            return false;
        }
        if (!(showZeroSize || instancesCount != 0 && instanceSize != 0)) {
            return false;
        }
        if (filterType == 0 || filterStrings == null || filterStrings[0].isEmpty()) {
            return true;
        }
        return ClassesListController.passesFilters(jClass.getName(), filterStrings, filterType);
    }

    public void selectClass(JavaClass javaClass) {
        ((ClassesListControllerUI)((Object)this.getPanel())).selectClass(javaClass);
    }

    public void updateData() {
        ((ClassesListControllerUI)((Object)this.getPanel())).updateData();
    }

    private void showDiffProgress() {
        ((ClassesListControllerUI)((Object)this.getPanel())).showDiffProgress();
    }

    private void hideDiffProgress() {
        ((ClassesListControllerUI)((Object)this.getPanel())).hideDiffProgress();
    }

    public void compareAction() {
        if (this.comparingSnapshot) {
            return;
        }
        this.comparingSnapshot = true;
        BrowserUtils.performTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    try {
                        HeapFragmentWalker hfw = ClassesListController.this.classesController.getHeapFragmentWalker();
                        File dumpFile = CompareSnapshotsHelper.selectSnapshot(hfw);
                        if (dumpFile == null) break block8;
                        try {
                            ClassesListController.this.showDiffProgress();
                            Heap currentHeap = hfw.getHeapFragment();
                            Heap diffHeap = HeapFactory.createHeap((File)dumpFile);
                            ClassesListController.this.diffClasses = ClassesListController.createDiffClasses(diffHeap, currentHeap);
                        }
                        catch (Exception e) {
                            ProfilerDialogs.displayError((String)Bundle.ClassesListController_CompareFailed());
                            ProfilerLogger.log((Exception)e);
                        }
                        finally {
                            ClassesListController.this.hideDiffProgress();
                        }
                        ClassesListController.this.updateData();
                    }
                    finally {
                        ClassesListController.this.comparingSnapshot = false;
                    }
                }
            }
        });
    }

    public boolean isDiff() {
        return this.diffClasses != null;
    }

    private static List createDiffClasses(Heap h1, Heap h2) {
        HashMap<String, DiffJavaClass> classes = new HashMap<String, DiffJavaClass>();
        List classes1 = h1.getAllClasses();
        for (JavaClass jc1 : classes1) {
            String id1 = DiffJavaClass.createID(jc1);
            DiffJavaClass djc1 = DiffJavaClass.createExternal(jc1);
            classes.put(id1, djc1);
        }
        List classes2 = h2.getAllClasses();
        for (JavaClass jc2 : classes2) {
            String id2 = DiffJavaClass.createID(jc2);
            DiffJavaClass djc2 = DiffJavaClass.createReal(jc2);
            DiffJavaClass djc1 = (DiffJavaClass)classes.get(id2);
            if (djc1 != null) {
                djc1.diff(djc2);
                continue;
            }
            classes.put(id2, djc2);
        }
        return new ArrayList(classes.values());
    }

    public void resetDiffAction() {
        if (this.diffClasses != null) {
            this.diffClasses.clear();
            this.diffClasses = null;
        }
        this.hideDiffProgress();
        this.updateData();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ClassesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ClassesListControllerUI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getContextSubclasses(Heap heap, String className, Lookup.Provider project) {
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandleFactory.createHandle((String)Bundle.ClassesListController_AnalyzingClassesMsg());
            pHandle.setInitialDelay(0);
            pHandle.start();
            HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
            SourceClassInfo sci = ProfilerTypeUtils.resolveClass((String)className, (Lookup.Provider)project);
            Collection impls = sci != null ? sci.getSubclasses() : Collections.EMPTY_LIST;
            for (SourceClassInfo ci : impls) {
                JavaClass jClass = heap.getJavaClassByName(ci.getQualifiedName());
                if (jClass == null || !subclasses.add(jClass)) continue;
                subclasses.addAll(jClass.getSubClasses());
            }
            HashSet<JavaClass> hashSet = subclasses;
            return hashSet;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }

    private static List getFilteredClasses(List classes, String[] filterStrings, int filterType, boolean showZeroInstances, boolean showZeroSize) {
        ArrayList<JavaClass> filteredClasses = new ArrayList<JavaClass>();
        for (JavaClass jClass : classes) {
            if (!ClassesListController.matchesFilter(jClass, filterStrings, filterType, showZeroInstances, showZeroSize)) continue;
            filteredClasses.add(jClass);
        }
        return filteredClasses;
    }

    private static List getSortedClasses(List filteredClasses, int sortingColumn, boolean sortingOrder) {
        Collections.sort(filteredClasses, new ClassesComparator(sortingColumn, sortingOrder));
        return filteredClasses;
    }

    private static List getSubclasses(Heap heap, List diffClasses, String[] filterStrings, Lookup.Provider project) {
        HashSet<JavaClass> subclasses = new HashSet<JavaClass>();
        for (int i = 0; i < filterStrings.length; ++i) {
            JavaClass jClass = heap.getJavaClassByName(filterStrings[i]);
            if (jClass == null) continue;
            Collection collection = jClass.getSubClasses();
            subclasses.add(jClass);
            if (collection.size() > 0) {
                subclasses.addAll(collection);
                continue;
            }
            if (project == null) continue;
            subclasses.addAll(ClassesListController.getContextSubclasses(heap, filterStrings[i], project));
        }
        if (diffClasses != null) {
            ArrayList ret = new ArrayList();
            for (Object e : subclasses) {
                int i = diffClasses.indexOf(DiffJavaClass.createExternal((JavaClass)e));
                if (i == -1) continue;
                ret.add(diffClasses.get(i));
            }
            return ret;
        }
        return new ArrayList(subclasses);
    }

    private static boolean passesFilter(String value, String filter, int type) {
        switch (type) {
            case 20: {
                return value.toLowerCase().contains(filter);
            }
            case 25: {
                return !value.toLowerCase().contains(filter);
            }
            case 50: {
                try {
                    return value.matches(filter);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean passesFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!ClassesListController.passesFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    static {
        percentFormat.setMaximumFractionDigits(1);
        percentFormat.setMinimumFractionDigits(0);
    }

    private static class ClassesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public ClassesComparator(int sortingColumn, boolean sortingOrder) {
            this.sortingColumn = sortingColumn;
            this.sortingOrder = sortingOrder;
        }

        public int compare(Object o1, Object o2) {
            JavaClass jClass1 = this.sortingOrder ? (JavaClass)o1 : (JavaClass)o2;
            JavaClass jClass2 = this.sortingOrder ? (JavaClass)o2 : (JavaClass)o1;
            switch (this.sortingColumn) {
                case 0: {
                    return jClass1.getName().compareTo(jClass2.getName());
                }
                case 1: 
                case 2: {
                    return Integer.valueOf(jClass1.getInstancesCount()).compareTo(jClass2.getInstancesCount());
                }
                case 3: {
                    return Long.valueOf(jClass1.getAllInstancesSize()).compareTo(jClass2.getAllInstancesSize());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + o1 + ", " + o2);
        }
    }

    private static final class DiffJavaClass
    implements JavaClass {
        private final String name;
        private String id;
        private long allInstancesSize;
        private int instanceSize;
        private int instancesCount;
        private JavaClass real;

        static DiffJavaClass createExternal(JavaClass jc) {
            return new DiffJavaClass(jc, false);
        }

        static DiffJavaClass createReal(JavaClass jc) {
            return new DiffJavaClass(jc, true);
        }

        private DiffJavaClass(JavaClass jc, boolean realClass) {
            this.name = jc.getName();
            if (realClass) {
                this.instancesCount = jc.getInstancesCount();
                this.instanceSize = jc.getInstanceSize();
                this.allInstancesSize = jc.getAllInstancesSize();
                this.real = jc;
            } else {
                this.instancesCount = -jc.getInstancesCount();
                this.instanceSize = -jc.getInstanceSize();
                this.allInstancesSize = -jc.getAllInstancesSize();
                this.real = null;
            }
        }

        static String createID(JavaClass jc) {
            String id = jc.getName();
            try {
                id = id + jc.getClassLoader().getJavaClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jc instanceof DiffJavaClass) {
                ((DiffJavaClass)jc).setID(id);
            }
            return id;
        }

        private synchronized void setID(String id) {
            this.id = id;
        }

        synchronized String getID() {
            if (this.id == null) {
                DiffJavaClass.createID(this);
            }
            return this.id;
        }

        JavaClass getJavaClass() {
            return this.real;
        }

        void diff(DiffJavaClass djc) {
            this.instancesCount += djc.instancesCount;
            this.instanceSize += djc.instanceSize;
            this.allInstancesSize += djc.allInstancesSize;
            this.real = djc.real;
        }

        public boolean equals(Object o) {
            if (o instanceof DiffJavaClass) {
                return this.getID().equals(((DiffJavaClass)o).getID());
            }
            return false;
        }

        public int hashCode() {
            return this.getID().hashCode();
        }

        public Object getValueOfStaticField(String name) {
            return null;
        }

        public long getAllInstancesSize() {
            return this.allInstancesSize;
        }

        public boolean isArray() {
            return false;
        }

        public Instance getClassLoader() {
            return null;
        }

        public List getFields() {
            return null;
        }

        public int getInstanceSize() {
            return this.instanceSize;
        }

        public List getInstances() {
            return null;
        }

        public int getInstancesCount() {
            return this.instancesCount;
        }

        public long getJavaClassId() {
            return -1L;
        }

        public String getName() {
            return this.name;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public Collection getSubClasses() {
            return null;
        }

        public JavaClass getSuperClass() {
            return null;
        }
    }
}

