/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.utilities.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SelectHandlerPanel
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private Node[] selectedNodes;
    private JPanel panel;
    private Project project;

    public SelectHandlerPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.manager = new ExplorerManager();
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                SelectHandlerPanel.access$002(SelectHandlerPanel.this, SelectHandlerPanel.this.manager.getSelectedNodes());
            }
        });
        this.populateTree();
    }

    public Node[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void populateTree() {
        LogicalViewProvider lvp = (LogicalViewProvider)this.project.getLookup().lookup(LogicalViewProvider.class);
        Node projectView = lvp.createLogicalView();
        Children.Array children = new Children.Array();
        UnmodifiableFilterNode filter = new UnmodifiableFilterNode(projectView, (Children)new SourceListViewChildren());
        children.add((Node[])new FilterNode[]{filter});
        this.manager.setRootContext((Node)filter);
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.setLayout(new BorderLayout());
        BorderLayout bl = new BorderLayout();
        this.panel.setLayout(bl);
        bl.setVgap(10);
        this.add((Component)this.panel, "Center");
        BeanTreeView btv = new BeanTreeView();
        btv.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectHandlerPanel.class, (String)"LBL_Class_Tree"));
        btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectHandlerPanel.class, (String)"ACSD_SelectHandler"));
        String projectName = this.project.getProjectDirectory().getName();
        String classesLabel = projectName + " " + NbBundle.getMessage(SelectHandlerPanel.class, (String)"LBL_PROJECT_CLASSES") + ":";
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)classesLabel);
        label.setLabelFor(btv.getViewport().getView());
        this.panel.add((Component)label, "North");
        this.panel.add((Component)btv, "Center");
        this.panel.validate();
        this.validate();
    }

    static /* synthetic */ Node[] access$002(SelectHandlerPanel x0, Node[] x1) {
        x0.selectedNodes = x1;
        return x1;
    }

    class SourceListViewChildren
    extends Children.Keys<String> {
        public static final String KEY_SOURCES = "sourcesKey";

        SourceListViewChildren() {
        }

        protected Node[] createNodes(String key) {
            Object n = null;
            LinkedList<Node> sourceNodes = new LinkedList<Node>();
            if (key == KEY_SOURCES) {
                Sources sources = ProjectUtils.getSources((Project)SelectHandlerPanel.this.project);
                SourceGroup[] groups = sources.getSourceGroups("java");
                for (int i = 0; i < groups.length; ++i) {
                    sourceNodes.add(PackageView.createPackageView((SourceGroup)groups[i]));
                }
            }
            return sourceNodes.toArray(new Node[sourceNodes.size()]);
        }

        protected void addNotify() {
            super.addNotify();
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<String> l = new ArrayList<String>();
            l.add(KEY_SOURCES);
            this.setKeys(l);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }
    }

    class UnmodifiableFilterNode
    extends FilterNode {
        UnmodifiableFilterNode(Node original, Children children) {
            super(original, children);
        }

        public boolean canRename() {
            return false;
        }
    }
}

