/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.widgets;

import java.awt.Color;
import org.nbheaven.sqe.core.java.utils.Scope;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.DepFinderModel;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.DependencyScene;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.widgets.DataObjectWidget;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class PackageWidget
extends DataObjectWidget {
    private static final Border BORDER_PROJECT = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)Color.LIGHT_GRAY, (Color)Color.BLACK);
    private static final Border BORDER_EXTERNAL = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)Color.LIGHT_GRAY, (Color)Color.BLACK);
    private static final Border BORDER_JDK = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)Color.WHITE, (Color)Color.LIGHT_GRAY);
    private static final Border BORDER_MIXED = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)Color.WHITE, (Color)Color.RED);

    public PackageWidget(Scene scene, String packageDataObject) {
        super(scene);
        this.updateUI(packageDataObject);
    }

    public void updateUI() {
        DependencyScene scene = (DependencyScene)this.getScene();
        String packageDataObject = (String)scene.findObject((Widget)this);
        this.updateUI(packageDataObject);
    }

    private void updateUI(String packageName) {
        DependencyScene scene = (DependencyScene)this.getScene();
        DepFinderModel model = scene.getModel();
        Scope scope = model.getPackageScope(DependencyScene.decodePackageName(packageName));
        this.setLabel(packageName);
        if (null != scope) {
            switch (scope) {
                case PROJECT: {
                    this.setFont(this.getScene().getDefaultFont().deriveFont(1));
                    this.setBorder(BORDER_PROJECT);
                    break;
                }
                case EXTERNAL: {
                    this.setBorder(BORDER_EXTERNAL);
                    break;
                }
                case JDK: {
                    this.setBorder(BORDER_JDK);
                    break;
                }
                case MIXED: {
                    this.setBorder(BORDER_MIXED);
                }
            }
        }
    }
}

