/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual;

import org.nbheaven.sqe.core.java.utils.Scope;
import org.nbheaven.sqe.core.ui.components.filter.FilterType;
import org.nbheaven.sqe.core.ui.components.filter.JFilter;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.DepFinderModel;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.DependencyNode;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.ModelRef;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.widgets.DependencyWidget;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.widgets.PackageWidget;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyScene
extends GraphScene<String, DependencyNode> {
    private static final String DEFAULT_PACKAGE = "<default>";
    private final ModelRef modelRef;
    private final SceneLayout sceneLayout;
    private final LayerWidget projectPackagesLayer;
    private final LayerWidget projectDependenciesLayer;
    private final LayerWidget externalPackagesLayer;
    private final LayerWidget externalDependenciesLayer;
    private final LayerWidget jdkPackagesLayer;
    private final LayerWidget jdkDependenciesLayer;
    private final LayerWidget interactiveLayer;
    private final WidgetAction moveAction;
    private boolean showExternalScope = false;
    private boolean showJdkScope = false;

    public DependencyScene(ModelRef modelRef) {
        this.modelRef = modelRef;
        this.projectPackagesLayer = new LayerWidget((Scene)this);
        this.projectDependenciesLayer = new LayerWidget((Scene)this);
        this.externalPackagesLayer = new LayerWidget((Scene)this);
        this.externalPackagesLayer.setVisible(this.showExternalScope);
        this.externalDependenciesLayer = new LayerWidget((Scene)this);
        this.externalDependenciesLayer.setVisible(this.showExternalScope);
        this.jdkPackagesLayer = new LayerWidget((Scene)this);
        this.jdkPackagesLayer.setVisible(this.showJdkScope);
        this.jdkDependenciesLayer = new LayerWidget((Scene)this);
        this.jdkDependenciesLayer.setVisible(this.showJdkScope);
        this.interactiveLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.jdkPackagesLayer);
        this.addChild((Widget)this.externalPackagesLayer);
        this.addChild((Widget)this.projectPackagesLayer);
        this.addChild((Widget)this.jdkDependenciesLayer);
        this.addChild((Widget)this.externalDependenciesLayer);
        this.addChild((Widget)this.projectDependenciesLayer);
        this.addChild((Widget)this.interactiveLayer);
        this.getActions().addAction(ActionFactory.createZoomAction());
        this.moveAction = ActionFactory.createMoveAction();
        GridGraphLayout layout = new GridGraphLayout();
        layout.setChecker(true);
        layout.setAnimated(false);
        this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphScene)this, (GraphLayout)layout);
    }

    public boolean isShowExternalScope() {
        return this.showExternalScope;
    }

    public void setShowExternalScope(boolean showExternalScope) {
        if (this.showExternalScope ^ showExternalScope) {
            this.showExternalScope = showExternalScope;
            this.externalPackagesLayer.setVisible(showExternalScope);
            this.externalDependenciesLayer.setVisible(showExternalScope);
            this.validate();
            this.getView().repaint();
        }
    }

    public boolean isShowJdkScope() {
        return this.showJdkScope;
    }

    public void setShowJDKScope(boolean showJDKScope) {
        if (this.showJdkScope ^ showJDKScope) {
            this.showJdkScope = showJDKScope;
            this.jdkPackagesLayer.setVisible(showJDKScope);
            this.jdkDependenciesLayer.setVisible(showJDKScope);
            this.validate();
            this.getView().repaint();
        }
    }

    public ModelRef getModelRef() {
        return this.modelRef;
    }

    public DepFinderModel getModel() {
        return this.modelRef.getModel();
    }

    public static String encodePackageName(String packageName) {
        String name;
        String string = name = null == packageName ? "" : packageName.trim();
        if (name.length() == 0) {
            return DEFAULT_PACKAGE;
        }
        return name;
    }

    public static String decodePackageName(String packageName) {
        if (DEFAULT_PACKAGE == packageName || DEFAULT_PACKAGE.equals(packageName)) {
            return "";
        }
        return packageName;
    }

    public void filterChanged(JFilter jFilter) {
        FilterType type = jFilter.getFilterType();
        String[] rules = jFilter.getFilterStrings();
        for (String node : this.getNodes()) {
            Widget targetWidget;
            String targetNode;
            Widget edgeWidget;
            boolean show = type.accept(node, rules);
            Widget nodeWidget = this.findWidget(node);
            nodeWidget.setVisible(show);
            for (DependencyNode dependency : this.findNodeEdges(node, true, false)) {
                edgeWidget = this.findWidget(dependency);
                if (!(show ^ edgeWidget.isVisible())) continue;
                targetNode = (String)this.getEdgeTarget(dependency);
                targetWidget = this.findWidget(targetNode);
                edgeWidget.setVisible(show ? targetWidget.isVisible() : false);
            }
            for (DependencyNode dependency : this.findNodeEdges(node, false, true)) {
                edgeWidget = this.findWidget(dependency);
                if (!(show ^ edgeWidget.isVisible())) continue;
                targetNode = (String)this.getEdgeSource(dependency);
                targetWidget = this.findWidget(targetNode);
                edgeWidget.setVisible(show ? targetWidget.isVisible() : false);
            }
        }
        this.doSceneLayout();
    }

    public void doSceneLayout() {
        this.sceneLayout.invokeLayout();
    }

    protected Widget attachNodeWidget(String node) {
        PackageWidget nodeWidget = new PackageWidget((Scene)this, node);
        nodeWidget.getActions().addAction(this.moveAction);
        Scope scope = this.getModel().getPackageScope(DependencyScene.decodePackageName(node));
        switch (scope) {
            case PROJECT: 
            case MIXED: {
                this.projectPackagesLayer.addChild((Widget)nodeWidget);
                break;
            }
            case EXTERNAL: {
                this.externalPackagesLayer.addChild((Widget)nodeWidget);
                break;
            }
            case JDK: {
                this.jdkPackagesLayer.addChild((Widget)nodeWidget);
            }
        }
        return nodeWidget;
    }

    protected Widget attachEdgeWidget(DependencyNode dependency) {
        DependencyWidget dependencyWidget = new DependencyWidget((Scene)this, dependency);
        dependencyWidget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        Scope targetScope = this.getModel().getPackageScope(DependencyScene.decodePackageName(dependency.getTarget()));
        switch (targetScope) {
            case PROJECT: 
            case MIXED: {
                this.projectDependenciesLayer.addChild((Widget)dependencyWidget);
                break;
            }
            case EXTERNAL: {
                this.externalDependenciesLayer.addChild((Widget)dependencyWidget);
                break;
            }
            case JDK: {
                this.jdkDependenciesLayer.addChild((Widget)dependencyWidget);
            }
        }
        return dependencyWidget;
    }

    protected void attachEdgeSourceAnchor(DependencyNode dependency, String oldNode, String newNode) {
        PackageWidget nodeWidget = (PackageWidget)this.findWidget(newNode);
        ConnectionWidget dependencyWidget = (ConnectionWidget)this.findWidget(dependency);
        dependencyWidget.setSourceAnchor(null == nodeWidget ? null : nodeWidget.getAnchor());
    }

    protected void attachEdgeTargetAnchor(DependencyNode dependency, String oldNode, String newNode) {
        PackageWidget nodeWidget = (PackageWidget)this.findWidget(newNode);
        ConnectionWidget dependencyWidget = (ConnectionWidget)this.findWidget(dependency);
        dependencyWidget.setTargetAnchor(null == nodeWidget ? null : nodeWidget.getAnchor());
    }
}

