/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.depfinder.dependencies.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.nbheaven.sqe.core.ui.components.filter.FilterChangedListener;
import org.nbheaven.sqe.core.ui.components.filter.FilterType;
import org.nbheaven.sqe.core.ui.components.filter.JFilter;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.DependencyNode;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.ModelManager;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.ui.visual.DependencyScene;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.visual.widget.Widget;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class DependencyViewTopComponent
extends TopComponent
implements PropertyChangeListener,
FilterChangedListener {
    private static final String PREFERRED_ID = "DependencyViewTopComponent";
    private final Project project;
    private DependencyScene scene;
    private JScrollPane scrollPane = null;
    private volatile boolean working = false;
    private JButton defaultZoomButton;
    private JFilter jFilter;
    private JButton refreshButton;
    private JToggleButton showExternalScopeButton;
    private JToggleButton showJDKScopeButton;
    private JToolBar toolBar;
    private JToolBar.Separator toolBarSeparator1;
    private JToolBar.Separator toolBarSeparator2;
    private JButton zoomToViewButton;

    public DependencyViewTopComponent(Project project, Node ... context) {
        this.project = project;
        this.initComponents();
        String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.setName(NbBundle.getMessage(DependencyViewTopComponent.class, (String)"CTL_DependencyViewTopComponent", (Object)projectName));
        this.setToolTipText(NbBundle.getMessage(DependencyViewTopComponent.class, (String)"HINT_DependencyViewTopComponent", (Object)projectName));
        this.setIcon(ImageUtilities.loadImage((String)"org/nbheaven/sqe/tools/depfinder/dependencies/core/resources/depfinder.png", (boolean)true));
        this.setUIEnabled(false);
    }

    public void filterChanged() {
        this.scene.filterChanged(this.jFilter);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("openProjects".equals(evt.getPropertyName()) && !Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(this.project)) {
            this.close();
        }
    }

    private boolean isWorking() {
        return this.working;
    }

    private void setWorking(boolean working) {
        this.working = working;
        this.setUIEnabled(!working);
    }

    private void setUIEnabled(boolean enable) {
        this.showExternalScopeButton.setEnabled(enable);
        this.showJDKScopeButton.setEnabled(enable);
        this.zoomToViewButton.setEnabled(enable);
        this.defaultZoomButton.setEnabled(enable);
        this.refreshButton.setEnabled(enable);
        this.jFilter.setVisible(enable);
    }

    private void setScene(DependencyScene scene) {
        if (this.scene != scene) {
            if (null != this.scene) {
                this.setUIEnabled(false);
                this.remove(this.scrollPane);
            }
            this.scene = scene;
            if (null != this.scene) {
                this.scrollPane = new JScrollPane(this.scene.createView());
                this.add(this.scrollPane, "Center");
                this.showExternalScopeButton.setSelected(scene.isShowJdkScope());
                this.showJDKScopeButton.setSelected(scene.isShowJdkScope());
                this.setUIEnabled(true);
            }
        }
    }

    private void refreshScene(final boolean refreshModel) {
        this.setWorking(true);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final DependencyScene scene = new DependencyScene(ModelManager.getDefault().getModelRef(DependencyViewTopComponent.this.project));
                if (refreshModel) {
                    scene.getModel().update();
                }
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)("DependencyFinder - " + ProjectUtils.getInformation((Project)DependencyViewTopComponent.this.project).getDisplayName()));
                progressHandle.start(scene.getModel().getPackages().size());
                int count = 0;
                for (String packageName : scene.getModel().getPackages()) {
                    if (!scene.isNode(DependencyScene.encodePackageName(packageName = DependencyScene.encodePackageName(packageName)))) {
                        scene.addNode(packageName);
                    }
                    for (String usedPackageName : scene.getModel().getOutboundPackageDependencies(packageName)) {
                        if (!scene.isNode(usedPackageName = DependencyScene.encodePackageName(usedPackageName))) {
                            scene.addNode(usedPackageName);
                        }
                        DependencyNode dependencyNode = new DependencyNode(scene.getModelRef(), packageName, usedPackageName);
                        if (packageName == usedPackageName || packageName.equals(usedPackageName) || scene.isEdge(dependencyNode)) continue;
                        scene.addEdge(dependencyNode);
                        scene.setEdgeSource(dependencyNode, packageName);
                        scene.setEdgeTarget(dependencyNode, usedPackageName);
                    }
                    progressHandle.progress(++count);
                }
                progressHandle.finish();
                scene.doSceneLayout();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DependencyViewTopComponent.this.setScene(scene);
                        DependencyViewTopComponent.this.setWorking(false);
                    }
                });
            }
        });
    }

    private void fitToView() {
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        for (Widget widget : this.scene.getChildren()) {
            rectangle = rectangle.union(widget.convertLocalToScene(widget.getBounds()));
        }
        Dimension dim = rectangle.getSize();
        Dimension viewDim = this.scrollPane.getViewportBorderBounds().getSize();
        this.scene.setZoomFactor(Math.min((float)viewDim.width / (float)dim.width, (float)viewDim.height / (float)dim.height));
        this.scene.validate();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.toolBarSeparator1 = new JToolBar.Separator();
        this.showJDKScopeButton = new JToggleButton();
        this.showExternalScopeButton = new JToggleButton();
        this.toolBarSeparator2 = new JToolBar.Separator();
        this.zoomToViewButton = new JButton();
        this.defaultZoomButton = new JButton();
        this.jFilter = new JFilter();
        this.setLayout(new BorderLayout());
        this.toolBar.setRollover(true);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/nbheaven/sqe/tools/depfinder/dependencies/core/resources/refresh.png")));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyViewTopComponent.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.toolBarSeparator1);
        Mnemonics.setLocalizedText((AbstractButton)this.showJDKScopeButton, (String)"JDK");
        this.showJDKScopeButton.setFocusable(false);
        this.showJDKScopeButton.setHorizontalTextPosition(0);
        this.showJDKScopeButton.setVerticalTextPosition(3);
        this.showJDKScopeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyViewTopComponent.this.showJDKScopeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showJDKScopeButton);
        Mnemonics.setLocalizedText((AbstractButton)this.showExternalScopeButton, (String)"External");
        this.showExternalScopeButton.setFocusable(false);
        this.showExternalScopeButton.setHorizontalTextPosition(0);
        this.showExternalScopeButton.setVerticalTextPosition(3);
        this.showExternalScopeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyViewTopComponent.this.showExternalScopeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showExternalScopeButton);
        this.toolBar.add(this.toolBarSeparator2);
        Mnemonics.setLocalizedText((AbstractButton)this.zoomToViewButton, (String)"ZoomToFit");
        this.zoomToViewButton.setFocusable(false);
        this.zoomToViewButton.setHorizontalTextPosition(0);
        this.zoomToViewButton.setVerticalTextPosition(3);
        this.zoomToViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyViewTopComponent.this.zoomToViewButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomToViewButton);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultZoomButton, (String)"1:1");
        this.defaultZoomButton.setFocusable(false);
        this.defaultZoomButton.setHorizontalTextPosition(0);
        this.defaultZoomButton.setVerticalTextPosition(3);
        this.defaultZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyViewTopComponent.this.defaultZoomButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.defaultZoomButton);
        this.add(this.toolBar, "North");
        this.jFilter.addFilterItem(new FilterType[]{FilterType.STARTS_WITH, FilterType.CONTAINS, FilterType.REGEXP, FilterType.ENDS_WITH});
        this.jFilter.setDefaultFilterType(FilterType.STARTS_WITH);
        this.jFilter.addFilterListener((FilterChangedListener)this);
        this.add((Component)this.jFilter, "South");
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refreshScene(true);
    }

    private void showJDKScopeButtonActionPerformed(ActionEvent evt) {
        this.scene.setShowJDKScope(this.showJDKScopeButton.isSelected());
    }

    private void showExternalScopeButtonActionPerformed(ActionEvent evt) {
        this.scene.setShowExternalScope(this.showExternalScopeButton.isSelected());
    }

    private void zoomToViewButtonActionPerformed(ActionEvent evt) {
        this.fitToView();
    }

    private void defaultZoomButtonActionPerformed(ActionEvent evt) {
        this.scene.setZoomFactor(1.0);
        this.scene.validate();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        super.componentOpened();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.refreshScene(true);
    }

    public void componentClosed() {
        super.componentClosed();
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }
}

