/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.depfinder.dependencies.core.model;

import com.jeantessier.classreader.ClassfileScanner;
import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.dependencyfinder.VerboseListenerBase;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressMonitor
extends VerboseListenerBase {
    private final String projectName;
    private final AtomicInteger doneWorkUnits;
    private ProgressHandle prgHdl = null;

    public ProgressMonitor(String projectName) {
        this.projectName = projectName;
        this.doneWorkUnits = new AtomicInteger(0);
    }

    public synchronized void startMonitoring(Collection<String> filenames) {
        if (null == this.prgHdl) {
            this.prgHdl = this.createProgressHandle();
        }
        this.prgHdl.start();
        this.prgHdl.progress("Scanning ...");
        ClassfileScanner scanner = new ClassfileScanner();
        scanner.load(filenames);
        this.getProgressHandle().switchToDeterminate(scanner.getNbFiles());
        this.doneWorkUnits.set(0);
    }

    public synchronized void stopMonitoring() {
        if (this.prgHdl != null) {
            this.prgHdl.finish();
            this.prgHdl = null;
            this.doneWorkUnits.set(0);
        }
    }

    private ProgressHandle createProgressHandle() {
        return ProgressHandleFactory.createHandle((String)("DependencyFinder - " + this.projectName));
    }

    public ProgressHandle getProgressHandle() {
        if (null == this.prgHdl) {
            this.prgHdl = this.createProgressHandle();
        }
        return this.prgHdl;
    }

    public void setProgressHandle(ProgressHandle prgHdl) {
        this.prgHdl = prgHdl;
    }

    public void beginSession(LoadEvent event) {
        super.beginSession(event);
        this.getProgressHandle().progress("Searching for classes ...");
    }

    public void beginGroup(LoadEvent event) {
        super.beginGroup(event);
        this.getProgressHandle().progress("Loading from " + event.getGroupName() + " ...");
    }

    public void beginFile(LoadEvent event) {
        super.beginFile(event);
        if (event.getFilename().startsWith(event.getGroupName())) {
            this.getProgressHandle().progress("Found " + event.getFilename() + " ...");
        } else {
            this.getProgressHandle().progress("Found " + event.getGroupName() + " >> " + event.getFilename() + " ...");
        }
    }

    public void endFile(LoadEvent event) {
        super.endFile(event);
        this.getProgressHandle().progress(this.doneWorkUnits.incrementAndGet());
    }

    public void endSession(LoadEvent event) {
        super.endSession(event);
        this.stopMonitoring();
    }
}

