/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.depfinder.dependencies.core.model;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.LoadListener;
import com.jeantessier.classreader.ModifiedOnlyDispatcher;
import com.jeantessier.classreader.Monitor;
import com.jeantessier.classreader.RemoveVisitor;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.DeletingVisitor;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.VisitorBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.nbheaven.sqe.core.java.utils.Scope;
import org.nbheaven.sqe.core.java.utils.ScopeUtilities;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.ModelManager;
import org.nbheaven.sqe.tools.depfinder.dependencies.core.model.ProgressMonitor;
import org.netbeans.api.project.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepFinderModel {
    private final ModelManager manager;
    private final NodeFactory factory;
    private final ClassfileLoader loader;
    private final ProgressMonitor progressMonitor;
    private final Map<String, Scope> packageScopeCache = new HashMap<String, Scope>();
    private final Map<String, ArrayList<String>> packageClassesCache = new HashMap<String, ArrayList<String>>();
    private final Map<String, ArrayList<String>> packageOutboundDependenciesCache = new HashMap<String, ArrayList<String>>();
    private final Map<String, ArrayList<String>> classOutboundDependenciesCache = new HashMap<String, ArrayList<String>>();
    private final Map<String, ArrayList<String>> featureOutboundDependenciesCache = new HashMap<String, ArrayList<String>>();
    private final Map<String, Scope> classScopeCache = new HashMap<String, Scope>();
    private final Map<String, ArrayList<String>> classFeatureCache = new HashMap<String, ArrayList<String>>();

    public DepFinderModel(ModelManager manager) {
        this.manager = manager;
        this.factory = new NodeFactory();
        CodeDependencyCollector collector = new CodeDependencyCollector(this.factory);
        DeletingVisitor deletingVisitor = new DeletingVisitor(this.factory);
        Monitor monitor = new Monitor((Visitor)collector, (RemoveVisitor)deletingVisitor);
        monitor.setClosedSession(true);
        ModifiedOnlyDispatcher dispatcher = new ModifiedOnlyDispatcher(ClassfileLoaderEventSource.DEFAULT_DISPATCHER);
        this.progressMonitor = new ProgressMonitor("Analyze dependencies");
        this.loader = new TransientClassfileLoader((ClassfileLoaderDispatcher)dispatcher);
        this.loader.addLoadListener((LoadListener)monitor);
        this.loader.addLoadListener((LoadListener)this.progressMonitor);
    }

    public ModelManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        Project project = this.getManager().getProject(this);
        List binaryFiles = ProjectUtilities.findBinaryRoots((Project)project);
        this.progressMonitor.startMonitoring(binaryFiles);
        try {
            this.clearCaches();
            this.loader.load((Collection)binaryFiles);
        }
        finally {
            this.progressMonitor.stopMonitoring();
        }
    }

    private void clearCaches() {
        this.packageScopeCache.clear();
        this.packageClassesCache.clear();
        this.classScopeCache.clear();
        this.classFeatureCache.clear();
        this.packageOutboundDependenciesCache.clear();
    }

    public Collection<String> getPackages() {
        return this.factory.getPackages().keySet();
    }

    public Collection<String> getOutboundPackageDependencies(String packageName) {
        PackageNode packageNode = (PackageNode)this.factory.getPackages().get(packageName);
        if (null == packageNode) {
            return Collections.emptyList();
        }
        ArrayList<String> list = this.packageOutboundDependenciesCache.get(packageName);
        if (null == list) {
            OutboundDependenciesVisitor visitor = new OutboundDependenciesVisitor((Node)packageNode).traverseNode();
            list = new ArrayList<String>(visitor.getPackages());
            list.trimToSize();
            this.packageOutboundDependenciesCache.put(packageName, list);
        }
        return list;
    }

    public Collection<String> getPackageClasses(String packageNsme) {
        PackageNode packageNode = (PackageNode)this.factory.getPackages().get(packageNsme);
        if (null == packageNode) {
            return Collections.emptyList();
        }
        Collection classes = packageNode.getClasses();
        if (null == classes || classes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = this.packageClassesCache.get(packageNsme);
        if (null == list) {
            list = new ArrayList(classes.size());
            for (ClassNode classNode : classes) {
                list.add(classNode.getName());
            }
            list.trimToSize();
            this.packageClassesCache.put(packageNsme, list);
        }
        return list;
    }

    public Scope getPackageScope(String packageNsme) {
        Scope packageScope = this.packageScopeCache.get(packageNsme);
        if (null == packageScope) {
            PackageNode packageNode = (PackageNode)this.factory.getPackages().get(packageNsme);
            for (ClassNode classNode : packageNode.getClasses()) {
                Scope classScope = this.getClassScope(classNode.getName());
                if ((packageScope = packageScope == Scope.PROJECT && classScope != packageScope ? Scope.MIXED : (packageScope == Scope.JDK && classScope != packageScope ? Scope.MIXED : (packageScope == Scope.EXTERNAL && classScope != packageScope ? Scope.MIXED : classScope))) != Scope.EXTERNAL) continue;
                break;
            }
        }
        return packageScope;
    }

    private PackageNode getPackageNode(Node node) {
        PackageNode packageNode;
        if (node instanceof FeatureNode) {
            FeatureNode featureNode = (FeatureNode)node;
            packageNode = featureNode.getClassNode().getPackageNode();
        } else if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            packageNode = classNode.getPackageNode();
        } else {
            packageNode = (PackageNode)node;
        }
        return packageNode;
    }

    public Collection<String> getClasses() {
        return this.factory.getClasses().keySet();
    }

    public Collection<String> getOutboundClassDependencies(String className) {
        ClassNode classNode = (ClassNode)this.factory.getClasses().get(className);
        if (null == classNode) {
            return Collections.emptyList();
        }
        ArrayList<String> list = this.classOutboundDependenciesCache.get(className);
        if (null == list) {
            OutboundDependenciesVisitor visitor = new OutboundDependenciesVisitor((Node)classNode).traverseNode();
            list = new ArrayList<String>(visitor.getClasses());
            list.trimToSize();
            this.classOutboundDependenciesCache.put(className, list);
        }
        return list;
    }

    public String getClassPackage(String className) {
        ClassNode classNode = (ClassNode)this.factory.getClasses().get(className);
        PackageNode packageNode = null != classNode ? classNode.getPackageNode() : null;
        return null != packageNode ? packageNode.getName() : null;
    }

    public Collection<String> getClassFeatures(String className) {
        ClassNode classNode = (ClassNode)this.factory.getClasses().get(className);
        if (null == classNode) {
            return Collections.emptyList();
        }
        Collection features = classNode.getFeatures();
        if (null == features || features.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = this.classFeatureCache.get(className);
        if (null == list) {
            list = new ArrayList(features.size());
            for (FeatureNode featureNode : features) {
                list.add(featureNode.getName());
            }
            list.trimToSize();
            this.classFeatureCache.put(className, list);
        }
        return list;
    }

    public Scope getClassScope(String classNsme) {
        Scope scope = this.classScopeCache.get(classNsme);
        if (null == scope) {
            scope = ScopeUtilities.findScope((String)classNsme, (Project)this.getManager().getProject(this));
            this.classScopeCache.put(classNsme, scope);
        }
        return scope;
    }

    public Collection<String> getFeatures() {
        return this.factory.getFeatures().keySet();
    }

    public Collection<String> getOutboundFeatureDependencies(String fedatureName) {
        FeatureNode featureNode = (FeatureNode)this.factory.getFeatures().get(fedatureName);
        if (null == featureNode) {
            return Collections.emptyList();
        }
        ArrayList<String> list = this.featureOutboundDependenciesCache.get(fedatureName);
        if (null == list) {
            OutboundDependenciesVisitor visitor = new OutboundDependenciesVisitor((Node)featureNode).traverseNode();
            list = new ArrayList<String>(visitor.getFeatures());
            list.trimToSize();
            this.featureOutboundDependenciesCache.put(fedatureName, list);
        }
        return list;
    }

    public String getFeatureClasses(String featureName) {
        FeatureNode featureNode = (FeatureNode)this.factory.getFeatures().get(featureName);
        ClassNode classNode = null != featureNode ? featureNode.getClassNode() : null;
        return null != classNode ? classNode.getName() : null;
    }

    public Scope getFeatureScope(String featureName) {
        FeatureNode featureNode = (FeatureNode)this.factory.getFeatures().get(featureName);
        return this.getClassScope(featureNode.getClassNode().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutboundDependenciesVisitor
    extends VisitorBase {
        private final Node node;
        private final boolean tracPackages;
        private final boolean tracClasses;
        private final boolean tracFeatures;
        private Set<String> packages = null;
        private Set<String> classes = null;
        private Set<String> features = null;

        OutboundDependenciesVisitor(Node node) {
            this.node = node;
            this.tracPackages = node instanceof PackageNode;
            this.tracClasses = node instanceof ClassNode;
            this.tracFeatures = node instanceof FeatureNode;
        }

        public Set<String> getPackages() {
            return null == this.packages ? Collections.emptySet() : this.packages;
        }

        public Set<String> getClasses() {
            return null == this.classes ? Collections.emptySet() : this.classes;
        }

        public Set<String> getFeatures() {
            return null == this.features ? Collections.emptySet() : this.features;
        }

        public OutboundDependenciesVisitor traverseNode() {
            this.traverseNodes(Arrays.asList(this.node));
            return this;
        }

        protected boolean isInScope(PackageNode packageNode) {
            return !this.tracPackages || this.node == packageNode;
        }

        protected boolean isInScope(ClassNode classNode) {
            return !this.tracClasses || this.node == classNode;
        }

        protected boolean isInScope(FeatureNode featureNode) {
            return !this.tracFeatures || this.node == featureNode;
        }

        public void visitOutboundPackageNode(PackageNode packageNode) {
            super.visitOutboundPackageNode(packageNode);
            if (this.tracPackages) {
                if (null == this.packages) {
                    this.packages = new HashSet<String>();
                }
                this.packages.add(packageNode.getName());
            }
        }

        public void visitOutboundClassNode(ClassNode classNode) {
            super.visitOutboundClassNode(classNode);
            if (this.tracPackages) {
                if (null == this.packages) {
                    this.packages = new HashSet<String>();
                }
                this.packages.add(classNode.getPackageNode().getName());
            }
            if (this.tracClasses) {
                if (null == this.classes) {
                    this.classes = new HashSet<String>();
                }
                this.classes.add(classNode.getName());
            }
        }

        public void visitOutboundFeatureNode(FeatureNode featureNode) {
            super.visitOutboundFeatureNode(featureNode);
            if (this.tracPackages) {
                if (null == this.packages) {
                    this.packages = new HashSet<String>();
                }
                this.packages.add(featureNode.getClassNode().getPackageNode().getName());
            }
            if (this.tracClasses) {
                if (null == this.classes) {
                    this.classes = new HashSet<String>();
                }
                this.classes.add(featureNode.getClassNode().getName());
            }
            if (this.tracFeatures) {
                if (null == this.features) {
                    this.features = new HashSet<String>();
                }
                this.features.add(featureNode.getName());
            }
        }

        protected void traverseInbound(Collection<? extends Node> nodes) {
        }
    }
}

