/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaResponseWaitingRoom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;

@Transport
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class CorbaResponseWaitingRoomImpl
implements CorbaResponseWaitingRoom {
    private static final ORBUtilSystemException wrapper;
    private final Map<Integer, OutCallDesc> out_calls;
    private final ORB orb;
    private final CorbaConnection connection;
    private static Holder __$mm$__0;

    public CorbaResponseWaitingRoomImpl(ORB orb, CorbaConnection connection) {
        this.orb = orb;
        this.connection = connection;
        this.out_calls = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void registerWaiter(CorbaMessageMediator corbaMessageMediator) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(3, new Object[]{corbaMessageMediator});
        }
        try {
            void __$mm$__;
            void messageMediator;
            this.display("messageMediator request ID", messageMediator.getRequestId(), (MethodMonitor)__$mm$__, 3);
            this.display("messageMediator operation name", messageMediator.getOperationName(), (MethodMonitor)__$mm$__, 3);
            Integer requestId = messageMediator.getRequestIdInteger();
            OutCallDesc call = new OutCallDesc();
            call.messageMediator = messageMediator;
            OutCallDesc exists = this.out_calls.put(requestId, call);
            if (exists != null) {
                wrapper.duplicateRequestIdsInResponseWaitingRoom(ORBUtility.operationNameAndRequestId(exists.messageMediator), ORBUtility.operationNameAndRequestId((CorbaMessageMediator)messageMediator));
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(3);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void unregisterWaiter(CorbaMessageMediator corbaMessageMediator) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(6, new Object[]{corbaMessageMediator});
        }
        try {
            void __$mm$__;
            void mediator;
            void messageMediator = mediator;
            this.display("messageMediator request ID", messageMediator.getRequestId(), (MethodMonitor)__$mm$__, 6);
            this.display("messageMediator operation name", messageMediator.getOperationName(), (MethodMonitor)__$mm$__, 6);
            Integer requestId = messageMediator.getRequestIdInteger();
            this.out_calls.remove(requestId);
            if (__$mm$__ != null) {
                __$mm$__.exit(6);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(6);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public CDRInputObject waitForResponse(CorbaMessageMediator corbaMessageMediator) {
        Object var2_2 = null;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(7, new Object[]{corbaMessageMediator});
        }
        try {
            CDRInputObject __$result$__;
            void __$mm$__;
            void messageMediator;
            CDRInputObject returnStream = null;
            this.display("messageMediator request ID", messageMediator.getRequestId(), (MethodMonitor)__$mm$__, 7);
            this.display("messageMediator operation name", messageMediator.getOperationName(), (MethodMonitor)__$mm$__, 7);
            Integer requestId = messageMediator.getRequestIdInteger();
            if (messageMediator.isOneWay()) {
                this.display("Oneway request: not waiting", (MethodMonitor)__$mm$__, 7);
                __$result$__ = null;
                if (__$mm$__ != null) {
                    __$mm$__.exit(7, __$result$__);
                }
                return __$result$__;
            }
            OutCallDesc call = this.out_calls.get(requestId);
            if (call == null) {
                MARSHAL mARSHAL = wrapper.nullOutCall();
                if (__$mm$__ != null) {
                    __$mm$__.exception(7, (Throwable)mARSHAL);
                }
                throw mARSHAL;
            }
            long waitForResponseTimeout = this.orb.getORBData().getWaitForResponseTimeout() * 1000L * 1000L;
            try {
                call.lock.lock();
                while (call.inputObject == null && call.exception == null) {
                    try {
                        this.display("Waiting for response...", (MethodMonitor)__$mm$__, 7);
                        waitForResponseTimeout = call.condition.awaitNanos(waitForResponseTimeout);
                        if (call.inputObject != null || call.exception != null) continue;
                        if (waitForResponseTimeout > 0L) {
                            this.display("Spurious wakeup, continuing to wait for ", waitForResponseTimeout / 1000000L, (MethodMonitor)__$mm$__, 7);
                            continue;
                        }
                        call.exception = wrapper.communicationsTimeoutWaitingForResponse(this.orb.getORBData().getWaitForResponseTimeout());
                        ORBUtility.pushEncVersionToThreadLocalState((byte)1);
                    }
                    catch (InterruptedException ie) {}
                }
                if (call.exception != null) {
                    this.display("Exception from call", (Object)call.exception, (MethodMonitor)__$mm$__, 7);
                    SystemException systemException = call.exception;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(7, (Throwable)systemException);
                    }
                    throw systemException;
                }
                returnStream = call.inputObject;
                call.lock.unlock();
            }
            catch (Throwable throwable) {
                call.lock.unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(7, throwable2);
                }
                throw throwable2;
            }
            if (returnStream != null) {
                returnStream.unmarshalHeader();
            }
            __$result$__ = returnStream;
            if (__$mm$__ != null) {
                __$mm$__.exit(7, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(7, var2_2);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void display(String string, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string}, n, 0);
        }
    }

    @InfoMethod
    private void display(String string, int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, n}, n2, 0);
        }
    }

    @InfoMethod
    private void display(String string, Object object, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{string, object}, n, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void responseReceived(CDRInputObject cDRInputObject) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(4, new Object[]{cDRInputObject});
        }
        try {
            void __$mm$__;
            void is;
            void inputObject = is;
            LocateReplyOrReplyMessage header = (LocateReplyOrReplyMessage)inputObject.getMessageHeader();
            this.display("requestId", header.getRequestId(), (MethodMonitor)__$mm$__, 4);
            this.display("header", header, (MethodMonitor)__$mm$__, 4);
            OutCallDesc call = this.out_calls.get(header.getRequestId());
            if (call == null) {
                this.display("No waiter", (MethodMonitor)__$mm$__, 4);
                if (__$mm$__ != null) {
                    __$mm$__.exit(4);
                }
                return;
            }
            try {
                call.lock.lock();
                CorbaMessageMediator messageMediator = call.messageMediator;
                this.display("Notifying waiters", (MethodMonitor)__$mm$__, 4);
                this.display("messageMediator request ID", messageMediator.getRequestId(), (MethodMonitor)__$mm$__, 4);
                this.display("messageMediator operation name", messageMediator.getOperationName(), (MethodMonitor)__$mm$__, 4);
                messageMediator.setReplyHeader(header);
                messageMediator.setInputObject((CDRInputObject)is);
                inputObject.setMessageMediator(messageMediator);
                call.inputObject = is;
                call.condition.signal();
                call.lock.unlock();
            }
            catch (Throwable throwable) {
                call.lock.unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(4, throwable2);
                }
                throw throwable2;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(4);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(4);
            }
            throw throwable;
        }
    }

    @Override
    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transport
    public void signalExceptionToAllWaiters(SystemException systemException) {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(5, new Object[]{systemException});
        }
        try {
            void __$mm$__;
            Map<Integer, OutCallDesc> map = this.out_calls;
            synchronized (map) {
                try {
                    for (OutCallDesc call : this.out_calls.values()) {
                        try {
                            void systemException2;
                            call.lock.lock();
                            call.messageMediator.cancelRequest();
                            call.inputObject = null;
                            call.exception = systemException2;
                            call.condition.signal();
                            call.lock.unlock();
                        }
                        catch (Throwable throwable) {
                            call.lock.unlock();
                            Throwable throwable2 = throwable;
                            if (__$mm$__ != null) {
                                __$mm$__.exception(5, throwable2);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl28 : MonitorExitStatement: MONITOREXIT : var4_3
                    Throwable throwable3 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(5, throwable3);
                    }
                    throw throwable3;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(5);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(5);
            }
            throw throwable;
        }
    }

    @Override
    public CorbaMessageMediator getMessageMediator(int requestId) {
        OutCallDesc call = this.out_calls.get(requestId);
        if (call == null) {
            return null;
        }
        return call.messageMediator;
    }

    static {
        MethodMonitorRegistry.registerClass(CorbaResponseWaitingRoomImpl.class);
        wrapper = ORBUtilSystemException.self;
    }

    static final class OutCallDesc {
        CorbaMessageMediator messageMediator;
        SystemException exception;
        CDRInputObject inputObject;
        ReentrantLock lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();

        OutCallDesc() {
        }
    }
}

