/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.trace.Cdr;

@Cdr
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class CacheTable<K> {
    private static final ORBUtilSystemException wrapper;
    private boolean noReverseMap;
    private String cacheType;
    private static final int INITIAL_SIZE = 64;
    private static final int MAX_SIZE = 0x40000000;
    private static final int INITIAL_THRESHHOLD = 48;
    private int size;
    private int threshhold;
    private int entryCount;
    private Entry<K>[] map;
    private Entry<K>[] rmap;
    private ORB orb;
    private static Holder __$mm$__0;

    public CacheTable(String cacheType, ORB orb, boolean u) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.noReverseMap = u;
        this.size = 64;
        this.threshhold = 48;
        this.entryCount = 0;
        this.initTables();
    }

    private void initTables() {
        this.map = new Entry[this.size];
        this.rmap = this.noReverseMap ? null : new Entry[this.size];
    }

    private void grow() {
        if (this.size == 0x40000000) {
            return;
        }
        Entry<K>[] oldMap = this.map;
        int oldSize = this.size;
        this.size <<= 1;
        this.threshhold <<= 1;
        this.initTables();
        for (int i = 0; i < oldSize; ++i) {
            Entry e = oldMap[i];
            while (e != null) {
                this.put_table(e.key, e.val);
                e = e.next;
            }
        }
    }

    private int hashModTableSize(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return (h ^ h >>> 7 ^ h >>> 4) & this.size - 1;
    }

    private int hash(K key) {
        return this.hashModTableSize(System.identityHashCode(key));
    }

    private int hash(int val) {
        return this.hashModTableSize(val);
    }

    public final void put(K key, int val) {
        if (this.put_table(key, val)) {
            ++this.entryCount;
            if (this.entryCount > this.threshhold) {
                this.grow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Cdr
    private boolean put_table(K k, int n) {
        boolean bl = false;
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[]{k, n});
        }
        try {
            void __$mm$__;
            boolean __$result$__;
            void val;
            void key;
            int index = this.hash(key);
            Entry e = this.map[index];
            while (e != null) {
                if (e.key == key) {
                    if (e.val != val) {
                        wrapper.duplicateIndirectionOffset();
                    } else {
                        __$result$__ = false;
                        if (__$mm$__ != null) {
                            __$mm$__.exit(0, (Object)__$result$__);
                        }
                        return __$result$__;
                    }
                }
                e = e.next;
            }
            Entry<void> newEntry = new Entry<void>(key, (int)val);
            ((Entry)newEntry).next = (Entry)this.map[index];
            this.map[index] = newEntry;
            if (!this.noReverseMap) {
                int rindex = this.hash((int)val);
                ((Entry)newEntry).rnext = (Entry)this.rmap[rindex];
                this.rmap[rindex] = newEntry;
            }
            __$result$__ = true;
            if (__$mm$__ != null) {
                __$mm$__.exit(0, (Object)__$result$__);
            }
            return __$result$__;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0, (Object)bl);
            }
            throw throwable;
        }
    }

    public final boolean containsKey(K key) {
        return this.getVal(key) != -1;
    }

    public final int getVal(K key) {
        int index = this.hash(key);
        Entry e = this.map[index];
        while (e != null) {
            if (e.key == key) {
                return e.val;
            }
            e = e.next;
        }
        return -1;
    }

    public final boolean containsVal(int val) {
        return this.getKey(val) != null;
    }

    public final K getKey(int val) {
        if (this.noReverseMap) {
            throw wrapper.getKeyInvalidInCacheTable();
        }
        int index = this.hash(val);
        Entry e = this.rmap[index];
        while (e != null) {
            if (e.val == val) {
                return (K)e.key;
            }
            e = e.rnext;
        }
        return null;
    }

    public void done() {
        this.map = null;
        this.rmap = null;
    }

    static {
        MethodMonitorRegistry.registerClass(CacheTable.class);
        wrapper = ORBUtilSystemException.self;
    }

    private class Entry<K> {
        private K key;
        private int val;
        private Entry<K> next;
        private Entry<K> rnext;

        public Entry(K k, int v) {
            this.key = k;
            this.val = v;
            this.next = null;
            this.rnext = null;
        }
    }
}

