/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.generic.MultiSet;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorRegistry;
import com.sun.corba.ee.spi.orbutil.tf.annotation.InfoMethod;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TFEnhanced;
import com.sun.corba.ee.spi.orbutil.tf.annotation.TraceEnhanceLevel;
import com.sun.corba.ee.spi.protocol.PIHandler;
import com.sun.corba.ee.spi.trace.Poa;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.ParameterNames;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

@Poa
@ManagedObject
@Description(value="A POAManager which controls invocations of its POAs")
@TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
public class POAManagerImpl
extends LocalObject
implements POAManager {
    private static final POASystemException wrapper;
    private static final long serialVersionUID = -3308938242684343402L;
    private final POAFactory factory;
    private final PIHandler pihandler;
    private final int myId;
    private final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock(true);
    private final Condition stateCV = this.stateLock.writeLock().newCondition();
    private State state;
    private Set<POAImpl> poas = new HashSet<POAImpl>(4);
    private AtomicInteger nInvocations = new AtomicInteger(0);
    private AtomicInteger nWaiters = new AtomicInteger(0);
    private volatile boolean explicitStateChange;
    private static ThreadLocal<MultiSet<POAManagerImpl>> activeManagers;
    private static Holder __$mm$__0;

    private String stateToString(State state) {
        switch (state.value()) {
            case 0: {
                return "HOLDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "DISCARDING";
            }
            case 3: {
                return "INACTIVE";
            }
        }
        return "State[UNKNOWN]";
    }

    public int hashCode() {
        return this.myId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof POAManagerImpl)) {
            return false;
        }
        POAManagerImpl other = (POAManagerImpl)((Object)obj);
        return other.myId == this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.stateLock.readLock().lock();
        try {
            String string = "POAManagerImpl[" + this.myId + "," + this.stateToString(this.state) + ",nInvocations=" + this.nInvocations + ",nWaiters=" + this.nWaiters + "]";
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The set of POAs managed by this POAManager")
    Set<POAImpl> getManagedPOAs() {
        return new HashSet<POAImpl>(this.poas);
    }

    @ManagedAttribute
    @Description(value="Number of active invocations executing in this POAManager")
    public int numberOfInvocations() {
        return this.nInvocations.get();
    }

    @ManagedAttribute
    @Description(value="Number of threads waiting for invocations to complete in this POAManager")
    public int numberOfWaiters() {
        return this.nWaiters.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    @Description(value="The current state of this POAManager")
    public String displayState() {
        this.stateLock.readLock().lock();
        try {
            String string = this.stateToString(this.state);
            return string;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The POAFactory that manages this POAManager")
    POAFactory getFactory() {
        return this.factory;
    }

    PIHandler getPIHandler() {
        return this.pihandler;
    }

    @InfoMethod
    private void numWaitersStart(int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{n}, n2, 15);
        }
    }

    @InfoMethod
    private void numWaitersEnd(int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{n}, n2, 14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Poa
    private void countedWait() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(6, new Object[0]);
        }
        try {
            void __$mm$__;
            try {
                int num = this.nWaiters.incrementAndGet();
                this.numWaitersStart(num, (MethodMonitor)__$mm$__, 6);
                this.stateCV.await((long)num * 1000L, TimeUnit.MILLISECONDS);
                num = this.nWaiters.decrementAndGet();
                this.numWaitersEnd(num, (MethodMonitor)__$mm$__, 6);
            }
            catch (InterruptedException ex) {
                int num = this.nWaiters.decrementAndGet();
                this.numWaitersEnd(num, (MethodMonitor)__$mm$__, 6);
                catch (Throwable throwable) {
                    int num2 = this.nWaiters.decrementAndGet();
                    this.numWaitersEnd(num2, (MethodMonitor)__$mm$__, 6);
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(6, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(6);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(6);
            }
            throw throwable;
        }
    }

    @InfoMethod
    private void nWaiters(int n, MethodMonitor methodMonitor, int n2) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{n}, n2, 12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    private void notifyWaiters() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(13, new Object[0]);
        }
        try {
            void __$mm$__;
            int num = this.nWaiters.get();
            this.nWaiters(num, (MethodMonitor)__$mm$__, 13);
            if (num > 0) {
                this.stateCV.signalAll();
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(13);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(13);
            }
            throw throwable;
        }
    }

    @ManagedAttribute
    @NameValue
    @Description(value="The ID of this POAManager")
    public int getManagerId() {
        return this.myId;
    }

    POAManagerImpl(POAFactory factory, PIHandler pih) {
        this.factory = factory;
        factory.addPoaManager(this);
        this.pihandler = pih;
        this.myId = factory.newPOAManagerId();
        this.state = State.HOLDING;
        this.explicitStateChange = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPOA(POAImpl poa) {
        this.stateLock.writeLock().lock();
        try {
            if (this.state.value() == 3) {
                throw wrapper.addPoaInactive();
            }
            this.poas.add(poa);
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePOA(POAImpl poa) {
        this.stateLock.writeLock().lock();
        try {
            this.poas.remove(poa);
            if (this.poas.isEmpty()) {
                this.factory.removePoaManager(this);
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @ManagedAttribute
    @Description(value="The ObjectReferenceTemplate state of this POAManager")
    public short getORTState() {
        switch (this.state.value()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @Description(value="Make this POAManager active, so it can handle new requests")
    public void activate() throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(0, new Object[0]);
        }
        try {
            void __$mm$__;
            this.explicitStateChange = true;
            this.stateLock.writeLock().lock();
            try {
                if (this.state.value() == 3) {
                    AdapterInactive adapterInactive = new AdapterInactive();
                    if (__$mm$__ != null) {
                        __$mm$__.exception(0, (Throwable)adapterInactive);
                    }
                    throw adapterInactive;
                }
                this.state = State.ACTIVE;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
                this.stateLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                this.stateLock.writeLock().unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(0, throwable2);
                }
                throw throwable2;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(0);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(0);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @Description(value="Hold all requests to this POAManager")
    public void hold_requests(boolean bl) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(11, new Object[]{bl});
        }
        try {
            void __$mm$__;
            this.explicitStateChange = true;
            this.stateLock.writeLock().lock();
            try {
                void wait_for_completion;
                if (this.state.value() == 3) {
                    AdapterInactive adapterInactive = new AdapterInactive();
                    if (__$mm$__ != null) {
                        __$mm$__.exception(11, (Throwable)adapterInactive);
                    }
                    throw adapterInactive;
                }
                this.state = State.HOLDING;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
                if (wait_for_completion != false) {
                    while (this.state.value() == 0 && this.nInvocations.get() > 0) {
                        this.countedWait();
                    }
                }
                this.stateLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                this.stateLock.writeLock().unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(11, throwable2);
                }
                throw throwable2;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(11);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(11);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    @ManagedOperation
    @ParameterNames(value={"waitForCompletion"})
    @Description(value="Make this POAManager discard all incoming requests")
    public void discard_requests(boolean bl) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(8, new Object[]{bl});
        }
        try {
            void __$mm$__;
            this.explicitStateChange = true;
            this.stateLock.writeLock().lock();
            try {
                void wait_for_completion;
                if (this.state.value() == 3) {
                    AdapterInactive adapterInactive = new AdapterInactive();
                    if (__$mm$__ != null) {
                        __$mm$__.exception(8, (Throwable)adapterInactive);
                    }
                    throw adapterInactive;
                }
                this.state = State.DISCARDING;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
                if (wait_for_completion != false) {
                    while (this.state.value() == 2 && this.nInvocations.get() > 0) {
                        this.countedWait();
                    }
                }
                this.stateLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                this.stateLock.writeLock().unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(8, throwable2);
                }
                throw throwable2;
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(8);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(7, new Object[]{bl, bl2});
        }
        try {
            void wait_for_completion;
            void etherealize_objects;
            void __$mm$__;
            this.stateLock.writeLock().lock();
            try {
                this.explicitStateChange = true;
                if (this.state.value() == 3) {
                    AdapterInactive adapterInactive = new AdapterInactive();
                    if (__$mm$__ != null) {
                        __$mm$__.exception(7, (Throwable)adapterInactive);
                    }
                    throw adapterInactive;
                }
                this.state = State.INACTIVE;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
                this.stateLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                this.stateLock.writeLock().unlock();
                Throwable throwable2 = throwable;
                if (__$mm$__ != null) {
                    __$mm$__.exception(7, throwable2);
                }
                throw throwable2;
            }
            POAManagerDeactivator deactivator = new POAManagerDeactivator(this, (boolean)etherealize_objects);
            if (wait_for_completion != false) {
                deactivator.run();
            } else {
                Thread thr = new Thread(deactivator);
                thr.start();
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(7);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(7);
            }
            throw throwable;
        }
    }

    public State get_state() {
        return this.state;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @InfoMethod
    private void activeManagers(MultiSet multiSet, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{multiSet}, n, 2);
        }
    }

    @InfoMethod
    private void alreadyActive(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 4);
        }
    }

    @InfoMethod
    private void activeInDifferentPoaManager(MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[0], n, 1);
        }
    }

    /*
     * Exception decompiling
     */
    @Poa
    private void checkState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @InfoMethod
    private void addingThreadToActiveManagers(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 3);
        }
    }

    @InfoMethod
    private void removingThreadFromActiveManagers(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
        if (methodMonitor != null) {
            methodMonitor.info(new Object[]{pOAManagerImpl}, n, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    void enter() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(9, new Object[0]);
        }
        try {
            void __$mm$__;
            this.checkState();
            this.nInvocations.getAndIncrement();
            activeManagers.get().add((Object)this);
            this.addingThreadToActiveManagers(this, (MethodMonitor)__$mm$__, 9);
            if (__$mm$__ != null) {
                __$mm$__.exit(9);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(9);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Poa
    void exit() {
        MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
        if (methodMonitor != null) {
            methodMonitor.enter(10, new Object[0]);
        }
        try {
            void __$mm$__;
            block16: {
                try {
                    activeManagers.get().remove((Object)this);
                    this.removingThreadFromActiveManagers(this, (MethodMonitor)__$mm$__, 10);
                    if (this.nInvocations.decrementAndGet() != 0) break block16;
                    int num = this.nWaiters.get();
                    this.nWaiters(num, (MethodMonitor)__$mm$__, 10);
                    if (num <= 0) break block16;
                    this.stateLock.writeLock().lock();
                }
                catch (Throwable throwable) {
                    if (this.nInvocations.decrementAndGet() == 0) {
                        int num = this.nWaiters.get();
                        this.nWaiters(num, (MethodMonitor)__$mm$__, 10);
                        if (num > 0) {
                            this.stateLock.writeLock().lock();
                            try {
                                this.stateCV.signalAll();
                                this.stateLock.writeLock().unlock();
                            }
                            catch (Throwable throwable2) {
                                this.stateLock.writeLock().unlock();
                                Throwable throwable3 = throwable2;
                                if (__$mm$__ != null) {
                                    __$mm$__.exception(10, throwable3);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    Throwable throwable4 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(10, throwable4);
                    }
                    throw throwable4;
                }
                try {
                    this.stateCV.signalAll();
                    this.stateLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.stateLock.writeLock().unlock();
                    Throwable throwable5 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(10, throwable5);
                    }
                    throw throwable5;
                }
            }
            if (__$mm$__ != null) {
                __$mm$__.exit(10);
            }
            return;
        }
        catch (Throwable throwable) {
            if (methodMonitor != null) {
                methodMonitor.exit(10);
            }
            throw throwable;
        }
    }

    public void implicitActivation() {
        if (!this.explicitStateChange) {
            try {
                this.activate();
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    static {
        MethodMonitorRegistry.registerClass(POAManagerImpl.class);
        wrapper = POASystemException.self;
        activeManagers = new ThreadLocal<MultiSet<POAManagerImpl>>(){

            @Override
            public MultiSet<POAManagerImpl> initialValue() {
                return new MultiSet();
            }
        };
    }

    @Poa
    @TFEnhanced(stage=TraceEnhanceLevel.PHASE2)
    private static class POAManagerDeactivator
    implements Runnable {
        private boolean etherealize_objects;
        private final POAManagerImpl pmi;
        private static Holder __$mm$__0;

        @InfoMethod
        private void poaManagerDeactivatorCall(boolean bl, POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{bl, pOAManagerImpl}, n, 0);
            }
        }

        @InfoMethod
        private void preparingToEtherealize(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{pOAManagerImpl}, n, 1);
            }
        }

        @InfoMethod
        private void removeAndClear(POAManagerImpl pOAManagerImpl, MethodMonitor methodMonitor, int n) {
            if (methodMonitor != null) {
                methodMonitor.info(new Object[]{pOAManagerImpl}, n, 2);
            }
        }

        POAManagerDeactivator(POAManagerImpl pmi, boolean etherealize_objects) {
            this.etherealize_objects = etherealize_objects;
            this.pmi = pmi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Poa
        public void run() {
            MethodMonitor methodMonitor = (MethodMonitor)__$mm$__0.content();
            if (methodMonitor != null) {
                methodMonitor.enter(3, new Object[0]);
            }
            try {
                void __$mm$__;
                this.pmi.stateLock.writeLock().lock();
                try {
                    this.poaManagerDeactivatorCall(this.etherealize_objects, this.pmi, (MethodMonitor)__$mm$__, 3);
                    while (this.pmi.nInvocations.get() > 0) {
                        this.pmi.countedWait();
                    }
                    this.pmi.stateLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.pmi.stateLock.writeLock().unlock();
                    Throwable throwable2 = throwable;
                    if (__$mm$__ != null) {
                        __$mm$__.exception(3, throwable2);
                    }
                    throw throwable2;
                }
                if (this.etherealize_objects) {
                    HashSet copyOfPOAs;
                    this.pmi.stateLock.readLock().lock();
                    try {
                        this.preparingToEtherealize(this.pmi, (MethodMonitor)__$mm$__, 3);
                        copyOfPOAs = new HashSet(this.pmi.poas);
                        this.pmi.stateLock.readLock().unlock();
                    }
                    catch (Throwable throwable) {
                        this.pmi.stateLock.readLock().unlock();
                        Throwable throwable3 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(3, throwable3);
                        }
                        throw throwable3;
                    }
                    for (POAImpl poa : copyOfPOAs) {
                        poa.etherealizeAll();
                    }
                    this.pmi.stateLock.writeLock().lock();
                    try {
                        this.removeAndClear(this.pmi, (MethodMonitor)__$mm$__, 3);
                        this.pmi.factory.removePoaManager(this.pmi);
                        this.pmi.poas.clear();
                        this.pmi.stateLock.writeLock().unlock();
                    }
                    catch (Throwable throwable) {
                        this.pmi.stateLock.writeLock().unlock();
                        Throwable throwable4 = throwable;
                        if (__$mm$__ != null) {
                            __$mm$__.exception(3, throwable4);
                        }
                        throw throwable4;
                    }
                }
                if (__$mm$__ != null) {
                    __$mm$__.exit(3);
                }
                return;
            }
            catch (Throwable throwable) {
                if (methodMonitor != null) {
                    methodMonitor.exit(3);
                }
                throw throwable;
            }
        }

        static {
            MethodMonitorRegistry.registerClass(POAManagerDeactivator.class);
        }
    }
}

