/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.maven.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.nbheaven.sqe.core.maven.api.MavenPluginConfiguration;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenUtilities {
    private MavenUtilities() {
    }

    public static MavenPluginConfiguration getReportPluginConfiguration(Project project, String groupId, String artifactId) {
        MavenProject prj = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        return MavenUtilities.getReportPluginConfigurationImpl(prj, groupId, artifactId);
    }

    static MavenPluginConfiguration getReportPluginConfigurationImpl(final MavenProject project, final String groupId, final String artifactId) {
        return new MavenPluginConfiguration(){

            public String getValue(String path) {
                String v = PluginPropertyUtils.getReportPluginProperty((MavenProject)project, (String)groupId, (String)artifactId, (String)path, null);
                return v != null ? v : PluginPropertyUtils.getPluginProperty((MavenProject)project, (String)groupId, (String)artifactId, (String)path, null);
            }

            public String[] getStringListValue(String listParent, String listChild) {
                String[] v = PluginPropertyUtils.getReportPluginPropertyList((MavenProject)project, (String)groupId, (String)artifactId, (String)listParent, (String)listChild, null);
                return v != null ? v : PluginPropertyUtils.getPluginPropertyList((MavenProject)project, (String)groupId, (String)artifactId, (String)listParent, (String)listChild, null);
            }

            public boolean isDefinedInProject() {
                return MavenUtilities.definesReportPlugin(project, groupId, artifactId);
            }
        };
    }

    static boolean definesReportPlugin(MavenProject mp, String groupId, String artifactId) {
        return PluginPropertyUtils.getPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null || PluginPropertyUtils.getReportPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null;
    }

    public static List<File> findDependencyArtifacts(Project project, String pluginGroupId, String pluginArtifactId, boolean includePluginArtifact) {
        ArrayList<File> cpFiles = new ArrayList<File>();
        NbMavenProject p = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        MavenProject mp = p.getMavenProject();
        if (includePluginArtifact) {
            HashSet arts = new HashSet();
            arts.addAll(mp.getReportArtifacts());
            arts.addAll(mp.getPluginArtifacts());
            for (Artifact a : arts) {
                if (!pluginArtifactId.equals(a.getArtifactId()) || !pluginGroupId.equals(a.getGroupId())) continue;
                File f = a.getFile();
                if (f == null) {
                    f = FileUtil.normalizeFile((File)new File(new File(online.getLocalRepository().getBasedir()), online.getLocalRepository().pathOf(a)));
                }
                if (!f.exists()) {
                    try {
                        online.resolve(a, mp.getRemoteArtifactRepositories(), online.getLocalRepository());
                    }
                    catch (ArtifactResolutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ArtifactNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (!f.exists()) continue;
                cpFiles.add(f);
                try {
                    DefaultProjectBuildingRequest req = new DefaultProjectBuildingRequest();
                    req.setRemoteRepositories(mp.getRemoteArtifactRepositories());
                    req.setValidationLevel(0);
                    req.setSystemProperties(online.getSystemProperties());
                    ProjectBuildingResult res = online.buildProject(a, (ProjectBuildingRequest)req);
                    MavenProject mp2 = res.getProject();
                    if (mp2 == null) continue;
                    for (Dependency dep : mp2.getDependencies()) {
                        Artifact a2 = online.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "jar");
                        online.resolve(a2, mp.getRemoteArtifactRepositories(), online.getLocalRepository());
                        File df = a2.getFile();
                        if (!df.exists()) continue;
                        cpFiles.add(df);
                    }
                }
                catch (Exception x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        }
        List plugins = mp.getBuildPlugins();
        for (Plugin plug : plugins) {
            if (!pluginArtifactId.equals(plug.getArtifactId()) || !pluginGroupId.equals(plug.getGroupId())) continue;
            try {
                List deps = plug.getDependencies();
                ArtifactFactory artifactFactory = (ArtifactFactory)online.getPlexus().lookup(ArtifactFactory.class);
                for (Dependency d : deps) {
                    Artifact projectArtifact = artifactFactory.createArtifactWithClassifier(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType(), d.getClassifier());
                    String localPath = online.getLocalRepository().pathOf(projectArtifact);
                    File f = FileUtil.normalizeFile((File)new File(online.getLocalRepository().getBasedir(), localPath));
                    if (!f.exists()) {
                        try {
                            online.resolve(projectArtifact, mp.getRemoteArtifactRepositories(), online.getLocalRepository());
                        }
                        catch (ArtifactResolutionException ex) {
                            ex.printStackTrace();
                        }
                        catch (ArtifactNotFoundException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (!f.exists()) continue;
                    cpFiles.add(f);
                }
            }
            catch (ComponentLookupException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return cpFiles;
    }
}

