/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.ui.panel;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.spi.SQEUtilities;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.api.SQEManager;
import org.netbeans.api.project.Project;

public class DefectProviderConfigurationPanel
extends JPanel {
    public DefectProviderConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        for (QualityProvider provider : SQEUtilities.getProviders()) {
            CodeDefectProviderSelector checkbox = new CodeDefectProviderSelector(provider);
            checkbox.setProject(null);
            this.add(checkbox);
        }
    }

    private class CodeDefectProviderSelector
    extends JCheckBox
    implements PropertyChangeListener,
    ActionListener {
        private QualityProvider provider;
        private Project project;

        public CodeDefectProviderSelector(QualityProvider provider) {
            this.provider = provider;
            this.setText(provider.getDisplayName());
            this.addActionListener(this);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        public void actionPerformed(ActionEvent e) {
            SQECodedefectProperties.setQualityProviderActive((Project)this.project, (QualityProvider)this.provider, (boolean)this.isSelected());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setProject(SQEManager.getDefault().getActiveProject());
        }

        private void setProject(Project project) {
            this.project = project;
            if (null != project) {
                this.setSelected(SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)this.provider));
                this.setEnabled(true);
            } else {
                this.setSelected(false);
                this.setEnabled(false);
            }
        }

        public void addNotify() {
            super.addNotify();
            SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        }

        public void removeNotify() {
            SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
            super.removeNotify();
        }
    }
}

