/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.ui.actions;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.spi.SQEUtilities;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.codedefects.ui.UIHandle;
import org.nbheaven.sqe.codedefects.ui.utils.UiUtils;
import org.netbeans.api.project.Project;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;

public class RunAllQualityProvidersAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
PropertyChangeListener {
    private Lookup context;
    private Lookup.Result<Project> lkpInfo;

    public RunAllQualityProvidersAction() {
        this(Utilities.actionsGlobalContext());
    }

    private RunAllQualityProvidersAction(Lookup context) {
        this.putValue("Name", NbBundle.getMessage(RunAllQualityProvidersAction.class, (String)"LBL_RunAllQualityProvidersAction"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/nbheaven/sqe/codedefects/ui/resources/sqe.png")));
        this.context = context;
    }

    public Action createContextAwareInstance(Lookup context) {
        return new RunAllQualityProvidersAction(context);
    }

    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    private void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        SQECodedefectProperties.addPropertyChangeListener((PropertyChangeListener)this);
        Lookup.Template tpl = new Lookup.Template(Project.class);
        this.lkpInfo = this.context.lookup(tpl);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        this.updateEnableState();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnableState();
    }

    private void updateEnableState() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RunAllQualityProvidersAction.this.updateEnableState();
                }
            });
            return;
        }
        this.setEnabled(RunAllQualityProvidersAction.areQualityProvidersActive(this.getActiveProject()));
    }

    private Project getActiveProject() {
        Collection projects = this.lkpInfo.allInstances();
        if (projects.size() == 1) {
            Project project = (Project)projects.iterator().next();
            return project;
        }
        return null;
    }

    private static boolean areQualityProvidersActive(Project project) {
        if (null != project) {
            for (QualityProvider provider : SQEUtilities.getProviders()) {
                if (!provider.isValidFor(project) || !SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)provider)) continue;
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Project project = this.getActiveProject();
        if (null != project) {
            for (QualityProvider provider : SQEUtilities.getProviders()) {
                if (!provider.isValidFor(project) || !SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)provider)) continue;
                ComputeResultTask computeResultTask = new ComputeResultTask(project, provider);
                RequestProcessor.getDefault().post((Runnable)((Object)computeResultTask));
            }
        }
    }

    private static final class ComputeResultTask
    extends Task {
        private final QualitySession qualitySession;
        private final QualityProvider qualityProvider;

        private ComputeResultTask(Project project, QualityProvider provider) {
            this.qualityProvider = provider;
            this.qualitySession = (QualitySession)project.getLookup().lookup(provider.getQualitySessionClass());
        }

        public final void run() {
            this.qualitySession.computeResult();
            SwingUtilities.invokeLater(new UIUpdateTask(this.qualityProvider));
        }
    }

    private static class UIUpdateTask
    implements Runnable {
        private final QualityProvider qualityProvider;

        private UIUpdateTask(QualityProvider qualityProvider) {
            this.qualityProvider = qualityProvider;
        }

        public final void run() {
            UIHandle uiHandle = UiUtils.getUIHandle(this.qualityProvider);
            if (null != uiHandle) {
                uiHandle.open();
            }
        }
    }
}

