/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.ui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.utilities.SQEProjectSupport;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public abstract class AbstractShowAnnotationsAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Toolbar {
    @NonNull
    private final Lookup lookup;
    private JToggleButton button;

    protected AbstractShowAnnotationsAction(@NullAllowed Lookup lookup) {
        Lookup lookup2 = this.lookup = lookup != null ? lookup : Utilities.actionsGlobalContext();
        assert (this.lookup != null);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        DataObject dataObject = (DataObject)this.lookup.lookup(DataObject.class);
        Project project = SQEProjectSupport.findProject((DataObject)dataObject);
        boolean old = SQECodedefectProperties.isQualityProviderAnnotateActive((Project)project, (QualityProvider)this.getQualityProvider());
        SQECodedefectProperties.setQualityProviderAnnotateActive((Project)project, (QualityProvider)this.getQualityProvider(), (!old ? 1 : 0) != 0);
    }

    public abstract Action createContextAwareInstance(Lookup var1);

    public final Component getToolbarPresenter() {
        if (null == this.button) {
            this.button = new MyToolbarToggleButton();
            DataObject dataObject = (DataObject)this.lookup.lookup(DataObject.class);
            Project project = SQEProjectSupport.findProject((DataObject)dataObject);
            this.button.setModel(new ToggleButtonModel(project, this.getQualityProvider()));
            this.button.putClientProperty("hideActionText", Boolean.TRUE);
            this.button.setAction(this);
            if (null == project) {
                this.setEnabled(false);
            }
            return this.button;
        }
        return this.button;
    }

    protected abstract QualityProvider getQualityProvider();

    private static final class MyToolbarToggleButton
    extends JToggleButton
    implements ChangeListener {
        public void setModel(ButtonModel model) {
            ButtonModel oldModel = this.getModel();
            if (oldModel != null) {
                oldModel.removeChangeListener(this);
            }
            super.setModel(model);
            ButtonModel newModel = this.getModel();
            if (newModel != null) {
                newModel.addChangeListener(this);
            }
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent evt) {
            boolean selected = this.isSelected();
            super.setContentAreaFilled(selected);
            super.setBorderPainted(selected);
        }

        public void setBorderPainted(boolean arg0) {
            if (!this.isSelected()) {
                super.setBorderPainted(arg0);
            }
        }

        public void setContentAreaFilled(boolean arg0) {
            if (!this.isSelected()) {
                super.setContentAreaFilled(arg0);
            }
        }
    }

    private static final class ToggleButtonModel
    extends JToggleButton.ToggleButtonModel
    implements PropertyChangeListener {
        private final QualityProvider qualityProvider;
        private final Project project;

        public ToggleButtonModel(Project project, QualityProvider qualityProvider) {
            this.project = project;
            this.qualityProvider = qualityProvider;
            if (null != this.project) {
                SQECodedefectProperties.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, SQECodedefectProperties.class));
                this.propertyChange(null);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt == null || evt.getPropertyName() == null || evt.getPropertyName().equals(SQECodedefectProperties.getPropertyNameAnnotateActive((QualityProvider)this.qualityProvider))) {
                this.setSelected(SQECodedefectProperties.isQualityProviderAnnotateActive((Project)this.project, (QualityProvider)this.qualityProvider));
            }
        }
    }
}

