/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.AuthorizationElement;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityContextUtil;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class SecClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private String name;
    private String prname;
    private Codec codec;
    private GlassFishORBHelper orbHelper;
    private SecurityContextUtil secContextUtil;
    private Habitat habitat;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;

    public SecClientRequestInterceptor(String name, Codec codec, Habitat habitat) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
        this.habitat = habitat;
        this.orbHelper = Lookups.getGlassFishORBHelper(habitat);
        this.secContextUtil = Lookups.getSecurityContextUtil(habitat);
    }

    public String name() {
        return this.name;
    }

    private java.lang.Object getCred(Set credset, Class c) {
        java.lang.Object cred2 = null;
        String clsname = c.getName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Checking for a single instance of class in subject");
            _logger.log(Level.FINE, "    Classname = " + clsname);
        }
        if (credset.size() != 1) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "iiop.multiple_credset", new java.lang.Object[]{credset.size(), clsname});
            }
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.inv_credlist_size", "Credential list size is not 1."));
        }
        for (java.lang.Object cred2 : credset) {
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Verified single instance of class ( " + clsname + " )");
        }
        return cred2;
    }

    private byte[] createAuthToken(java.lang.Object cred, Class cls, ORB orb, CompoundSecMech mech) throws Exception {
        byte[] gsstoken = new byte[]{};
        if (PasswordCredential.class.isAssignableFrom(cls)) {
            _logger.log(Level.FINE, "Constructing a PasswordCredential client auth token");
            PasswordCredential pwdcred = (PasswordCredential)cred;
            GSSUPToken tok = GSSUPToken.getClientSideInstance(orb, this.codec, pwdcred, mech);
            gsstoken = tok.getGSSToken();
        }
        return gsstoken;
    }

    private IdentityToken createIdToken(java.lang.Object cred, Class cls, ORB orb) throws Exception {
        IdentityToken idtok = null;
        DerOutputStream dos = new DerOutputStream();
        DerValue[] derval = null;
        Any any = orb.create_any();
        idtok = new IdentityToken();
        if (X500Name.class.isAssignableFrom(cls)) {
            _logger.log(Level.FINE, "Constructing an X500 DN Identity Token");
            X500Name credname = (X500Name)cred;
            credname.encode(dos);
            X501DistinguishedNameHelper.insert((Any)any, (byte[])dos.toByteArray());
            idtok.dn(this.codec.encode_value(any));
        } else if (X509CertificateCredential.class.isAssignableFrom(cls)) {
            _logger.log(Level.FINE, "Constructing an X509 Certificate Chain Identity Token");
            X509CertificateCredential certcred = (X509CertificateCredential)cred;
            X509Certificate[] certchain = certcred.getX509CertificateChain();
            _logger.log(Level.FINE, "Certchain length = " + certchain.length);
            derval = new DerValue[certchain.length];
            for (int i = 0; i < certchain.length; ++i) {
                derval[i] = new DerValue(certchain[i].getEncoded());
            }
            dos.putSequence(derval);
            X509CertificateChainHelper.insert((Any)any, (byte[])dos.toByteArray());
            idtok.certificate_chain(this.codec.encode_value(any));
        } else if (AnonCredential.class.isAssignableFrom(cls)) {
            _logger.log(Level.FINE, "Constructing an Anonymous Identity Token");
            idtok.anonymous(true);
        } else if (GSSUPName.class.isAssignableFrom(cls)) {
            _logger.log(Level.FINE, "Constructing a GSS Exported name Identity Token");
            GSSUPName gssname = (GSSUPName)cred;
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert((Any)any, (byte[])expname);
            idtok.principal_name(this.codec.encode_value(any));
        }
        return idtok;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        long cContextId = 0L;
        ConnectionExecutionContext.removeClientThreadID();
        AuthorizationElement[] cAuthzElem = new AuthorizationElement[]{};
        IdentityToken cIdentityToken = null;
        byte[] cAuthenticationToken = new byte[]{};
        byte[] cdr_encoded_saselm = null;
        java.lang.Object cred = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "send_request" + "()");
        }
        SecurityContext secctxt = null;
        ORB orb = this.orbHelper.getORB();
        Object effective_target = ri.effective_target();
        try {
            secctxt = this.secContextUtil.getSecurityContext(effective_target);
        }
        catch (InvalidMechanismException ime) {
            _logger.log(Level.SEVERE, "iiop.sec_context_exception", ime);
            throw new RuntimeException(ime.getMessage());
        }
        catch (InvalidIdentityTokenException iite) {
            _logger.log(Level.SEVERE, "iiop.runtime_exception", iite);
            throw new RuntimeException(iite.getMessage());
        }
        if (secctxt == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Security context is null (nothing to add to service context)");
            }
            return;
        }
        final SecurityContext sCtx = secctxt;
        if (secctxt.authcls != null) {
            cred = AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    return SecClientRequestInterceptor.this.getCred(sCtx.subject.getPrivateCredentials(sCtx.authcls), sCtx.authcls);
                }
            });
            try {
                SecurityMechanismSelector sms = Lookups.getSecurityMechanismSelector(this.habitat);
                ConnectionContext cc = sms.getClientConnectionContext();
                CompoundSecMech mech = cc.getMechanism();
                cAuthenticationToken = this.createAuthToken(cred, secctxt.authcls, orb, mech);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iiop.createauthtoken_exception", e);
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_authtok_create", "Error while constructing an authentication token."));
            }
        }
        if (secctxt.identcls != null) {
            cred = this.getCred(secctxt.subject.getPublicCredentials(secctxt.identcls), secctxt.identcls);
            try {
                cIdentityToken = this.createIdToken(cred, secctxt.identcls, orb);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iiop.createidtoken_exception", e);
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_idtok_create", "Error while constructing an identity token."));
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Constructing an Absent Identity Token");
            }
            cIdentityToken = new IdentityToken();
            cIdentityToken.absent(true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating an EstablishContext message");
        }
        EstablishContext ec = new EstablishContext(cContextId, cAuthzElem, cIdentityToken, cAuthenticationToken);
        SASContextBody sasctxbody = new SASContextBody();
        sasctxbody.establish_msg(ec);
        Any SasAny = orb.create_any();
        SASContextBodyHelper.insert((Any)SasAny, (SASContextBody)sasctxbody);
        try {
            cdr_encoded_saselm = this.codec.encode_value(SasAny);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", e);
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_encode", "CDR Encoding error for a SAS context element."));
        }
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Adding EstablishContext message to service context list");
        }
        boolean no_replace = false;
        ri.add_request_service_context(sc, no_replace);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added EstablishContext message to service context list");
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    private void setreplyStatus(int status, Object target) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Status to be set : " + status);
        }
        SecurityContextUtil.receivedReply(status, target);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Invoked receivedReply()");
        }
    }

    private int mapreplyStatus(int repst) {
        int status;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Reply status to be mapped =  " + repst);
        }
        switch (repst) {
            case 0: 
            case 2: {
                status = 0;
                break;
            }
            case 3: 
            case 4: {
                status = 2;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            default: {
                status = repst;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mapped reply status = " + status);
        }
        return status;
    }

    private void handle_null_service_context(ClientRequestInfo ri) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "No SAS context element found in service context list");
        }
        this.setreplyStatus(0, ri.effective_target());
    }

    public void receive_reply(ClientRequestInfo ri) {
        ServiceContext sc = null;
        int status = -1;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_reply");
        }
        ORB orb = this.orbHelper.getORB();
        try {
            sc = ri.get_reply_service_context(15);
            if (sc == null) {
                this.handle_null_service_context(ri);
                return;
            }
        }
        catch (BAD_PARAM e) {
            this.handle_null_service_context(ri);
            return;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "iiop.service_context_exception", ex);
            return;
        }
        Any a = orb.create_any();
        try {
            a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", e);
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)a);
        short sasdiscr = sasctxbody.discriminator();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Received " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Verifying the SAS protocol reply message");
        }
        if (sasdiscr != 1 && sasdiscr != 4) {
            _logger.log(Level.SEVERE, "iiop.invalid_reply_message");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_not_cecec_msg", "Reply message not one of CompleteEstablishContext or ContextError."));
        }
        int st = this.mapreplyStatus(ri.reply_status());
        this.setreplyStatus(st, ri.effective_target());
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_exception");
        }
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }

    static {
        _logger = LogDomains.getLogger(SecClientRequestInterceptor.class, (String)"javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(SecClientRequestInterceptor.class);
    }
}

