/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.views;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VariablesViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_VALUE_AS_STRING = "show_value_as_string";
    private static final String SHOW_FORMATTERS_PROP_NAME = "org.netbeans.modules.debugger.jpda.ui.options.SHOW_FORMATTERS";
    private static JToggleButton showValueAsStringToggle = null;

    public static JButton createOpenOptionsButton() {
        JButton button = VariablesViewButtons.createButton("org/netbeans/modules/debugger/jpda/resources/formatters_options_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Open_Formatters"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty(VariablesViewButtons.SHOW_FORMATTERS_PROP_NAME, "true");
                OptionsDisplayer.getDefault().open("Java/JavaDebugger");
            }
        });
        return button;
    }

    public static synchronized JToggleButton createShowValueAsStringButton() {
        if (showValueAsStringToggle != null) {
            return showValueAsStringToggle;
        }
        showValueAsStringToggle = VariablesViewButtons.createToggleButton(SHOW_VALUE_AS_STRING, "org/netbeans/modules/debugger/jpda/resources/show_variable_values_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Value_As_String"));
        showValueAsStringToggle.addActionListener(new ShowValueAsStringActionListener(showValueAsStringToggle));
        return showValueAsStringToggle;
    }

    private static JButton createButton(String iconPath, String tooltip) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
        JButton button = new JButton(icon);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        button.setPreferredSize(size);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setBorder(new EmptyBorder(button.getBorder().getBorderInsets(button)));
        button.setToolTipText(tooltip);
        button.setFocusable(false);
        return button;
    }

    private static JToggleButton createToggleButton(String id, String iconPath, String tooltip) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
        boolean isSelected = VariablesViewButtons.isButtonSelected(id);
        JToggleButton toggleButton = new JToggleButton(icon, isSelected);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        toggleButton.setPreferredSize(size);
        toggleButton.setMargin(new Insets(1, 1, 1, 1));
        if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toggleButton.setBorder(new EmptyBorder(toggleButton.getBorder().getBorderInsets(toggleButton)));
        }
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusable(false);
        return toggleButton;
    }

    public static boolean isShowValuesAsString() {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_VALUE_AS_STRING, false);
    }

    private static boolean isButtonSelected(String name) {
        if (name.equals(SHOW_VALUE_AS_STRING)) {
            return VariablesViewButtons.isShowValuesAsString();
        }
        return false;
    }

    private static void setButtonSelected(String name, boolean selected) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        preferences.putBoolean(name, selected);
    }

    private static class ShowValueAsStringActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowValueAsStringActionListener(JToggleButton toggleButton) {
            this.button = toggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_VALUE_AS_STRING, isSelected);
        }
    }
}

