/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SourcesModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private Listener listener;
    private SourcePath sourcePath;
    private JPDADebugger debugger;
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> additionalSourceRoots = null;
    private final Set<String> sourceRootsSet = new HashSet<String>();
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int state;
            File currentSourceRoot;
            if (SourcesModel.this.newSourceFileChooser == null) {
                SourcesModel.this.newSourceFileChooser = new JFileChooser();
                SourcesModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return false;
                        }
                    }
                });
            }
            if ((currentSourceRoot = SourcesModel.getCurrentSourceRoot()) != null) {
                SourcesModel.this.newSourceFileChooser.setSelectedFile(currentSourceRoot);
            }
            if ((state = SourcesModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File zipOrDir = SourcesModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!zipOrDir.isDirectory() && !FileUtil.isArchiveFile((URL)zipOrDir.toURI().toURL())) {
                        return;
                    }
                    String d = zipOrDir.getCanonicalPath();
                    SourcesModel sourcesModel = SourcesModel.this;
                    synchronized (sourcesModel) {
                        SourcesModel.this.additionalSourceRoots.add(d);
                    }
                    String[] sourceRoots = SourcesModel.this.sourcePath.getSourceRoots();
                    int l = sourceRoots.length;
                    String[] newSourceRoots = new String[l + 1];
                    System.arraycopy(sourceRoots, 0, newSourceRoots, 0, l);
                    newSourceRoots[l] = d;
                    SourcesModel.this.sourcePath.setSourceRoots(newSourceRoots, SourcesModel.this.additionalSourceRoots.toArray(new String[0]));
                    SourcesModel.this.fireTreeChanged();
                }
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify((Throwable)ioex);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                String node = (String)nodes[i];
                SourcesModel sourcesModel = SourcesModel.this;
                synchronized (sourcesModel) {
                    SourcesModel.this.additionalSourceRoots.remove(node);
                }
                String[] sourceRoots = SourcesModel.this.sourcePath.getSourceRoots();
                int l = sourceRoots.length;
                String[] newSourceRoots = new String[l - 1];
                int index = -1;
                for (int ii = 0; ii < l; ++ii) {
                    if (!node.equals(sourceRoots[ii])) continue;
                    index = ii;
                    break;
                }
                if (index < 0) continue;
                System.arraycopy(sourceRoots, 0, newSourceRoots, 0, index);
                System.arraycopy(sourceRoots, index + 1, newSourceRoots, index, l - (index + 1));
                SourcesModel.this.sourcePath.setSourceRoots(newSourceRoots, SourcesModel.this.additionalSourceRoots.toArray(new String[0]));
            }
            SourcesModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_UP_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_MoveUpSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            String[] roots = SourcesModel.this.sourcePath.getOriginalSourceRoots();
            return roots.length > 0 && !roots[0].equals(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesModel sourcesModel = SourcesModel.this;
            synchronized (sourcesModel) {
                String[] roots = SourcesModel.this.sourcePath.getOriginalSourceRoots();
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = 0; i < n; ++i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i <= 0) continue;
                        permutation[i] = permutation[i - 1];
                        permutation[i - 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                SourcesModel.this.sourcePath.reorderOriginalSourceRoots(permutation);
            }
            SourcesModel.this.fireTreeChanged();
            SourcesModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_DOWN_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_MoveDownSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            String[] roots = SourcesModel.this.sourcePath.getOriginalSourceRoots();
            return roots.length > 0 && !roots[roots.length - 1].equals(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesModel sourcesModel = SourcesModel.this;
            synchronized (sourcesModel) {
                String[] roots = SourcesModel.this.sourcePath.getOriginalSourceRoots();
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = n - 1; i >= 0; --i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i >= n - 1) continue;
                        permutation[i] = permutation[i + 1];
                        permutation[i + 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                SourcesModel.this.sourcePath.reorderOriginalSourceRoots(permutation);
            }
            SourcesModel.this.fireTreeChanged();
            SourcesModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action RESET_ORDER_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_ResetOrderSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            SourcesModel.this.sourcePath.reorderOriginalSourceRoots(null);
            SourcesModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesModel(ContextProvider lookupProvider) {
        this.sourcePath = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.updateCachedRoots();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.MOVE_UP_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.MOVE_DOWN_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.RESET_ORDER_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            String[] sourceRoots = this.sourcePath.getOriginalSourceRoots();
            SourcesModel sourcesModel = this;
            synchronized (sourcesModel) {
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new LinkedHashSet<String>(Arrays.asList(this.sourcePath.getAdditionalSourceRoots()));
                }
            }
            String[] os = sourceRoots;
            to = Math.min(os.length, to);
            from = Math.min(os.length, from);
            Object[] fos = new Object[to - from];
            System.arraycopy(os, from, fos, 0, to - from);
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return fos;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private void fireSelectedNodes(Object[] nodes) {
        ModelEvent.SelectionChanged event = new ModelEvent.SelectionChanged((Object)this, nodes);
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    public boolean isCheckable(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return this.isEnabled((String)node);
        }
        throw new UnknownTypeException(node);
    }

    public void setSelected(NodeModel original, Object node, Boolean selected) throws UnknownTypeException {
        if (node instanceof String) {
            this.setEnabled((String)node, selected);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            if (this.additionalSourceRoots.contains(node)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String root) {
        SourcesModel sourcesModel = this;
        synchronized (sourcesModel) {
            return this.sourceRootsSet.contains(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String root, boolean enabled) {
        String[] ss;
        SourcesModel sourcesModel = this;
        synchronized (sourcesModel) {
            if (enabled) {
                this.sourceRootsSet.add(root);
            } else {
                this.sourceRootsSet.remove(root);
            }
            ss = this.sourceRootsSet.toArray(new String[0]);
        }
        this.sourcePath.setSourceRoots(ss, this.additionalSourceRoots.toArray(new String[0]));
    }

    private synchronized void updateCachedRoots() {
        String[] roots = this.sourcePath.getSourceRoots();
        this.sourceRootsSet.clear();
        for (int x = 0; x < roots.length; ++x) {
            this.sourceRootsSet.add(roots[x]);
        }
        this.additionalSourceRoots = new LinkedHashSet<String>(Arrays.asList(this.sourcePath.getAdditionalSourceRoots()));
    }

    private static File getCurrentSourceRoot() {
        FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (fo == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        if ((fo = cp.findOwnerRoot(fo)) == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)fo);
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean visible) {
            this.properties.setBoolean(this.getID() + ".visible", visible);
        }

        public void setSorted(boolean sorted) {
            this.properties.setBoolean(this.getID() + ".sorted", sorted);
        }

        public void setSortedDescending(boolean sortedDescending) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", sortedDescending);
        }

        public int getCurrentOrderNumber() {
            int cn = this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
            if (cn >= 0 && !this.properties.getBoolean("outlineOrdering", false)) {
                ++cn;
            }
            return cn;
        }

        public void setCurrentOrderNumber(int newOrderNumber) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", newOrderNumber);
            this.properties.setBoolean("outlineOrdering", true);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int newColumnWidth) {
            this.properties.setInt(this.getID() + ".columnWidth", newColumnWidth);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference<SourcesModel> model;

        private Listener(SourcesModel tm) {
            this.model = new WeakReference<SourcesModel>(tm);
            tm.sourcePath.addPropertyChangeListener(this);
            tm.debugger.getSmartSteppingFilter().addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel tm = (SourcesModel)this.model.get();
            if (tm == null) {
                tm.sourcePath.removePropertyChangeListener(this);
                tm.debugger.getSmartSteppingFilter().removePropertyChangeListener((PropertyChangeListener)this);
            }
            return tm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourcesModel m = this.getModel();
            if (m == null) {
                return;
            }
            m.updateCachedRoots();
            m.fireTreeChanged();
        }
    }
}

