/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.CallStackNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeExpansionModelFilter;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;

public class DebuggingNodeModel
implements ExtendedNodeModel {
    public static final String CURRENT_THREAD = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING_THREAD = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED_THREAD = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    public static final String THREAD_AT_BRKT_LINE = "org/netbeans/modules/debugger/resources/threadsView/thread_at_line_bpkt_16.png";
    public static final String THREAD_AT_BRKT_NONLINE = "org/netbeans/modules/debugger/resources/threadsView/thread_at_non_line_bpkt_16.png";
    public static final String THREAD_AT_BRKT_CONDITIONAL = "org/netbeans/modules/debugger/resources/threadsView/thread_at_conditional_bpkt_16.png";
    public static final String THREAD_SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/thread_suspended_16.png";
    public static final String THREAD_RUNNING = "org/netbeans/modules/debugger/resources/threadsView/thread_running_16.png";
    public static final String CALL_STACK2 = "org/netbeans/modules/debugger/resources/threadsView/call_stack_16.png";
    public static final String THREAD_GROUP_MIXED = "org/netbeans/modules/debugger/jpda/resources/thread_group_mixed_16.png";
    public static final String THREAD_GROUP_SUSPENDED = "org/netbeans/modules/debugger/jpda/resources/thread_group_suspended_16.png";
    public static final String THREAD_GROUP_RESUMED = "org/netbeans/modules/debugger/jpda/resources/thread_group_running_16.png";
    public static final String SHOW_PACKAGE_NAMES = "show.packageNames";
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final Map<JPDAThread, ThreadStateUpdater> threadStateUpdaters = new WeakHashMap<JPDAThread, ThreadStateUpdater>();
    private final CurrentThreadListener currentThreadListener;
    private final DeadlockDetector deadlockDetector;
    private final Set nodesInDeadlock = new HashSet();
    private static final Map<JPDADebugger, Set> nodesInDeadlockByDebugger = new WeakHashMap<JPDADebugger, Set>();
    private final Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private final PreferenceChangeListener prefListener;
    private final RequestProcessor rp;
    private final Session session;
    private final PropertyChangeListener sessionLanguageListener;
    private static final Map<JPDAThread, String> frameDescriptionsByThread = new WeakHashMap<JPDAThread, String>();
    private final Map<CallStackFrame, String> frameDescriptionsByFrame = new WeakHashMap<CallStackFrame, String>();
    private static final Map<CallStackFrame, String[]> framePathAndClass = new WeakHashMap<CallStackFrame, String[]>();

    public DebuggingNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.currentThreadListener = new CurrentThreadListener();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.currentThreadListener, (Object)this.debugger));
        this.deadlockDetector = this.debugger.getThreadsCollector().getDeadlockDetector();
        this.deadlockDetector.addPropertyChangeListener((PropertyChangeListener)new DeadlockListener());
        this.rp = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.sessionLanguageListener = new SessionLanguageListener();
        this.session.addPropertyChangeListener("currentLanguage", WeakListeners.propertyChange((PropertyChangeListener)this.sessionLanguageListener, (Object)new ListenerDetaching("currentLanguage", this.session)));
        this.prefListener = new DebuggingPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getNodesInDeadlock(JPDADebugger debugger) {
        Map<JPDADebugger, Set> map = nodesInDeadlockByDebugger;
        synchronized (map) {
            return nodesInDeadlockByDebugger.get(debugger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(Object node) throws UnknownTypeException {
        if ("Root".equals(node)) {
            return "";
        }
        boolean showPackageNames = this.preferences.getBoolean(SHOW_PACKAGE_NAMES, false);
        Color c = null;
        Set set = this.nodesInDeadlock;
        synchronized (set) {
            if (this.nodesInDeadlock.contains(node)) {
                c = Color.RED;
            }
        }
        if (node instanceof JPDAThread) {
            JPDAThread t = (JPDAThread)node;
            this.watch(t);
            JPDAThread currentThread = this.debugger.getCurrentThread();
            if (!(t != currentThread || DebuggingTreeExpansionModelFilter.isExpanded(this.debugger, node) && t.isSuspended())) {
                return BoldVariablesTableModelFilter.toHTML(DebuggingNodeModel.getDisplayName(t, showPackageNames, this), true, false, c);
            }
            if (c != null) {
                return BoldVariablesTableModelFilter.toHTML(DebuggingNodeModel.getDisplayName(t, showPackageNames, this), false, false, c);
            }
            return DebuggingNodeModel.getDisplayName(t, showPackageNames, this);
        }
        if (node instanceof JPDAThreadGroup) {
            if (this.isCurrent((JPDAThreadGroup)node) && !DebuggingTreeExpansionModelFilter.isExpanded(this.debugger, node)) {
                return BoldVariablesTableModelFilter.toHTML(((JPDAThreadGroup)node).getName(), true, false, null);
            }
            return ((JPDAThreadGroup)node).getName();
        }
        if (node instanceof CallStackFrame) {
            String frameDescr;
            boolean isCurrent;
            CallStackFrame f = (CallStackFrame)node;
            try {
                isCurrent = (Boolean)f.getClass().getMethod("isCurrent", new Class[0]).invoke((Object)f, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                isCurrent = false;
            }
            Map<CallStackFrame, String> map = this.frameDescriptionsByFrame;
            synchronized (map) {
                frameDescr = this.frameDescriptionsByFrame.get(f);
                if (frameDescr == null) {
                    this.loadFrameDescription(f, showPackageNames);
                    return BoldVariablesTableModelFilter.toHTML(NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Frame_Loading"), false, false, Color.LIGHT_GRAY);
                }
            }
            if (isCurrent) {
                return BoldVariablesTableModelFilter.toHTML(frameDescr, true, false, c);
            }
            if (c != null) {
                return BoldVariablesTableModelFilter.toHTML(frameDescr, false, false, c);
            }
            return frameDescr;
        }
        throw new UnknownTypeException((Object)node.toString());
    }

    public static String getDisplayName(JPDAThread t, boolean showPackageNames) throws UnknownTypeException {
        return DebuggingNodeModel.getDisplayName(t, showPackageNames, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDisplayName(JPDAThread t, boolean showPackageNames, DebuggingNodeModel model) throws UnknownTypeException {
        String name = t.getName();
        JPDABreakpoint breakpoint = t.getCurrentBreakpoint();
        if (DebuggingTreeModel.isMethodInvoking(t)) {
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_Invoking_Method", (Object)name);
        }
        if (breakpoint != null) {
            return DebuggingNodeModel.getThreadAtBreakpointDisplayName(name, breakpoint);
        }
        if (t.isSuspended()) {
            String frame;
            Map<JPDAThread, String> map = frameDescriptionsByThread;
            synchronized (map) {
                frame = frameDescriptionsByThread.get(t);
                if (t.isSuspended()) {
                    DebuggingNodeModel.loadFrameDescription(frame, t, showPackageNames, model);
                }
            }
            if (frame != null) {
                return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Suspended_At", (Object)name, (Object)frame);
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Suspended", (Object)name);
        }
        return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_State_Running", (Object)name);
    }

    private static String getThreadAtBreakpointDisplayName(String threadName, JPDABreakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            String fileName = null;
            try {
                FileObject fo = URLMapper.findFileObject((URL)new URL(lb.getURL()));
                if (fo != null) {
                    fileName = fo.getNameExt();
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (fileName == null) {
                fileName = lb.getURL();
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_LineBreakpoint", (Object)threadName, (Object)fileName, (Object)lb.getLineNumber());
        }
        if (breakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint mb = (MethodBreakpoint)breakpoint;
            String classFilters = Arrays.asList(mb.getClassFilters()).toString();
            if (mb.getMethodSignature() == null) {
                return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_MethodBreakpoint", (Object)threadName, (Object)classFilters, (Object)mb.getMethodName());
            }
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_MethodBreakpointSig", (Object[])new Object[]{threadName, classFilters, mb.getMethodName(), mb.getMethodSignature()});
        }
        if (breakpoint instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint eb = (ExceptionBreakpoint)breakpoint;
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ExceptionBreakpoint", (Object)threadName, (Object)eb.getExceptionClassName());
        }
        if (breakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fb = (FieldBreakpoint)breakpoint;
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_FieldBreakpoint", (Object)threadName, (Object)fb.getClassName(), (Object)fb.getFieldName());
        }
        if (breakpoint instanceof ThreadBreakpoint) {
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ThreadBreakpoint", (Object)threadName);
        }
        if (breakpoint instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)breakpoint;
            String classFilters = Arrays.asList(cb.getClassFilters()).toString();
            return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_ClassBreakpoint", (Object)threadName, (Object)classFilters);
        }
        return NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_Thread_At_Breakpoint", (Object)threadName, (Object)breakpoint.toString());
    }

    private static void loadFrameDescription(final String oldFrame, final JPDAThread t, final boolean showPackageNames, final DebuggingNodeModel model) {
        Session s;
        try {
            JPDADebugger debugger = (JPDADebugger)t.getClass().getMethod("getDebugger", new Class[0]).invoke((Object)t, new Object[0]);
            s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        RequestProcessor rp = model != null && model.rp != null ? model.rp : (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            return;
        }
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String frame;
                block11: {
                    frame = null;
                    t.getReadAccessLock().lock();
                    try {
                        if (!t.isSuspended() || t.getStackDepth() <= 0) break block11;
                        try {
                            CallStackFrame[] sf = t.getCallStack(0, 1);
                            if (sf.length > 0) {
                                frame = CallStackNodeModel.getCSFName(s, sf[0], showPackageNames);
                            }
                        }
                        catch (AbsentInformationException absentInformationException) {
                            // empty catch block
                        }
                    }
                    finally {
                        t.getReadAccessLock().unlock();
                    }
                }
                if (oldFrame == null && frame != null || oldFrame != null && !oldFrame.equals(frame)) {
                    Map map = frameDescriptionsByThread;
                    synchronized (map) {
                        frameDescriptionsByThread.put(t, frame);
                    }
                    if (model != null) {
                        model.fireDisplayNameChanged(t);
                    }
                }
            }
        });
    }

    private void loadFrameDescription(final CallStackFrame f, final boolean showPackageNames) {
        this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String frameDescr = CallStackNodeModel.getCSFName(DebuggingNodeModel.this.session, f, showPackageNames);
                Map map = DebuggingNodeModel.this.frameDescriptionsByFrame;
                synchronized (map) {
                    DebuggingNodeModel.this.frameDescriptionsByFrame.put(f, frameDescr);
                }
                String[] pathAndClass = new String[2];
                try {
                    pathAndClass[0] = f.getSourcePath(DebuggingNodeModel.this.session.getCurrentLanguage());
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                pathAndClass[1] = f.getClassName();
                Map map2 = framePathAndClass;
                synchronized (map2) {
                    framePathAndClass.put(f, pathAndClass);
                }
                DebuggingNodeModel.this.fireDisplayNameChanged(f);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCachedFramePath(CallStackFrame f) {
        Map<CallStackFrame, String[]> map = framePathAndClass;
        synchronized (map) {
            String[] pathAndClass = framePathAndClass.get(f);
            if (pathAndClass != null) {
                return pathAndClass[0];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCachedFrameClass(CallStackFrame f) {
        Map<CallStackFrame, String[]> map = framePathAndClass;
        synchronized (map) {
            String[] pathAndClass = framePathAndClass.get(f);
            if (pathAndClass != null) {
                return pathAndClass[1];
            }
        }
        return null;
    }

    public static String getIconBase(JPDAThread thread) {
        JPDABreakpoint b = thread.getCurrentBreakpoint();
        if (b != null) {
            if (b instanceof LineBreakpoint) {
                String condition = ((LineBreakpoint)b).getCondition();
                if (condition != null && condition.length() > 0) {
                    return THREAD_AT_BRKT_CONDITIONAL;
                }
                return THREAD_AT_BRKT_LINE;
            }
            return THREAD_AT_BRKT_NONLINE;
        }
        if (thread.isSuspended()) {
            return THREAD_SUSPENDED;
        }
        return THREAD_RUNNING;
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof CallStackFrame) {
            CallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ccsf.equals(node)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (node instanceof JPDAThread) {
            if (node == this.debugger.getCurrentThread()) {
                return CURRENT_THREAD;
            }
            return ((JPDAThread)node).isSuspended() ? SUSPENDED_THREAD : RUNNING_THREAD;
        }
        if (node == "Root") {
            return CALL_STACK;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof JPDAThread) {
            return DebuggingNodeModel.getIconBase((JPDAThread)node);
        }
        if (node instanceof CallStackFrame) {
            return CALL_STACK2;
        }
        if (node instanceof JPDAThreadGroup) {
            boolean[] flags = new boolean[]{false, false};
            this.computeGroupStatus((JPDAThreadGroup)node, flags);
            if (flags[0]) {
                if (flags[1]) {
                    return THREAD_GROUP_MIXED;
                }
                return THREAD_GROUP_SUSPENDED;
            }
            return THREAD_GROUP_RESUMED;
        }
        return this.getIconBase(node) + ".gif";
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof JPDAThread) {
            JPDAThread t = (JPDAThread)node;
            int i = t.getState();
            String s = "";
            switch (i) {
                case -1: {
                    s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Unknown");
                    break;
                }
                case 3: {
                    s = "";
                    ObjectVariable ov = t.getContendedMonitor();
                    if (ov == null) {
                        s = NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_Monitor");
                        break;
                    }
                    try {
                        s = MessageFormat.format(NbBundle.getBundle(ThreadsNodeModel.class).getString("CTL_ThreadsModel_State_ConcreteMonitor"), ov.getToStringValue());
                    }
                    catch (InvalidExpressionException ex) {
                        s = ex.getLocalizedMessage();
                    }
                    break;
                }
                case 5: {
                    s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_NotStarted");
                    break;
                }
                case 1: {
                    s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Running");
                    break;
                }
                case 2: {
                    s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Sleeping");
                    break;
                }
                case 4: {
                    ObjectVariable ov = t.getContendedMonitor();
                    if (ov == null) {
                        s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Waiting");
                        break;
                    }
                    try {
                        s = MessageFormat.format(NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_WaitingOn"), ov.getToStringValue());
                    }
                    catch (InvalidExpressionException ex) {
                        s = ex.getLocalizedMessage();
                    }
                    break;
                }
                case 0: {
                    s = NbBundle.getBundle(DebuggingNodeModel.class).getString("CTL_ThreadsModel_State_Zombie");
                }
            }
            String msg = t.isSuspended() ? NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Suspended_Thread_Desc") : NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Resumed_Thread_Desc");
            if (s != null && s.length() > 0) {
                msg = "<html>" + msg + "<br>" + NbBundle.getMessage(DebuggingNodeModel.class, (String)"CTL_ThreadsModel_Thread_State_Desc", (Object)s) + "</html>";
            }
            return msg;
        }
        if (node instanceof CallStackFrame) {
            CallStackFrame sf = (CallStackFrame)node;
            if (DebuggingTreeModel.isMethodInvoking(sf.getThread())) {
                return "";
            }
            return CallStackNodeModel.getCSFToolTipText(this.session, sf);
        }
        if (node instanceof JPDAThreadGroup) {
            return ((JPDAThreadGroup)node).getName();
        }
        if (node == "Root") {
            return "";
        }
        throw new UnknownTypeException((Object)node.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        ModelEvent.NodeChanged event = node instanceof JPDAThread ? new ModelEvent.NodeChanged((Object)this, node, 7) : new ModelEvent.NodeChanged((Object)this, node, 31);
        for (ModelListener ml : ls) {
            ml.modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDisplayNameChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 1);
        for (ModelListener ml : ls) {
            ml.modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener ml : ls) {
            ml.modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(JPDAThread t) {
        Map<JPDAThread, ThreadStateUpdater> map = this.threadStateUpdaters;
        synchronized (map) {
            if (!this.threadStateUpdaters.containsKey(t)) {
                this.threadStateUpdaters.put(t, new ThreadStateUpdater(t));
            }
        }
    }

    private boolean isCurrent(JPDAThreadGroup tg) {
        JPDAThread t = this.debugger.getCurrentThread();
        if (t == null) {
            return false;
        }
        for (JPDAThreadGroup ctg = t.getParentThreadGroup(); ctg != null; ctg = ctg.getParentThreadGroup()) {
            if (ctg != tg) continue;
            return true;
        }
        return false;
    }

    private void computeGroupStatus(JPDAThreadGroup tg, boolean[] flags) {
        JPDAThread[] threads = tg.getThreads();
        for (int x = 0; x < threads.length; ++x) {
            if (threads[x].isSuspended()) {
                flags[0] = true;
            } else {
                flags[1] = true;
            }
            if (!flags[0] || !flags[1]) continue;
            return;
        }
        JPDAThreadGroup[] groups = tg.getThreadGroups();
        for (int x = 0; x < groups.length; ++x) {
            this.computeGroupStatus(groups[x], flags);
            if (!flags[0] || !flags[1]) continue;
            return;
        }
    }

    private class CurrentThreadListener
    implements PropertyChangeListener {
        private Reference<JPDAThread> lastCurrentThreadRef = new WeakReference<Object>(null);
        private Reference<JPDAThread> lastCurrentFrameThreadRef = new WeakReference<Object>(null);
        private int lastCurrentFrameDepth;

        private CurrentThreadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("currentThread".equals(evt.getPropertyName())) {
                JPDAThread lastCurrentThread;
                JPDAThread currentThread = DebuggingNodeModel.this.debugger.getCurrentThread();
                CurrentThreadListener currentThreadListener = this;
                synchronized (currentThreadListener) {
                    lastCurrentThread = this.lastCurrentThreadRef.get();
                    this.lastCurrentThreadRef = new WeakReference<JPDAThread>(currentThread);
                }
                if (lastCurrentThread != null) {
                    DebuggingNodeModel.this.fireNodeChanged(lastCurrentThread);
                }
                if (currentThread != null) {
                    DebuggingNodeModel.this.fireNodeChanged(currentThread);
                }
                if (DebuggingNodeModel.this.preferences.getBoolean("show.suspendedThreadsOnly", false)) {
                    DebuggingNodeModel.this.fireNodeChanged("Root");
                }
            }
            if ("currentCallStackFrame".equals(evt.getPropertyName())) {
                JPDAThread lastCurrentFrameThread;
                CallStackFrame currentFrame = DebuggingNodeModel.this.debugger.getCurrentCallStackFrame();
                CallStackFrame lastcurrentFrame = null;
                CurrentThreadListener currentThreadListener = this;
                synchronized (currentThreadListener) {
                    lastCurrentFrameThread = this.lastCurrentFrameThreadRef.get();
                }
                if (lastCurrentFrameThread != null) {
                    try {
                        CallStackFrame[] frames = lastCurrentFrameThread.getCallStack(this.lastCurrentFrameDepth, this.lastCurrentFrameDepth + 1);
                        if (frames.length > 0) {
                            lastcurrentFrame = frames[0];
                        }
                    }
                    catch (AbsentInformationException aiex) {
                        // empty catch block
                    }
                }
                currentThreadListener = this;
                synchronized (currentThreadListener) {
                    if (currentFrame != null) {
                        this.lastCurrentFrameThreadRef = new WeakReference<JPDAThread>(currentFrame.getThread());
                        this.lastCurrentFrameDepth = currentFrame.getFrameDepth();
                    } else {
                        this.lastCurrentFrameThreadRef = new WeakReference<Object>(null);
                        this.lastCurrentFrameDepth = 0;
                    }
                }
                if (lastcurrentFrame != null) {
                    DebuggingNodeModel.this.fireNodeChanged(lastcurrentFrame);
                }
                if (currentFrame != null) {
                    DebuggingNodeModel.this.fireNodeChanged(currentFrame);
                }
            }
        }
    }

    private class DeadlockListener
    implements PropertyChangeListener {
        private DeadlockListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Set deadlocks = DebuggingNodeModel.this.deadlockDetector.getDeadlocks();
            HashSet<Object> deadlockedElements = new HashSet<Object>();
            for (DeadlockDetector.Deadlock deadlock : deadlocks) {
                for (JPDAThread t : deadlock.getThreads()) {
                    deadlockedElements.add(t);
                    deadlockedElements.add(t.getContendedMonitor());
                }
            }
            if (deadlockedElements.isEmpty()) {
                return;
            }
            Iterator i$ = DebuggingNodeModel.this.nodesInDeadlock;
            synchronized (i$) {
                DebuggingNodeModel.this.nodesInDeadlock.addAll(deadlockedElements);
            }
            i$ = nodesInDeadlockByDebugger;
            synchronized (i$) {
                nodesInDeadlockByDebugger.put(DebuggingNodeModel.this.debugger, DebuggingNodeModel.this.nodesInDeadlock);
            }
            for (Object e : deadlockedElements) {
                DebuggingNodeModel.this.fireDisplayNameChanged(e);
                DebuggingTreeExpansionModelFilter.expand(DebuggingNodeModel.this.debugger, e);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if (DebuggingNodeModel.SHOW_PACKAGE_NAMES.equals(key)) {
                Map map = DebuggingNodeModel.this.frameDescriptionsByFrame;
                synchronized (map) {
                    DebuggingNodeModel.this.frameDescriptionsByFrame.clear();
                }
            }
        }
    }

    private static final class ListenerDetaching {
        private String propertyName;
        private Session session;

        ListenerDetaching(String propertyName, Session session) {
            this.propertyName = propertyName;
            this.session = session;
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.session.removePropertyChangeListener(this.propertyName, l);
        }
    }

    private final class SessionLanguageListener
    implements PropertyChangeListener {
        private SessionLanguageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Map map = DebuggingNodeModel.this.frameDescriptionsByFrame;
            synchronized (map) {
                DebuggingNodeModel.this.frameDescriptionsByFrame.clear();
            }
            map = framePathAndClass;
            synchronized (map) {
                framePathAndClass.clear();
            }
            DebuggingNodeModel.this.fireTreeChanged();
        }
    }

    private class ThreadStateUpdater
    implements PropertyChangeListener {
        private Reference<JPDAThread> tr;
        private RequestProcessor.Task task;
        private boolean shouldExpand = false;

        public ThreadStateUpdater(JPDAThread t) {
            this.tr = new WeakReference<JPDAThread>(t);
            ((Customizer)t).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)t));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThread t = this.tr.get();
            if (t != null) {
                ThreadStateUpdater threadStateUpdater;
                if ("currentBreakpoint".equals(evt.getPropertyName()) && t.isSuspended() && t.getCurrentBreakpoint() != null) {
                    threadStateUpdater = this;
                    synchronized (threadStateUpdater) {
                        this.shouldExpand = true;
                    }
                }
                threadStateUpdater = this;
                synchronized (threadStateUpdater) {
                    if (this.task == null) {
                        this.task = DebuggingNodeModel.this.rp.create((Runnable)new Refresher());
                    }
                    this.task.schedule(100);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JPDAThread thread = (JPDAThread)ThreadStateUpdater.this.tr.get();
                if (thread != null) {
                    boolean shouldExpand;
                    if (DebuggingNodeModel.this.preferences.getBoolean("show.suspendedThreadsOnly", false)) {
                        DebuggingNodeModel.this.fireNodeChanged("Root");
                    } else {
                        DebuggingNodeModel.this.fireNodeChanged(thread);
                    }
                    Refresher refresher = this;
                    synchronized (refresher) {
                        shouldExpand = ThreadStateUpdater.this.shouldExpand;
                        ThreadStateUpdater.this.shouldExpand = false;
                    }
                    if (shouldExpand) {
                        DebuggingTreeExpansionModelFilter.expand(DebuggingNodeModel.this.debugger, thread);
                    }
                    if (DebuggingNodeModel.this.preferences.getBoolean("show.threadGroups", false)) {
                        for (JPDAThreadGroup group = thread.getParentThreadGroup(); group != null; group = group.getParentThreadGroup()) {
                            DebuggingNodeModel.this.fireNodeChanged(group);
                        }
                    }
                }
            }
        }
    }
}

