/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.modules.debugger.jpda.ui.debugging.KeyboardPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ThreadsHistoryAction
extends AbstractAction {
    public ThreadsHistoryAction() {
        this.putValue("Name", NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_ThreadsHistoryAction"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        KeyStroke keyStroke;
        List<JPDAThread> threads = ThreadsHistoryAction.getThreads();
        int threadsCount = threads.size();
        if (threadsCount < 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!"immediately".equals(evt.getActionCommand()) && !(evt.getSource() instanceof JMenuItem) && (keyStroke = Utilities.stringToKey((String)evt.getActionCommand())) != null) {
            int triggerKey = keyStroke.getKeyCode();
            int releaseKey = 0;
            int modifiers = keyStroke.getModifiers();
            if ((2 & modifiers) != 0) {
                releaseKey = 17;
            } else if ((8 & modifiers) != 0) {
                releaseKey = 18;
            } else if ((4 & modifiers) != 0) {
                releaseKey = 4;
            }
            if (releaseKey != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    KeyboardPopupSwitcher.selectItem(ThreadsHistoryAction.createSwitcherItems(threads), releaseKey, triggerKey, true, true);
                }
                return;
            }
        }
        if (threadsCount == 1) {
            threads.get(0).makeCurrent();
        } else {
            int index = (evt.getModifiers() & 1) == 0 ? 1 : threadsCount - 1;
            threads.get(index).makeCurrent();
        }
    }

    public static SwitcherTableItem[] createSwitcherItems(List<JPDAThread> threads) {
        Set deadlocks;
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        JPDADebugger debugger = threadsListener.getDebugger();
        JPDAThread currentThread = debugger != null ? debugger.getCurrentThread() : null;
        Set set = deadlocks = debugger != null ? debugger.getThreadsCollector().getDeadlockDetector().getDeadlocks() : Collections.EMPTY_SET;
        if (deadlocks == null) {
            deadlocks = Collections.EMPTY_SET;
        }
        HashSet deadlockedThreads = new HashSet();
        for (DeadlockDetector.Deadlock deadlock : deadlocks) {
            deadlockedThreads.addAll(deadlock.getThreads());
        }
        SwitcherTableItem[] items = new SwitcherTableItem[threads.size()];
        int i = 0;
        for (JPDAThread thread : threads) {
            String name;
            try {
                name = DebuggingNodeModel.getDisplayName(thread, false);
                Method method = thread.getClass().getMethod("getDebugger", new Class[0]);
                JPDADebugger deb = (JPDADebugger)method.invoke((Object)thread, new Object[0]);
                method = deb.getClass().getMethod("getSession", new Class[0]);
                Session session = (Session)method.invoke((Object)deb, new Object[0]);
                Session currSession = DebuggerManager.getDebuggerManager().getCurrentSession();
                if (session != currSession) {
                    String str = NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_Session", (Object)session.getName());
                    name = name.charAt(0) + str + ", " + name.substring(1);
                }
            }
            catch (Exception e) {
                name = thread.getName();
            }
            String htmlName = name;
            String description = "";
            Image image = ImageUtilities.loadImage((String)DebuggingNodeModel.getIconBase(thread));
            ThreadStatusIcon icon = null;
            if (image != null) {
                boolean isCurrent = thread == currentThread;
                boolean isAtBreakpoint = threadsListener.isBreakpointHit(thread);
                boolean isInDeadlock = deadlockedThreads.contains(thread);
                icon = new ThreadStatusIcon(image, isCurrent, isAtBreakpoint, isInDeadlock);
            }
            items[i] = new SwitcherTableItem(new ActivatableElement(thread), name, htmlName, icon, false, description != null ? description : name);
            ++i;
        }
        return items;
    }

    public static List<JPDAThread> getThreads() {
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        if (threadsListener == null) {
            return Collections.emptyList();
        }
        List<JPDAThread> history = threadsListener.getCurrentThreadsHistory();
        List<JPDAThread> allThreads = threadsListener.getThreads();
        HashSet<JPDAThread> hitsSet = new HashSet<JPDAThread>();
        for (JPDAThread hit : threadsListener.getHits()) {
            hitsSet.add(hit);
        }
        HashSet<JPDAThread> set = new HashSet<JPDAThread>(history);
        LinkedList<JPDAThread> result = new LinkedList<JPDAThread>();
        result.addAll(history);
        for (JPDAThread thread : allThreads) {
            if (set.contains(thread) || !thread.isSuspended()) continue;
            result.add(thread);
        }
        if (result.size() > 1 && hitsSet.size() > 0) {
            int index = 1;
            int size = result.size();
            for (int x = 1; x < size; ++x) {
                JPDAThread t = (JPDAThread)result.get(x);
                if (!hitsSet.contains(t)) continue;
                if (x > index) {
                    result.remove(x);
                    result.add(index, t);
                }
                ++index;
            }
        }
        return result;
    }

    private static class ActivatableElement
    implements SwitcherTableItem.Activatable {
        JPDAThread thread;

        private ActivatableElement(JPDAThread thread) {
            this.thread = thread;
        }

        @Override
        public void activate() {
            this.thread.makeCurrent();
        }
    }

    private static class ThreadStatusIcon
    implements Icon {
        private Image image;
        private ImageIcon iconBase;
        private boolean isCurrent;
        private boolean isAtBreakpoint;
        private boolean isInDeadlock;

        ThreadStatusIcon(Image image, boolean isCurrent, boolean isAtBreakpoint, boolean isInDeadlock) {
            this.image = image;
            this.isCurrent = isCurrent;
            this.isAtBreakpoint = isAtBreakpoint;
            this.isInDeadlock = isInDeadlock;
            this.iconBase = new ImageIcon(image);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.iconBase.getIconWidth();
            int height = this.iconBase.getIconHeight();
            Color primaryColor = null;
            Color secondaryColor = null;
            if (this.isInDeadlock) {
                primaryColor = DebuggingView.deadlockColor;
            } else if (this.isCurrent) {
                primaryColor = DebuggingView.greenBarColor;
            } else if (this.isAtBreakpoint) {
                primaryColor = DebuggingView.hitsBarColor;
            }
            if (this.isCurrent && this.isInDeadlock) {
                secondaryColor = DebuggingView.greenBarColor;
            }
            Color originalColor = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(x, y, width, height);
            g.drawImage(this.image, x + width, y, this.iconBase.getImageObserver());
            if (primaryColor != null) {
                g.setColor(primaryColor);
                g.fillRect(x, y, 8, height);
            }
            if (secondaryColor != null) {
                g.setColor(secondaryColor);
                int w = 5;
                g.fillRect(x + 8 - w, y, w, height);
            }
            g.setColor(originalColor);
        }

        @Override
        public int getIconWidth() {
            return 2 * this.iconBase.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.iconBase.getIconHeight();
        }
    }
}

