/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.SequentialPropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class PropertyUtils {
    private static Map<File, Reference<PropertyProvider>> globalPropertyProviders = new HashMap<File, Reference<PropertyProvider>>();
    private static EditableProperties currentGlobalProperties;
    private static File currentGlobalPropertiesFile;
    private static long currentGlobalPropertiesLastModified;
    private static long currentGlobalPropertiesLength;
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH;
    private static final Pattern VALID_PROPERTY_NAME;

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        File nbuser = Places.getUserDirectory();
        if (nbuser != null) {
            return FileUtil.normalizeFile((File)new File(nbuser, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EditableProperties run() {
                File ubp = PropertyUtils.userBuildProperties();
                if (ubp != null && ubp.isFile() && ubp.canRead()) {
                    EditableProperties editableProperties;
                    long lastModified = ubp.lastModified();
                    long length = ubp.length();
                    if (ubp.equals(currentGlobalPropertiesFile) && lastModified == currentGlobalPropertiesLastModified && length == currentGlobalPropertiesLength) {
                        return currentGlobalProperties.cloneProperties();
                    }
                    FileInputStream is = new FileInputStream(ubp);
                    try {
                        EditableProperties properties = new EditableProperties(true);
                        properties.load(is);
                        currentGlobalProperties = properties.cloneProperties();
                        currentGlobalPropertiesFile = ubp;
                        currentGlobalPropertiesLastModified = lastModified;
                        currentGlobalPropertiesLength = length;
                        editableProperties = properties;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, e);
                        }
                    }
                    ((InputStream)is).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties properties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    long length;
                    long lastModified;
                    File ubp = PropertyUtils.userBuildProperties();
                    if (ubp != null) {
                        lastModified = ubp.lastModified();
                        length = ubp.length();
                        if (ubp.equals(currentGlobalPropertiesFile) && lastModified == currentGlobalPropertiesLastModified && length == currentGlobalPropertiesLength && properties.equals(currentGlobalProperties)) {
                            return null;
                        }
                        FileObject bp = FileUtil.toFileObject((File)ubp);
                        if (bp == null) {
                            if (!ubp.exists()) {
                                ubp.getParentFile().mkdirs();
                                new FileOutputStream(ubp).close();
                                assert (ubp.isFile()) : "Did not actually make " + ubp;
                            }
                            if ((bp = FileUtil.toFileObject((File)ubp)) == null) {
                                ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + ubp + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                FileOutputStream os = new FileOutputStream(ubp);
                                try {
                                    properties.store(os);
                                }
                                finally {
                                    ((OutputStream)os).close();
                                }
                                return null;
                            }
                        }
                        OutputStream os = bp.getOutputStream();
                        try {
                            properties.store(os);
                        }
                        finally {
                            os.close();
                        }
                    }
                    throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    currentGlobalProperties = properties.cloneProperties();
                    currentGlobalPropertiesFile = ubp;
                    currentGlobalPropertiesLastModified = lastModified;
                    currentGlobalPropertiesLength = length;
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File ubp = PropertyUtils.userBuildProperties();
        if (ubp != null) {
            PropertyProvider pp;
            Reference<PropertyProvider> globalPropertyProvider = globalPropertyProviders.get(ubp);
            if (globalPropertyProvider != null && (pp = globalPropertyProvider.get()) != null) {
                return pp;
            }
            PropertyProvider gpp = PropertyUtils.propertiesFilePropertyProvider(ubp);
            globalPropertyProviders.put(ubp, new SoftReference<PropertyProvider>(gpp));
            return gpp;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.<String, String>emptyMap());
    }

    public static PropertyProvider propertiesFilePropertyProvider(File propertiesFile) {
        assert (propertiesFile != null);
        return new FilePropertyProvider(propertiesFile);
    }

    public static File resolveFile(File basedir, String filename) throws IllegalArgumentException {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            assert (f.isAbsolute());
        }
        return FileUtil.normalizeFile((File)f);
    }

    @CheckForNull
    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuilder b = new StringBuilder();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(PropertyUtils.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = Utilities.toURI((File)base).relativize(Utilities.toURI((File)file));
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject basedir, String filename) {
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)basedir), filename));
    }

    static String resolvePath(File basedir, String path) {
        StringBuilder b = new StringBuilder();
        String[] toks = PropertyUtils.tokenizePath(path);
        for (int i = 0; i < toks.length; ++i) {
            if (i > 0) {
                b.append(File.pathSeparatorChar);
            }
            b.append(PropertyUtils.resolveFile(basedir, toks[i]).getAbsolutePath());
        }
        return b.toString();
    }

    public static String[] tokenizePath(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    l.add(Character.toString(dosHack));
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            l.add(s);
        }
        if (dosHack != '\u0000') {
            l.add(Character.toString(dosHack));
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean isUsablePropertyName(String name) {
        return VALID_PROPERTY_NAME.matcher(name).matches();
    }

    public static String getUsablePropertyName(String name) {
        if (PropertyUtils.isUsablePropertyName(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        for (int i = 0; i < sb.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(sb.substring(i, i + 1))) continue;
            sb.replace(i, i + 1, "_");
        }
        return sb.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map<String, String> defs) {
        return new FixedPropertyProvider(defs);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider preprovider, PropertyProvider ... providers) {
        return new SequentialPropertyEvaluator(preprovider, providers);
    }

    public static PropertyProvider userPropertiesProvider(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
        return new UserPropertiesProvider(findUserPropertiesFile, propertyName, basedir);
    }

    static {
        RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
        VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    }

    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private Map<String, String> cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File properties) {
            this.properties = properties;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)properties);
        }

        @Override
        public Map<String, String> getProperties() {
            long currTime = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != currTime) {
                this.cachedTime = currTime;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Map map;
                FileInputStream is = new FileInputStream(this.properties);
                try {
                    Properties props = new Properties();
                    props.load(is);
                    map = NbCollections.checkedMapByFilter((Map)props, String.class, String.class, (boolean)true);
                }
                catch (IllegalArgumentException iae) {
                    try {
                        try {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.WARNING, "Property file: " + this.properties.getPath(), iae);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, e);
                    }
                }
                ((InputStream)is).close();
                return map;
            }
            return Collections.emptyMap();
        }

        private void fireChange() {
            this.cachedTime = -1L;
            if (!this.cs.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    FilePropertyProvider.this.cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    @Override
                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        @Override
        public synchronized void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }

    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map<String, String> defs;

        public FixedPropertyProvider(Map<String, String> defs) {
            this.defs = defs;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.defs;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class UserPropertiesProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator findUserPropertiesFile;
        private final String propertyName;
        private final File basedir;

        public UserPropertiesProvider(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
            super(UserPropertiesProvider.computeDelegate(findUserPropertiesFile, propertyName, basedir));
            this.findUserPropertiesFile = findUserPropertiesFile;
            this.propertyName = propertyName;
            this.basedir = basedir;
            findUserPropertiesFile.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (this.propertyName.equals(ev.getPropertyName())) {
                this.setDelegate(UserPropertiesProvider.computeDelegate(this.findUserPropertiesFile, this.propertyName, this.basedir));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator findUserPropertiesFile, String propertyName, File basedir) {
            String userPropertiesFile = findUserPropertiesFile.getProperty(propertyName);
            if (userPropertiesFile != null) {
                File f = PropertyUtils.resolveFile(basedir, userPropertiesFile);
                if (f.equals(PropertyUtils.userBuildProperties())) {
                    return PropertyUtils.globalPropertyProvider();
                }
                return PropertyUtils.propertiesFilePropertyProvider(f);
            }
            return PropertyUtils.globalPropertyProvider();
        }
    }
}

