/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ant.Bundle;
import org.netbeans.modules.project.ant.VariablesModel;
import org.netbeans.modules.project.ant.VariablesPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FileChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private File baseFolder;
    private final File sharedLibrariesFolder;
    private boolean copyAllowed;
    private JFileChooser chooser;
    private List<String> copiedRelativeFiles = null;
    private VariablesModel varModel;
    private boolean enableVariableBasedSelection = false;
    private boolean userSelection = false;
    private JTextField absolutePath;
    private ButtonGroup buttonGroup1;
    private JTextField copyTo;
    private JLabel lblReference;
    private JRadioButton rbAbsolute;
    private JRadioButton rbCopy;
    private JRadioButton rbRelative;
    private JRadioButton rbVariable;
    private JTextField relativePath;
    private JTextField variablePath;
    private JButton variablesButton;

    public FileChooserAccessory(JFileChooser chooser, File baseFolder, File sharedLibrariesFolder, boolean copyAllowed) {
        assert (baseFolder != null);
        assert (!baseFolder.isFile());
        if (sharedLibrariesFolder != null) {
            assert (!sharedLibrariesFolder.isFile()) : true;
            if (!sharedLibrariesFolder.equals(FileUtil.normalizeFile((File)sharedLibrariesFolder))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + sharedLibrariesFolder + " instead of " + FileUtil.normalizeFile((File)sharedLibrariesFolder));
            }
        }
        this.baseFolder = baseFolder;
        this.sharedLibrariesFolder = sharedLibrariesFolder;
        this.copyAllowed = copyAllowed && sharedLibrariesFolder != null;
        this.chooser = chooser;
        this.initComponents();
        this.rbCopy.addActionListener(this);
        this.rbRelative.addActionListener(this);
        this.rbAbsolute.addActionListener(this);
        this.rbVariable.addActionListener(this);
        if (chooser != null) {
            chooser.addPropertyChangeListener(this);
        }
        if (sharedLibrariesFolder != null) {
            this.copyTo.setText(sharedLibrariesFolder.getAbsolutePath());
        }
        this.enableAccessory(false);
        if (!copyAllowed) {
            this.rbCopy.setVisible(false);
            this.copyTo.setVisible(false);
        }
        this.enableVariableBasedSelection(this.enableVariableBasedSelection);
    }

    public void enableVariableBasedSelection(boolean enable) {
        this.enableVariableBasedSelection = enable;
        this.rbVariable.setVisible(this.enableVariableBasedSelection);
        this.variablePath.setVisible(this.enableVariableBasedSelection);
        this.variablesButton.setVisible(this.enableVariableBasedSelection);
    }

    public String[] getFiles() {
        assert (this.isRelative());
        if (this.isCopy()) {
            return this.copiedRelativeFiles.toArray(new String[this.copiedRelativeFiles.size()]);
        }
        List<File> files = Arrays.asList(this.getSelectedFiles());
        List<String> l = this.getRelativeFiles(files);
        return l.toArray(new String[l.size()]);
    }

    public boolean canApprove() {
        if (!this.isCopy()) {
            return true;
        }
        File f = FileUtil.normalizeFile((File)new File(this.copyTo.getText()));
        if (!f.getPath().equals(this.sharedLibrariesFolder.getPath()) && !f.getPath().startsWith(this.sharedLibrariesFolder.getPath() + File.separatorChar)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.FileChooserAccessory_warning1(this.sharedLibrariesFolder.getPath())));
            return false;
        }
        File[] files = this.getSelectedFiles();
        if (f.exists()) {
            for (File file : files) {
                File testFile = new File(f, file.getName());
                if (!testFile.exists()) continue;
                if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.FileChooserAccessory_warning3()))) {
                    return false;
                }
                break;
            }
        } else if (NotifyDescriptor.YES_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.FileChooserAccessory_warning2(f.getPath())))) {
            return false;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            if (NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.FileChooserAccessory_warning4()))) break;
            return false;
        }
        return true;
    }

    public void copyFilesIfNecessary() throws IOException {
        if (!this.isCopy()) {
            return;
        }
        File f = FileUtil.normalizeFile((File)new File(this.copyTo.getText()));
        FileUtil.createFolder((File)f);
        FileObject fo = FileUtil.toFileObject((File)f);
        List<File> selectedFiles = Arrays.asList(this.getSelectedFiles());
        this.copyFiles(selectedFiles, fo);
    }

    private void enableAccessory(boolean enable) {
        this.rbRelative.setEnabled(enable);
        this.relativePath.setEnabled(enable);
        this.rbCopy.setEnabled(enable && this.copyAllowed);
        this.rbAbsolute.setEnabled(enable);
        this.absolutePath.setEnabled(enable);
        this.copyTo.setEnabled(enable);
        this.copyTo.setEditable(enable && this.rbCopy.isSelected());
        if (enable) {
            File f = this.getSelectedFiles()[0];
            boolean b = this.getVariablesModel().getRelativePath(f, true) != null;
            this.rbVariable.setEnabled(b);
            this.variablePath.setEnabled(b);
        } else {
            this.rbVariable.setEnabled(false);
            this.variablePath.setEnabled(false);
        }
        this.variablePath.setEditable(false);
        this.variablesButton.setEnabled(enable);
    }

    private File[] getSelectedFiles() {
        File[] files = this.chooser.isMultiSelectionEnabled() ? this.chooser.getSelectedFiles() : (this.chooser.getSelectedFile() != null ? new File[]{this.chooser.getSelectedFile()} : new File[]{});
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileUtil.normalizeFile((File)files[i]);
        }
        return files;
    }

    public boolean isRelative() {
        return this.rbRelative.isEnabled() && this.rbRelative.isSelected() || this.isCopy();
    }

    public boolean isVariableBased() {
        return this.rbVariable.isEnabled() && this.rbVariable.isSelected();
    }

    private boolean isCopy() {
        return this.rbCopy.isEnabled() && this.rbCopy.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.copyTo.setEditable(e.getSource() == this.rbCopy);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!"SelectedFileChangedProperty".equals(e.getPropertyName()) && !"SelectedFilesChangedProperty".equals(e.getPropertyName())) {
            return;
        }
        File[] files = this.getSelectedFiles();
        this.enableAccessory(files.length != 0);
        this.update(Arrays.asList(files));
    }

    private void update(List<File> files) {
        StringBuilder absolute = new StringBuilder();
        StringBuilder relative = new StringBuilder();
        StringBuilder variable = new StringBuilder();
        boolean isRelative = true;
        for (File file : files) {
            String varPath = this.getVariablesModel().getRelativePath(file, true);
            if (absolute.length() != 0) {
                absolute.append(", ");
                relative.append(", ");
                if (varPath != null) {
                    variable.append(", ");
                }
            }
            absolute.append(file.getAbsolutePath());
            String s = PropertyUtils.relativizeFile(this.baseFolder, file);
            if (s == null) {
                isRelative = false;
            }
            relative.append(s);
            if (varPath == null) continue;
            variable.append(varPath);
        }
        this.rbRelative.setEnabled(isRelative && this.rbRelative.isEnabled());
        this.relativePath.setText(relative.toString());
        this.relativePath.setCaretPosition(0);
        this.relativePath.setToolTipText(relative.toString());
        if (!isRelative) {
            this.relativePath.setText("");
            this.relativePath.setToolTipText("");
        }
        this.absolutePath.setText(absolute.toString());
        this.absolutePath.setCaretPosition(0);
        this.absolutePath.setToolTipText(absolute.toString());
        if (variable.length() == 0) {
            variable.append(Bundle.FileChooserAccessory_noSuitableVariable());
        }
        this.variablePath.setText(variable.toString());
        this.variablePath.setCaretPosition(0);
        this.variablePath.setToolTipText(variable.toString());
        ButtonModel selection = this.buttonGroup1.getSelection();
        if (selection == null || !selection.isEnabled() || !this.userSelection) {
            if (this.areCollocated(this.baseFolder, files)) {
                this.rbRelative.setSelected(true);
            } else if (this.areVarRelated(files)) {
                this.rbVariable.setSelected(true);
            } else if (this.copyAllowed) {
                this.rbCopy.setSelected(true);
            } else {
                this.rbAbsolute.setSelected(true);
            }
            if (selection != this.buttonGroup1.getSelection()) {
                this.userSelection = false;
            }
        }
    }

    private boolean areVarRelated(Collection<File> files) {
        VariablesModel model = this.getVariablesModel();
        for (File file : files) {
            if (model.getRelativePath(file, true) != null) continue;
            return false;
        }
        return true;
    }

    private boolean areCollocated(File base, Collection<File> files) {
        for (File file : files) {
            if (CollocationQuery.areCollocated((URI)Utilities.toURI((File)base), (URI)Utilities.toURI((File)file))) continue;
            return false;
        }
        return true;
    }

    private VariablesModel getVariablesModel() {
        if (this.varModel == null) {
            this.varModel = new VariablesModel();
        }
        return this.varModel;
    }

    private List<String> getRelativeFiles(List<File> files) {
        ArrayList<String> fs = new ArrayList<String>();
        for (File file : files) {
            String s = PropertyUtils.relativizeFile(this.baseFolder, file);
            if (s == null) continue;
            fs.add(s);
        }
        return fs;
    }

    public String[] getVariableBasedFiles() {
        assert (this.isVariableBased());
        List<File> files = Arrays.asList(this.getSelectedFiles());
        List<String> l = this.getVariableBasedFiles(files);
        return l.toArray(new String[l.size()]);
    }

    private List<String> getVariableBasedFiles(List<File> files) {
        ArrayList<String> fs = new ArrayList<String>();
        for (File file : files) {
            String s = this.getVariablesModel().getRelativePath(file, false);
            if (s == null) continue;
            fs.add(s);
        }
        return fs;
    }

    private void copyFiles(List<File> files, FileObject newRoot) throws IOException {
        ArrayList<File> fs = new ArrayList<File>();
        for (File file : files) {
            FileObject newFO;
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                throw (FileNotFoundException)Exceptions.attachLocalizedMessage((Throwable)new FileNotFoundException(file.toString()), (String)Bundle.FileChooserAccessory_no_such_file(file));
            }
            if (fo.isFolder()) {
                newFO = FileChooserAccessory.copyFolderRecursively(fo, newRoot);
            } else {
                FileObject foExists = newRoot.getFileObject(fo.getName(), fo.getExt());
                if (foExists != null) {
                    foExists.delete();
                }
                newFO = FileUtil.copyFile((FileObject)fo, (FileObject)newRoot, (String)fo.getName(), (String)fo.getExt());
            }
            fs.add(FileUtil.toFile((FileObject)newFO));
        }
        this.copiedRelativeFiles = this.getRelativeFiles(fs);
    }

    public static FileObject copyFolderRecursively(final FileObject sourceFolder, final FileObject destination) throws IOException {
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                assert (sourceFolder.isFolder()) : sourceFolder;
                assert (destination.isFolder()) : destination;
                FileObject destinationSubFolder = destination.getFileObject(sourceFolder.getName());
                if (destinationSubFolder == null) {
                    destinationSubFolder = destination.createFolder(sourceFolder.getName());
                }
                for (FileObject fo : sourceFolder.getChildren()) {
                    if (fo.isFolder()) {
                        FileChooserAccessory.copyFolderRecursively(fo, destinationSubFolder);
                        continue;
                    }
                    FileObject foExists = destinationSubFolder.getFileObject(fo.getName(), fo.getExt());
                    if (foExists != null) {
                        foExists.delete();
                    }
                    FileUtil.copyFile((FileObject)fo, (FileObject)destinationSubFolder, (String)fo.getName(), (String)fo.getExt());
                }
            }
        });
        return destination.getFileObject(sourceFolder.getName());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblReference = new JLabel();
        this.rbRelative = new JRadioButton();
        this.relativePath = new JTextField();
        this.rbVariable = new JRadioButton();
        this.variablePath = new JTextField();
        this.variablesButton = new JButton();
        this.rbCopy = new JRadioButton();
        this.copyTo = new JTextField();
        this.rbAbsolute = new JRadioButton();
        this.absolutePath = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.lblReference, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.lblReference.text"));
        this.buttonGroup1.add(this.rbRelative);
        this.rbRelative.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRelative, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbRelative.text"));
        this.rbRelative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserAccessory.this.rbActionPerformed(evt);
            }
        });
        this.relativePath.setEditable(false);
        this.relativePath.setText(null);
        this.buttonGroup1.add(this.rbVariable);
        Mnemonics.setLocalizedText((AbstractButton)this.rbVariable, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbVariable.text"));
        this.rbVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserAccessory.this.rbActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.variablesButton, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.variablesButton.text"));
        this.variablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserAccessory.this.variablesButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbCopy);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCopy, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbCopy.text"));
        this.rbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserAccessory.this.rbActionPerformed(evt);
            }
        });
        this.copyTo.setEditable(false);
        this.copyTo.setText(null);
        this.buttonGroup1.add(this.rbAbsolute);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAbsolute, (String)NbBundle.getMessage(FileChooserAccessory.class, (String)"FileChooserAccessory.rbAbsolute.text"));
        this.rbAbsolute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserAccessory.this.rbActionPerformed(evt);
            }
        });
        this.absolutePath.setEditable(false);
        this.absolutePath.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblReference).addComponent(this.rbRelative).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbVariable).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.variablePath, -2, 118, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.variablesButton)).addComponent(this.rbCopy, -1, 213, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.copyTo, -1, 192, Short.MAX_VALUE)).addComponent(this.rbAbsolute).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.absolutePath, -1, 192, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.relativePath, -1, 192, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblReference).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbRelative).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relativePath, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbVariable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.variablesButton).addComponent(this.variablePath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyTo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbAbsolute).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.absolutePath, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.rbRelative.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.rbVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.variablesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory.variablesButton.text"));
        this.rbCopy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
        this.rbAbsolute.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileChooserAccessory.class, (String)"ACSD_FileChooserAccessory_NA"));
    }

    private void variablesButtonActionPerformed(ActionEvent evt) {
        VariablesModel.Variable selected = VariablesPanel.showVariablesCustomizer();
        this.varModel = null;
        File[] files = this.getSelectedFiles();
        if (selected != null && (files.length > 0 && this.getVariablesModel().getRelativePath(files[0], true) == null || files.length == 0)) {
            this.chooser.setSelectedFile(selected.getValue());
            files = this.getSelectedFiles();
        }
        this.enableAccessory(files.length != 0);
        this.update(Arrays.asList(files));
    }

    private void rbActionPerformed(ActionEvent evt) {
        this.userSelection = true;
    }
}

