/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.hints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import net.sourceforge.pmd.IRuleViolation;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDSession;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettings;
import org.nbheaven.sqe.tools.pmd.codedefects.core.settings.PMDSettingsProvider;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class PMDHint {
    private static RequestProcessor HINT_PROCESSOR = new RequestProcessor("PMD-Hint-Processor", 1);

    private static final class FCL
    implements FileChangeListener {
        private Task task;

        private FCL(Task task) {
            this.task = task;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            this.task.refresh(true);
        }

        public void fileChanged(FileEvent fe) {
            this.task.refresh(true);
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.task.refresh(true);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EditorAwareJavaSourceTaskFactory {
        public Factory() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.MIN);
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new Task(fileObject);
        }

        protected void refreshImpl(FileObject file) {
            this.reschedule(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    implements CancellableTask<CompilationInfo> {
        private FileObject fileObject;
        private List<ErrorDescription> errors;
        private FileChangeListener listener = null;

        private Task(FileObject fileObject) {
            this.fileObject = fileObject;
            this.listener = new FCL(this);
            this.register();
        }

        private void register() {
            FileChangeListener weakFileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.fileObject);
            if (this.fileObject.isData()) {
                this.fileObject.addFileChangeListener(weakFileChangeListener);
            }
        }

        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            final FileObject fileObject = compilationInfo.getFileObject();
            final Document document = compilationInfo.getDocument();
            if (null == this.errors && null != fileObject && null != document) {
                HINT_PROCESSOR.post(new Runnable(){

                    public void run() {
                        try {
                            Task.this.errors = Task.this.computeErrors(fileObject, document);
                            Task.this.refresh(false);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                this.errors = Collections.emptyList();
            }
            if (null != this.errors && null != fileObject) {
                HintsController.setErrors((FileObject)fileObject, (String)Task.class.getName(), this.errors);
            }
        }

        private List<ErrorDescription> computeErrors(FileObject fileObject, Document document) throws Exception {
            PMDResult result;
            PMDSession session;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (null != project && null != (session = (PMDSession)project.getLookup().lookup(PMDSession.class)) && SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)session.getProvider()) && (result = session.computeResultAndWait(new FileObject[]{fileObject})) != null) {
                Map instanceByClass = result.getInstanceByClass();
                Collection classes = SearchUtilities.getFQNClassNames((FileObject)fileObject);
                LinkedList<ErrorDescription> computedErrors = new LinkedList<ErrorDescription>();
                for (String className : classes) {
                    for (Object key : instanceByClass.keySet()) {
                        PMDResult.ClassKey classKey = (PMDResult.ClassKey)key;
                        if (!classKey.getDisplayName().equals(className)) continue;
                        Collection bugs = (Collection)instanceByClass.get(classKey);
                        computedErrors.addAll(this.getErrors(project, bugs, fileObject, document));
                    }
                }
                return computedErrors;
            }
            return Collections.emptyList();
        }

        private void refresh(boolean deepRefresh) {
            if (deepRefresh) {
                this.errors = null;
            }
            for (JavaSourceTaskFactory f : Lookup.getDefault().lookupAll(JavaSourceTaskFactory.class)) {
                if (!(f instanceof Factory)) continue;
                ((Factory)f).refreshImpl(this.fileObject);
            }
        }

        private List<ErrorDescription> getErrors(final Project project, Collection<IRuleViolation> ruleViolations, FileObject file, Document document) {
            LinkedList<ErrorDescription> errorDescriptions = new LinkedList<ErrorDescription>();
            for (final IRuleViolation ruleViolation : ruleViolations) {
                Fix fix = new Fix(){

                    public String getText() {
                        return "Disable PMD Rule: " + ruleViolation.getRule().getName();
                    }

                    public ChangeInfo implement() throws Exception {
                        PMDSession qualitySession;
                        PMDResult result;
                        PMDSettings pmdSettings;
                        PMDSettingsProvider settingsProvider = (PMDSettingsProvider)project.getLookup().lookup(PMDSettingsProvider.class);
                        if (null != settingsProvider && (pmdSettings = settingsProvider.getPMDSettings()) != null) {
                            pmdSettings.deactivateRule(ruleViolation.getRule());
                        }
                        if (null != (result = (qualitySession = (PMDSession)project.getLookup().lookup(PMDSession.class)).getResult())) {
                            result.removeAllRuleViolationsForRule(ruleViolation.getRule());
                        }
                        return new ChangeInfo();
                    }
                };
                try {
                    ErrorDescription error = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)("[PMD] " + ruleViolation.getDescription()), Arrays.asList(fix), (Document)document, (int)Math.max(1, ruleViolation.getBeginLine()));
                    errorDescriptions.add(error);
                }
                catch (RuntimeException e) {
                    System.err.println("INFO: Can't create ErrorDescription for pmd rule violation: " + ruleViolation.getDescription() + "[" + ruleViolation.getClassName() + ":" + ruleViolation.getBeginLine() + "]");
                    e.printStackTrace();
                }
            }
            return errorDescriptions;
        }
    }
}

