/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.controlcenter.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.nbheaven.sqe.core.api.SQEManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projects
extends JPanel {
    private JComboBox openProjectsComboBox;
    private DefaultComboBoxModel projectModel;
    private final SelectedProjectListener selectedProjectListener;
    private final SQEManagerListener sqeManagerListener;
    private final OpenProjectsListner openProjectsListner;

    public Projects() {
        this.initComponents();
        this.sqeManagerListener = new SQEManagerListener(this);
        this.openProjectsListner = new OpenProjectsListner(this);
        this.selectedProjectListener = new SelectedProjectListener(this.openProjectsComboBox);
        this.openProjectsComboBox.addItemListener(this.selectedProjectListener);
        this.openProjectsComboBox.addActionListener(this.selectedProjectListener);
    }

    private void initComponents() {
        this.projectModel = new DefaultComboBoxModel<Object>(Projects.getOpenedProjectsSorted().toArray());
        this.openProjectsComboBox = new JComboBox(this.projectModel);
        this.openProjectsComboBox.setRenderer(new OpenProjectsListCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.openProjectsComboBox, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        Dimension preferredSize = this.openProjectsComboBox.getPreferredSize();
        preferredSize.width = 0;
        this.openProjectsComboBox.setPreferredSize(preferredSize);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this.openProjectsListner);
        SQEManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this.sqeManagerListener);
        this.updateOpenProjects();
    }

    @Override
    public void removeNotify() {
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this.openProjectsListner);
        SQEManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this.sqeManagerListener);
        super.removeNotify();
    }

    private void updateSelectedProject() {
        Project o = SQEManager.getDefault().getActiveProject();
        if (this.projectModel.getSize() == 0) {
            this.openProjectsComboBox.setEnabled(false);
            this.openProjectsComboBox.setSelectedIndex(-1);
        } else if (-1 != this.projectModel.getIndexOf(o)) {
            this.openProjectsComboBox.setEnabled(true);
            this.openProjectsComboBox.setSelectedItem(o);
        } else {
            this.openProjectsComboBox.setEnabled(true);
            this.openProjectsComboBox.setSelectedIndex(0);
        }
    }

    private void updateOpenProjects() {
        this.openProjectsComboBox.removeItemListener(this.selectedProjectListener);
        this.openProjectsComboBox.removeActionListener(this.selectedProjectListener);
        this.projectModel.removeAllElements();
        for (Project project : Projects.getOpenedProjectsSorted()) {
            this.projectModel.addElement(project);
        }
        this.openProjectsComboBox.addItemListener(this.selectedProjectListener);
        this.openProjectsComboBox.addActionListener(this.selectedProjectListener);
        this.updateSelectedProject();
    }

    public static Set<Project> getOpenedProjectsSorted() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        TreeSet<Project> sorted = new TreeSet<Project>(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                String s1 = ProjectUtils.getInformation((Project)o1).getDisplayName();
                String s2 = ProjectUtils.getInformation((Project)o2).getDisplayName();
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        });
        sorted.addAll(Arrays.asList(openProjects));
        return sorted;
    }

    private static class OpenProjectsListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel && null != value) {
                Project project = (Project)value;
                JLabel label = (JLabel)c;
                label.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
                label.setIcon(ProjectUtils.getInformation((Project)project).getIcon());
                label.setToolTipText(FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                if (-1 < index) {
                    list.setToolTipText(FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                }
            }
            return c;
        }
    }

    private static class OpenProjectsListner
    implements PropertyChangeListener {
        private final Projects projects;

        public OpenProjectsListner(Projects projects) {
            this.projects = projects;
        }

        public void propertyChange(final PropertyChangeEvent evt) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        OpenProjectsListner.this.propertyChange(evt);
                    }
                });
                return;
            }
            this.projects.updateOpenProjects();
        }
    }

    private static class SQEManagerListener
    implements PropertyChangeListener {
        private final Projects projects;

        public SQEManagerListener(Projects projects) {
            this.projects = projects;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.projects.updateSelectedProject();
        }
    }

    private static class SelectedProjectListener
    implements ItemListener,
    ActionListener {
        private final JComboBox comboBox;

        public SelectedProjectListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void itemStateChanged(ItemEvent e) {
            if (1 == e.getStateChange()) {
                Project project = (Project)e.getItem();
                SQEManager.getDefault().setActiveProject(project);
                this.comboBox.setToolTipText(FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
            }
        }

        public void actionPerformed(ActionEvent e) {
            Project project = (Project)this.comboBox.getSelectedItem();
            SQEManager.getDefault().setActiveProject(project);
        }
    }
}

