/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.controlcenter.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.nbheaven.sqe.core.api.SQEManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.NbBundle;

public class ProjectStatistics
extends JPanel
implements PropertyChangeListener {
    private Project activeProject;
    private JList classPathList;
    private JScrollPane classPathScrollPane;
    private JLabel classpathLabel;
    private JLabel name;
    private JLabel nameLabel;
    private JLabel noSourceFilesLabel;
    private JLabel sourceFiles;

    public ProjectStatistics() {
        this.initComponents();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.noSourceFilesLabel = new JLabel();
        this.classpathLabel = new JLabel();
        this.classPathScrollPane = new JScrollPane();
        this.classPathList = new JList();
        this.name = new JLabel();
        this.sourceFiles = new JLabel();
        this.setBackground(SystemColor.window);
        this.nameLabel.setText(NbBundle.getMessage(ProjectStatistics.class, (String)"ProjectStatistics.nameLabel.text"));
        this.noSourceFilesLabel.setText(NbBundle.getMessage(ProjectStatistics.class, (String)"ProjectStatistics.noSourceFilesLabel.text"));
        this.classpathLabel.setText(NbBundle.getMessage(ProjectStatistics.class, (String)"ProjectStatistics.classpathLabel.text"));
        this.classPathList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.classPathScrollPane.setViewportView(this.classPathList);
        this.name.setText(NbBundle.getMessage(ProjectStatistics.class, (String)"ProjectStatistics.name.text"));
        this.sourceFiles.setText(NbBundle.getMessage(ProjectStatistics.class, (String)"ProjectStatistics.sourceFiles.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.classpathLabel).add((Component)this.nameLabel).add((Component)this.noSourceFilesLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.name, -1, -1, Short.MAX_VALUE).add(90, 90, 90)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sourceFiles, -1, -1, Short.MAX_VALUE).add(90, 90, 90)).add((Component)this.classPathScrollPane, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.name)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.noSourceFilesLabel).add((Component)this.sourceFiles)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.classpathLabel).add((Component)this.classPathScrollPane, -1, 52, Short.MAX_VALUE)).addContainerGap()));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.activeProject = (Project)evt.getNewValue();
        this.updateData();
    }

    private void updateData() {
        if (null != this.activeProject) {
            this.name.setText(ProjectUtils.getInformation((Project)this.activeProject).getDisplayName());
        } else {
            this.name.setText("<No project selected>");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.activeProject = SQEManager.getDefault().getActiveProject();
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        this.updateData();
    }

    public void removeNotify() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        super.removeNotify();
    }
}

