/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.controlcenter.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.nbheaven.sqe.core.api.SQEManager;
import org.nbheaven.sqe.core.ui.components.collapser.JCollapserPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

final class SQEControlCenterTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static SQEControlCenterTopComponent instance;
    private static final String ICON_PATH = "org/nbheaven/sqe/core/controlcenter/ui/resources/sqe_16.png";
    private static final String PREFERRED_ID = "SQEControlCenterTopComponent";
    private static final String TC_GROUP = "SQEControlCenter";

    private SQEControlCenterTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SQEControlCenterTopComponent.class, (String)"CTL_SQEControlCenterTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SQEControlCenterTopComponent.class, (String)"HINT_SQEControlCenterTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.initComponentsManual();
    }

    private void initComponentsManual() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout());
        panel.setBackground(Color.WHITE);
        panel.setOpaque(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        FileObject fo = FileUtil.getConfigFile((String)"SQE/ControlCenter/Panels");
        for (FileObject panelObject : FileUtil.getOrder(Arrays.asList(fo.getChildren()), (boolean)true)) {
            try {
                DataObject dao = DataObject.find((FileObject)panelObject);
                Boolean collapsed = (Boolean)panelObject.getAttribute("collapsed");
                InstanceCookie cookie = (InstanceCookie)dao.getLookup().lookup(InstanceCookie.class);
                if (null == cookie) continue;
                JComponent component = (JComponent)cookie.instanceCreate();
                JCollapserPanel snippet = new JCollapserPanel(dao.getNodeDelegate().getDisplayName(), component);
                if (null != collapsed && collapsed.booleanValue()) {
                    snippet.setCollapsed(true);
                }
                panel.add((Component)snippet, gbc);
            }
            catch (DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace((Throwable)donfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                Exceptions.printStackTrace((Throwable)cnfe);
            }
        }
        gbc.weighty = 1.0;
        JPanel padding = new JPanel();
        padding.setBackground(Color.WHITE);
        padding.setOpaque(true);
        panel.add((Component)padding, gbc);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.add(scrollPane, "Center");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized SQEControlCenterTopComponent getDefault() {
        if (instance == null) {
            instance = new SQEControlCenterTopComponent();
        }
        return instance;
    }

    public static synchronized SQEControlCenterTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(SQEControlCenterTopComponent.class.getName()).warning("Cannot find SQEControlCenterTopComponent component. It will not be located properly in the window system.");
            return SQEControlCenterTopComponent.getDefault();
        }
        if (win instanceof SQEControlCenterTopComponent) {
            return (SQEControlCenterTopComponent)win;
        }
        Logger.getLogger(SQEControlCenterTopComponent.class.getName()).warning("There seem to be multiple components with the 'SQEControlCenterTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return SQEControlCenterTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentActivated() {
        super.componentActivated();
        TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup(TC_GROUP);
        if (group != null) {
            group.open();
        }
    }

    public void componentDeactivated() {
        TopComponentGroup group;
        boolean closeGroup = true;
        Mode curMode = WindowManager.getDefault().findMode((TopComponent)this);
        TopComponent selected = curMode.getSelectedTopComponent();
        if (selected != null && selected instanceof SQEControlCenterTopComponent) {
            closeGroup = false;
        }
        if (closeGroup && (group = WindowManager.getDefault().findTopComponentGroup(TC_GROUP)) != null) {
            group.close();
        }
        super.componentDeactivated();
    }

    public void componentOpened() {
        SQEManager.getDefault().setFollowActionGlobalContext(false);
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        this.setActiveProject(SQEManager.getDefault().getActiveProject());
    }

    public void componentClosed() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        SQEManager.getDefault().setFollowActionGlobalContext(true);
        super.componentClosed();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setActiveProject((Project)evt.getNewValue());
    }

    private void setActiveProject(final Project project) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SQEControlCenterTopComponent.this.setActiveProject(project);
                }
            });
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        if (null != project) {
            this.setDisplayName("Quality [" + ProjectUtils.getInformation((Project)project).getDisplayName() + "]");
            Node[] activatedNodes = new Node[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{project}))};
            this.setActivatedNodes(activatedNodes);
        } else {
            this.setDisplayName("Quality [no project]");
            this.setActivatedNodes(new Node[0]);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return SQEControlCenterTopComponent.getDefault();
        }
    }

    public static final class VerticalLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int posX = insets.left;
            int posY = insets.top;
            int width = parent.getWidth() - insets.left - insets.right;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                int height = comp.getPreferredSize().height;
                if (i == comps.length - 1 && posY + height < parent.getHeight() - insets.bottom) {
                    height = parent.getHeight() - insets.bottom - posY;
                }
                comp.setBounds(posX, posY, width, height);
                posY += height;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getMinimumSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getPreferredSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

