/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDerivFunction;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.util.Equal;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.ValidationContext;

class PatternMatcher
implements Cloneable,
Matcher {
    private PatternMemo memo;
    private boolean textTyped;
    private boolean hadError;
    private boolean ignoreNextEndTag;
    private String errorMessage;
    private final Shared shared;

    PatternMatcher(Pattern start, ValidatorPatternBuilder builder) {
        this.shared = new Shared(start, builder);
        this.memo = builder.getPatternMemo(start);
    }

    public boolean equals(Object obj) {
        PatternMatcher other = (PatternMatcher)obj;
        if (other == null) {
            return false;
        }
        return this.memo == other.memo && this.hadError == other.hadError && Equal.equal(this.errorMessage, other.errorMessage) && this.ignoreNextEndTag == other.ignoreNextEndTag && this.textTyped == other.textTyped;
    }

    public int hashCode() {
        return this.memo.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Matcher copy() {
        return (Matcher)this.clone();
    }

    public boolean matchStartDocument() {
        if (this.memo.isNotAllowed()) {
            return this.error("schema_allows_nothing");
        }
        return true;
    }

    public boolean matchStartTagOpen(Name name) {
        if (this.setMemo(this.memo.startTagOpenDeriv(name))) {
            return true;
        }
        PatternMemo next = this.memo.startTagOpenRecoverDeriv(name);
        if (!next.isNotAllowed()) {
            this.memo = next;
            return this.error("required_elements_missing");
        }
        ValidatorPatternBuilder builder = this.shared.builder;
        this.memo = next = builder.getPatternMemo(builder.makeAfter(this.shared.findElement(name), this.memo.getPattern()));
        return this.error(next.isNotAllowed() ? "unknown_element" : "out_of_context_element", name);
    }

    public boolean matchAttributeName(Name name) {
        if (this.setMemo(this.memo.startAttributeDeriv(name))) {
            return true;
        }
        this.ignoreNextEndTag = true;
        return this.error("impossible_attribute_ignored", name);
    }

    public boolean matchAttributeValue(Name name, String value, ValidationContext vc) {
        if (this.ignoreNextEndTag) {
            this.ignoreNextEndTag = false;
            return true;
        }
        if (this.setMemo(this.memo.dataDeriv(value, vc))) {
            return true;
        }
        this.memo = this.memo.recoverAfter();
        return this.error("bad_attribute_value", name);
    }

    public boolean matchStartTagClose() {
        boolean ret;
        if (this.setMemo(this.memo.endAttributes())) {
            ret = true;
        } else {
            this.memo = this.memo.ignoreMissingAttributes();
            ret = this.error("required_attributes_missing");
        }
        this.textTyped = this.memo.getPattern().getContentType() == 3;
        return ret;
    }

    public boolean matchText(String string, ValidationContext vc, boolean nextTagIsEndTag) {
        if (this.textTyped && nextTagIsEndTag) {
            this.ignoreNextEndTag = true;
            return this.setDataDeriv(string, vc);
        }
        if (DataDerivFunction.isBlank(string)) {
            return true;
        }
        return this.matchUntypedText();
    }

    public boolean matchUntypedText() {
        if (this.setMemo(this.memo.mixedTextDeriv())) {
            return true;
        }
        return this.error("text_not_allowed");
    }

    public boolean isTextTyped() {
        return this.textTyped;
    }

    private boolean setDataDeriv(String string, ValidationContext vc) {
        this.textTyped = false;
        if (!this.setMemo(this.memo.textOnly())) {
            this.memo = this.memo.recoverAfter();
            return this.error("only_text_not_allowed");
        }
        if (this.setMemo(this.memo.dataDeriv(string, vc))) {
            this.ignoreNextEndTag = true;
            return true;
        }
        PatternMemo next = this.memo.recoverAfter();
        boolean ret = true;
        if (!(this.memo.isNotAllowed() || next.isNotAllowed() && !this.shared.fixAfter(this.memo).dataDeriv(string, vc).isNotAllowed())) {
            ret = this.error("string_not_allowed");
        }
        this.memo = next;
        return ret;
    }

    public boolean matchEndTag(ValidationContext vc) {
        if (this.ignoreNextEndTag) {
            this.ignoreNextEndTag = false;
            return true;
        }
        if (this.textTyped) {
            return this.setDataDeriv("", vc);
        }
        this.textTyped = false;
        if (this.setMemo(this.memo.endTagDeriv())) {
            return true;
        }
        PatternMemo next = this.memo.recoverAfter();
        if (this.memo.isNotAllowed() && (!next.isNotAllowed() || this.shared.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
            this.memo = next;
            return this.error("unfinished_element");
        }
        this.memo = next;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValidSoFar() {
        return !this.hadError;
    }

    public Set possibleStartTags(Set knownNames) {
        return new PossibleStartTagsFunction().applyTo(this.memo.getPattern(), knownNames);
    }

    public Set possibleAttributes(Set knownNames) {
        return new PossibleAttributesFunction().applyTo(this.memo.getPattern(), knownNames);
    }

    private boolean setMemo(PatternMemo m) {
        if (m.isNotAllowed()) {
            return false;
        }
        this.memo = m;
        return true;
    }

    private boolean error(String key) {
        if (this.hadError && this.memo.isNotAllowed()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = SchemaBuilderImpl.localizer.message(key);
        return false;
    }

    private boolean error(String key, Name arg) {
        return this.error(key, NameFormatter.format(arg));
    }

    private boolean error(String key, String arg) {
        if (this.hadError && this.memo.isNotAllowed()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = SchemaBuilderImpl.localizer.message(key, arg);
        return false;
    }

    static class PossibleAttributesFunction
    extends PossibleNamesFunction {
        PossibleAttributesFunction() {
        }

        public Object caseAttribute(AttributePattern p) {
            p.getNameClass().accept(this);
            return null;
        }

        public Object caseGroup(GroupPattern p) {
            return this.caseBinary(p);
        }
    }

    static abstract class PossibleNamesFunction
    extends AbstractPatternFunction
    implements NameClassVisitor {
        private Set knownNames;
        private Set possibleNames;

        PossibleNamesFunction() {
        }

        Set applyTo(Pattern p, Set knownNames) {
            this.knownNames = knownNames;
            this.possibleNames = new HashSet();
            p.apply(this);
            return this.possibleNames;
        }

        public Object caseAfter(AfterPattern p) {
            return p.getOperand1().apply(this);
        }

        public Object caseBinary(BinaryPattern p) {
            p.getOperand1().apply(this);
            p.getOperand2().apply(this);
            return null;
        }

        public Object caseChoice(ChoicePattern p) {
            return this.caseBinary(p);
        }

        public Object caseInterleave(InterleavePattern p) {
            return this.caseBinary(p);
        }

        public Object caseOneOrMore(OneOrMorePattern p) {
            return p.getOperand().apply(this);
        }

        public Object caseOther(Pattern p) {
            return null;
        }

        public void visitChoice(NameClass nc1, NameClass nc2) {
            nc1.accept(this);
            nc2.accept(this);
        }

        public void visitNsName(String ns) {
            this.visitNsNameExcept(ns, null);
        }

        public void visitNsNameExcept(String ns, NameClass nc) {
            if (this.knownNames == null) {
                return;
            }
            boolean addedAll = true;
            for (Name name : this.knownNames) {
                if (!name.getNamespaceUri().equals(ns) || nc != null && nc.contains(name)) {
                    addedAll = false;
                    continue;
                }
                this.possibleNames.add(name);
            }
            if (addedAll) {
                this.knownNames = null;
            }
        }

        public void visitAnyName() {
            if (this.knownNames == null) {
                return;
            }
            this.possibleNames.addAll(this.knownNames);
            this.knownNames = null;
        }

        public void visitAnyNameExcept(NameClass nc) {
            if (this.knownNames == null) {
                return;
            }
            boolean addedAll = true;
            for (Name name : this.knownNames) {
                if (nc.contains(name)) {
                    addedAll = false;
                    continue;
                }
                this.possibleNames.add(name);
            }
            if (addedAll) {
                this.knownNames = null;
            }
        }

        public void visitName(Name name) {
            this.possibleNames.add(name);
        }

        public void visitNull() {
        }

        public void visitError() {
        }
    }

    static class PossibleStartTagsFunction
    extends PossibleNamesFunction {
        PossibleStartTagsFunction() {
        }

        public Object caseElement(ElementPattern p) {
            p.getNameClass().accept(this);
            return null;
        }

        public Object caseGroup(GroupPattern p) {
            p.getOperand1().apply(this);
            if (p.getOperand1().isNullable()) {
                p.getOperand2().apply(this);
            }
            return null;
        }
    }

    private static class Shared {
        private final Pattern start;
        private final ValidatorPatternBuilder builder;
        private Map recoverPatternTable;

        Shared(Pattern start, ValidatorPatternBuilder builder) {
            this.start = start;
            this.builder = builder;
        }

        Pattern findElement(Name name) {
            Pattern p;
            if (this.recoverPatternTable == null) {
                this.recoverPatternTable = new HashMap();
            }
            if ((p = (Pattern)this.recoverPatternTable.get(name)) == null) {
                p = FindElementFunction.findElement(this.builder, name, this.start);
                this.recoverPatternTable.put(name, p);
            }
            return p;
        }

        PatternMemo fixAfter(PatternMemo p) {
            return this.builder.getPatternMemo(p.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

                Pattern apply(Pattern p) {
                    return Shared.this.builder.makeEmpty();
                }
            }));
        }
    }
}

