/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgRevert
extends SvnNgOperationRunner<Void, SvnRevert> {
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        boolean useCommitTimes = ((SvnRevert)this.getOperation()).getOptions().isUseCommitTimes();
        for (SvnTarget target : ((SvnRevert)this.getOperation()).getTargets()) {
            this.checkCancelled();
            boolean isWcRoot = context.getDb().isWCRoot(target.getFile());
            File lockTarget = isWcRoot ? target.getFile() : SVNFileUtil.getParentFile(target.getFile());
            File lockRoot = context.acquireWriteLock(lockTarget, false, true);
            try {
                this.revert(target.getFile(), ((SvnRevert)this.getOperation()).getDepth(), useCommitTimes, ((SvnRevert)this.getOperation()).getApplicableChangelists());
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || err.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || err.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNEvent event = SVNEventFactory.createSVNEvent(target.getFile(), SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.REVERT, err, null, -1L, -1L);
                    this.handleEvent(event);
                    continue;
                }
                if (!useCommitTimes) {
                    this.sleepForTimestamp();
                }
                throw e;
            }
            finally {
                context.releaseWriteLock(lockRoot);
            }
        }
        if (!useCommitTimes) {
            this.sleepForTimestamp();
        }
        return null;
    }

    private void revert(File localAbsPath, SVNDepth depth, boolean useCommitTimes, Collection<String> changelists) throws SVNException {
        if (changelists != null && changelists.size() > 0) {
            this.revertChangelist(localAbsPath, depth, useCommitTimes, changelists);
            return;
        }
        if (depth == SVNDepth.EMPTY || depth == SVNDepth.INFINITY) {
            this.revert(localAbsPath, depth, useCommitTimes);
            return;
        }
        if (depth == SVNDepth.IMMEDIATES || depth == SVNDepth.FILES) {
            this.revert(localAbsPath, SVNDepth.EMPTY, useCommitTimes);
            Set<String> children = ((SVNWCDb)this.getWcContext().getDb()).getWorkingChildren(localAbsPath);
            for (String childName : children) {
                SVNNodeKind childKind;
                File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, childName);
                if (depth == SVNDepth.FILES && (childKind = this.getWcContext().readKind(childAbsPath, true)) != SVNNodeKind.FILE) continue;
                this.revert(childAbsPath, SVNDepth.EMPTY, useCommitTimes);
            }
            return;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    private void revertChangelist(File localAbsPath, SVNDepth depth, boolean useCommitTimes, Collection<String> changelists) throws SVNException {
        this.checkCancelled();
        if (this.getWcContext().isChangelistMatch(localAbsPath, changelists)) {
            this.revert(localAbsPath, SVNDepth.EMPTY, useCommitTimes);
        }
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
            depth = SVNDepth.EMPTY;
        }
        Set<String> children = ((SVNWCDb)this.getWcContext().getDb()).getWorkingChildren(localAbsPath);
        for (String childName : children) {
            File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, childName);
            this.revertChangelist(childAbsPath, depth, useCommitTimes, changelists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revert(File localAbsPath, SVNDepth depth, boolean useCommitTimes) throws SVNException {
        File wcRoot = this.getWcContext().getDb().getWCRoot(localAbsPath);
        if (!localAbsPath.equals(wcRoot)) {
            this.getWcContext().writeCheck(SVNFileUtil.getParentFile(localAbsPath));
        } else {
            this.getWcContext().writeCheck(localAbsPath);
        }
        try {
            this.getWcContext().getDb().opRevert(localAbsPath, depth);
            SvnNgRevert.restore(this.getWcContext(), localAbsPath, depth, useCommitTimes, this.getWcContext().getEventHandler());
        }
        finally {
            SvnWcDbRevert.dropRevertList(this.getWcContext(), localAbsPath);
        }
    }

    public static void restore(SVNWCContext context, File localAbsPath, SVNDepth depth, boolean useCommitTimes, ISVNEventHandler notifier) throws SVNException {
        context.checkCancelled();
        Structure<SvnWcDbRevert.RevertInfo> revertInfo = SvnWcDbRevert.readRevertInfo(context, localAbsPath);
        ISVNWCDb.SVNWCDbStatus status = ISVNWCDb.SVNWCDbStatus.Normal;
        ISVNWCDb.SVNWCDbKind kind = ISVNWCDb.SVNWCDbKind.Unknown;
        long recordedSize = -1L;
        long recordedTime = 0L;
        boolean notifyRequired = revertInfo.is(SvnWcDbRevert.RevertInfo.reverted);
        try {
            Structure<StructureFields.NodeInfo> nodeInfo = context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.recordedSize, StructureFields.NodeInfo.recordedTime);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
            kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
            recordedSize = nodeInfo.lng(StructureFields.NodeInfo.recordedSize);
            recordedTime = nodeInfo.lng(StructureFields.NodeInfo.recordedTime);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                if (!revertInfo.is(SvnWcDbRevert.RevertInfo.copiedHere)) {
                    if (notifyRequired && notifier != null) {
                        notifier.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
                    }
                    SvnWcDbRevert.notifyRevert(context, localAbsPath, notifier);
                    return;
                }
            }
            throw e;
        }
        SVNFileType filetype = SVNFileType.getType(localAbsPath);
        SVNNodeKind onDisk = null;
        boolean special = false;
        if (filetype == SVNFileType.NONE) {
            onDisk = SVNNodeKind.NONE;
            special = false;
        } else {
            onDisk = filetype == SVNFileType.FILE || filetype == SVNFileType.SYMLINK ? SVNNodeKind.FILE : (filetype == SVNFileType.DIRECTORY ? SVNNodeKind.DIR : SVNNodeKind.UNKNOWN);
            boolean bl = special = filetype == SVNFileType.SYMLINK;
        }
        if (revertInfo.is(SvnWcDbRevert.RevertInfo.copiedHere)) {
            boolean removed;
            if (revertInfo.get(SvnWcDbRevert.RevertInfo.kind) == ISVNWCDb.SVNWCDbKind.File && onDisk == SVNNodeKind.FILE) {
                SVNFileUtil.deleteFile(localAbsPath);
                onDisk = SVNNodeKind.NONE;
            } else if (revertInfo.get(SvnWcDbRevert.RevertInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir && onDisk == SVNNodeKind.DIR && (removed = SvnNgRevert.restoreCopiedDirectory(context, localAbsPath, true))) {
                onDisk = SVNNodeKind.NONE;
            }
        }
        if (onDisk != SVNNodeKind.NONE && status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Deleted && status != ISVNWCDb.SVNWCDbStatus.Excluded && status != ISVNWCDb.SVNWCDbStatus.NotPresent) {
            if (onDisk == SVNNodeKind.DIR && kind != ISVNWCDb.SVNWCDbKind.Dir) {
                SVNFileUtil.deleteAll(localAbsPath, true, notifier);
                onDisk = SVNNodeKind.NONE;
            } else if (onDisk == SVNNodeKind.FILE && kind != ISVNWCDb.SVNWCDbKind.File) {
                SVNFileUtil.deleteFile(localAbsPath);
                onDisk = SVNNodeKind.NONE;
            } else if (onDisk == SVNNodeKind.FILE) {
                SVNProperties pristineProperties = context.getDb().readPristineProperties(localAbsPath);
                boolean modified = false;
                String specialProperty = pristineProperties.getStringValue("svn:special");
                if (SVNFileUtil.symlinksSupported() && specialProperty != null != special) {
                    SVNFileUtil.deleteFile(localAbsPath);
                    onDisk = SVNNodeKind.NONE;
                } else {
                    long lastModified = SVNFileUtil.getFileLastModified(localAbsPath);
                    long size = SVNFileUtil.getFileLength(localAbsPath);
                    modified = recordedSize != -1L && recordedTime != 0L && recordedSize == size && recordedTime / 1000L == lastModified ? false : context.isTextModified(localAbsPath, true);
                }
                if (modified) {
                    SVNFileUtil.deleteFile(localAbsPath);
                    onDisk = SVNNodeKind.NONE;
                } else {
                    boolean needsLock;
                    boolean isReadOnly = filetype != SVNFileType.SYMLINK && !localAbsPath.canWrite();
                    boolean bl = needsLock = pristineProperties.getStringValue("svn:needs-lock") != null;
                    if (needsLock && !isReadOnly) {
                        SVNFileUtil.setReadonly(localAbsPath, true);
                        notifyRequired = true;
                    } else if (!needsLock && isReadOnly) {
                        SVNFileUtil.setReadonly(localAbsPath, false);
                        notifyRequired = true;
                    }
                }
                if (!(SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS || SVNFileUtil.symlinksSupported() && special)) {
                    boolean executableProperty;
                    boolean executable = SVNFileUtil.isExecutable(localAbsPath);
                    boolean bl = executableProperty = pristineProperties.getStringValue("svn:executable") != null;
                    if (executableProperty && !executable) {
                        SVNFileUtil.setExecutable(localAbsPath, true);
                        notifyRequired = true;
                    } else if (!executableProperty && executable) {
                        SVNFileUtil.setExecutable(localAbsPath, false);
                        notifyRequired = true;
                    }
                }
            }
        }
        if (onDisk == SVNNodeKind.NONE && status != ISVNWCDb.SVNWCDbStatus.ServerExcluded && status != ISVNWCDb.SVNWCDbStatus.Deleted && status != ISVNWCDb.SVNWCDbStatus.Excluded && status != ISVNWCDb.SVNWCDbStatus.NotPresent) {
            if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
                SVNFileUtil.ensureDirectoryExists(localAbsPath);
            } else if (kind == ISVNWCDb.SVNWCDbKind.File) {
                SVNSkel workItem = context.wqBuildFileInstall(localAbsPath, null, useCommitTimes, true);
                context.getDb().addWorkQueue(localAbsPath, workItem);
                context.wqRun(localAbsPath);
            }
            notifyRequired = true;
        }
        if (revertInfo.hasValue(SvnWcDbRevert.RevertInfo.conflictOld)) {
            notifyRequired |= SVNFileUtil.deleteFile((File)revertInfo.get(SvnWcDbRevert.RevertInfo.conflictOld));
        }
        if (revertInfo.hasValue(SvnWcDbRevert.RevertInfo.conflictNew)) {
            notifyRequired |= SVNFileUtil.deleteFile((File)revertInfo.get(SvnWcDbRevert.RevertInfo.conflictNew));
        }
        if (revertInfo.hasValue(SvnWcDbRevert.RevertInfo.conflictWorking)) {
            notifyRequired |= SVNFileUtil.deleteFile((File)revertInfo.get(SvnWcDbRevert.RevertInfo.conflictWorking));
        }
        if (revertInfo.hasValue(SvnWcDbRevert.RevertInfo.propReject)) {
            notifyRequired |= SVNFileUtil.deleteFile((File)revertInfo.get(SvnWcDbRevert.RevertInfo.propReject));
        }
        if (notifyRequired && notifier != null) {
            notifier.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
        }
        if (depth == SVNDepth.INFINITY && kind == ISVNWCDb.SVNWCDbKind.Dir) {
            SvnNgRevert.restoreCopiedDirectory(context, localAbsPath, false);
            Set<String> children = ((SVNWCDb)context.getDb()).getChildrenOfWorkingNode(localAbsPath);
            for (String childName : children) {
                File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, childName);
                SvnNgRevert.restore(context, childAbsPath, depth, useCommitTimes, notifier);
            }
        }
        SvnWcDbRevert.notifyRevert(context, localAbsPath, notifier);
    }

    private static boolean restoreCopiedDirectory(SVNWCContext context, File localAbsPath, boolean removeSelf) throws SVNException {
        ISVNWCDb.SVNWCDbKind childKind;
        boolean selfRemoved = false;
        Map<File, ISVNWCDb.SVNWCDbKind> children = SvnWcDbRevert.readRevertCopiedChildren(context, localAbsPath);
        for (File child : children.keySet()) {
            SVNFileType childFileType;
            context.checkCancelled();
            childKind = children.get(child);
            if (childKind != ISVNWCDb.SVNWCDbKind.File || (childFileType = SVNFileType.getType(child)) != SVNFileType.FILE && childFileType != SVNFileType.SYMLINK) continue;
            SVNFileUtil.deleteFile(child);
        }
        for (File child : children.keySet()) {
            context.checkCancelled();
            childKind = children.get(child);
            if (childKind != ISVNWCDb.SVNWCDbKind.Dir) continue;
            SVNFileUtil.deleteFile(child);
        }
        if (removeSelf) {
            SVNFileUtil.deleteFile(localAbsPath);
            if (SVNFileType.getType(localAbsPath) == SVNFileType.NONE) {
                selfRemoved = true;
            }
        }
        return selfRemoved;
    }
}

