/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitMediator17;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgCommit
extends SvnNgOperationRunner<SVNCommitInfo, SvnCommit>
implements ISvnCommitRunner,
SvnNgCommitUtil.ISvnUrlKindCallback {
    @Override
    public SvnCommitPacket collectCommitItems(SvnCommit operation) throws SVNException {
        this.setOperation(operation);
        SvnCommitPacket packet = new SvnCommitPacket();
        ArrayList<String> targets = new ArrayList<String>();
        String[] validatedPaths = new String[((SvnCommit)this.getOperation()).getTargets().size()];
        int i = 0;
        for (SvnTarget target : ((SvnCommit)this.getOperation()).getTargets()) {
            validatedPaths[i] = target.getFile().getAbsolutePath();
            validatedPaths[i] = validatedPaths[i].replace(File.separatorChar, '/');
            ++i;
        }
        String rootPath = SVNPathUtil.condencePaths(validatedPaths, targets, false);
        if (rootPath == null) {
            return packet;
        }
        File baseDir = new File(rootPath).getAbsoluteFile();
        if (targets.isEmpty()) {
            targets.add("");
        }
        Collection<File> lockTargets = this.determineLockTargets(baseDir, targets);
        HashSet<File> lockedRoots = new HashSet<File>();
        try {
            for (File lockTarget : lockTargets) {
                File lockRoot = this.getWcContext().acquireWriteLock(lockTarget, false, true);
                lockedRoots.add(lockRoot);
            }
            packet.setLockingContext(this, lockedRoots);
            HashMap<SVNURL, String> lockTokens = new HashMap<SVNURL, String>();
            SvnNgCommitUtil.harvestCommittables(this.getWcContext(), packet, lockTokens, baseDir, targets, ((SvnCommit)this.getOperation()).getDepth(), !((SvnCommit)this.getOperation()).isKeepLocks(), ((SvnCommit)this.getOperation()).getApplicableChangelists(), this, ((SvnCommit)this.getOperation()).getCommitParameters(), null);
            packet.setLockTokens(lockTokens);
            if (packet.getRepositoryRoots().size() > 1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit can only commit to a single repository at a time.\nAre all targets part of the same working copy?");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!packet.isEmpty()) {
                return packet;
            }
            packet.dispose();
            return new SvnCommitPacket();
        }
        catch (SVNException e) {
            packet.dispose();
            SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    @Override
    protected SVNCommitInfo run(SVNWCContext context) throws SVNException {
        SVNCommitInfo info = this.doRun(context);
        if (info != null) {
            ((SvnCommit)this.getOperation()).receive(((SvnCommit)this.getOperation()).getFirstTarget(), info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNCommitInfo doRun(SVNWCContext context) throws SVNException {
        SvnCommitPacket packet = ((SvnCommit)this.getOperation()).collectCommitItems();
        if (packet == null || packet.isEmpty()) {
            return null;
        }
        SVNProperties revisionProperties = ((SvnCommit)this.getOperation()).getRevisionProperties();
        SVNPropertiesManager.validateRevisionProperties(revisionProperties);
        String commitMessage = ((SvnCommit)this.getOperation()).getCommitMessage();
        if (((SvnCommit)this.getOperation()).getCommitHandler() != null) {
            ArrayList<SvnCommitItem> items = new ArrayList<SvnCommitItem>();
            for (SVNURL rootUrl : packet.getRepositoryRoots()) {
                items.addAll(packet.getItems(rootUrl));
            }
            SvnCommitItem[] itemsArray = items.toArray(new SvnCommitItem[items.size()]);
            commitMessage = ((SvnCommit)this.getOperation()).getCommitHandler().getCommitMessage(commitMessage, itemsArray);
            if (commitMessage == null) {
                return SVNCommitInfo.NULL;
            }
            revisionProperties = ((SvnCommit)this.getOperation()).getCommitHandler().getRevisionProperties(commitMessage, itemsArray, revisionProperties);
        }
        commitMessage = commitMessage == null ? "" : SVNCommitUtil.validateCommitMessage(commitMessage);
        boolean keepLocks = ((SvnCommit)this.getOperation()).isKeepLocks();
        SVNException bumpError = null;
        SVNCommitInfo info = null;
        try {
            SVNURL repositoryRootUrl = packet.getRepositoryRoots().iterator().next();
            if (packet.isEmpty(repositoryRootUrl)) {
                SVNCommitInfo sVNCommitInfo = SVNCommitInfo.NULL;
                return sVNCommitInfo;
            }
            TreeMap<String, SvnCommitItem> committables = new TreeMap<String, SvnCommitItem>();
            HashMap<File, SvnChecksum> md5Checksums = new HashMap<File, SvnChecksum>();
            HashMap<File, SvnChecksum> sha1Checksums = new HashMap<File, SvnChecksum>();
            SVNURL baseURL = SvnNgCommitUtil.translateCommitables(packet.getItems(repositoryRootUrl), committables);
            Map<String, String> lockTokens = SvnNgCommitUtil.translateLockTokens(packet.getLockTokens(), baseURL);
            SvnCommitItem firstItem = packet.getItems(repositoryRootUrl).iterator().next();
            SVNRepository repository = this.getRepositoryAccess().createRepository(baseURL, firstItem.getPath());
            SVNCommitMediator17 mediator = new SVNCommitMediator17(context, committables);
            ISVNEditor commitEditor = null;
            try {
                commitEditor = repository.getCommitEditor(commitMessage, lockTokens, keepLocks, revisionProperties, mediator);
                SVNCommitter17 committer = new SVNCommitter17(context, committables, repositoryRootUrl, mediator.getTmpFiles(), md5Checksums, sha1Checksums);
                SVNCommitUtil.driveCommitEditor(committer, committables.keySet(), commitEditor, -1L);
                committer.sendTextDeltas(commitEditor);
                info = commitEditor.closeEdit();
                commitEditor = null;
                if (info.getErrorMessage() == null || info.getErrorMessage().getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                    SvnCommittedQueue queue = new SvnCommittedQueue();
                    try {
                        for (SvnCommitItem item : packet.getItems(repositoryRootUrl)) {
                            this.postProcessCommitItem(queue, item, ((SvnCommit)this.getOperation()).isKeepChangelists(), ((SvnCommit)this.getOperation()).isKeepLocks(), (SvnChecksum)sha1Checksums.get(item.getPath()));
                        }
                        this.processCommittedQueue(queue, info.getNewRevision(), info.getDate(), info.getAuthor());
                        this.deleteDeleteFiles(committer, ((SvnCommit)this.getOperation()).getCommitParameters());
                    }
                    catch (SVNException e) {
                        bumpError = e;
                        throw e;
                    }
                    finally {
                        this.sleepForTimestamp();
                    }
                }
                this.handleEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, SVNEventAction.COMMIT_COMPLETED, null, null, -1L, -1L));
            }
            catch (SVNException e) {
                if (e instanceof SVNCancelException) {
                    throw e;
                }
                SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
                info = new SVNCommitInfo(-1L, null, null, err);
                this.handleEvent(SVNEventFactory.createErrorEvent(err, SVNEventAction.COMMIT_COMPLETED), -1.0);
                if (packet.getRepositoryRoots().size() == 1) {
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                if (commitEditor != null) {
                    try {
                        commitEditor.abortEdit();
                    }
                    catch (SVNException e) {
                        SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, e, Level.WARNING);
                    }
                }
                for (File tmpFile : mediator.getTmpFiles()) {
                    SVNFileUtil.deleteFile(tmpFile);
                }
            }
        }
        finally {
            if (bumpError == null) {
                packet.dispose();
            }
        }
        return info;
    }

    private void postProcessCommitItem(SvnCommittedQueue queue, SvnCommitItem item, boolean keepChangelists, boolean keepLocks, SvnChecksum sha1Checksum) throws SVNException {
        boolean removeLock = !keepLocks && item.hasFlag(32);
        Map<String, SVNPropertyValue> wcPropChanges = item.getIncomingProperties();
        SVNProperties wcProps = null;
        if (wcPropChanges != null) {
            try {
                wcProps = this.getWcContext().getDb().getBaseDavCache(item.getPath());
            }
            catch (SVNException e) {
                // empty catch block
            }
            if (wcProps == null) {
                wcProps = new SVNProperties();
            }
            for (String name : wcPropChanges.keySet()) {
                SVNPropertyValue pv = wcPropChanges.get(name);
                if (pv == null) {
                    wcProps.remove(name);
                    continue;
                }
                wcProps.put(name, pv);
            }
        }
        this.queueCommitted(queue, item.getPath(), false, wcProps, removeLock, !keepChangelists, sha1Checksum);
    }

    @Override
    public SVNNodeKind getUrlKind(SVNURL url, long revision) throws SVNException {
        return this.getRepositoryAccess().createRepository(url, null).checkPath("", revision);
    }

    private Collection<File> determineLockTargets(File baseDirectory, Collection<String> targets) throws SVNException {
        HashMap<File, HashSet<File>> wcItems = new HashMap<File, HashSet<File>>();
        for (String t : targets) {
            File target = SVNFileUtil.createFilePath(baseDirectory, t);
            File wcRoot = null;
            try {
                wcRoot = this.getWcContext().getDb().getWCRoot(target);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw e;
            }
            HashSet<File> wcTargets = (HashSet<File>)wcItems.get(wcRoot);
            if (wcTargets == null) {
                wcTargets = new HashSet<File>();
                wcItems.put(wcRoot, wcTargets);
            }
            wcTargets.add(target);
        }
        HashSet<File> lockTargets = new HashSet<File>();
        for (File wcRoot : wcItems.keySet()) {
            Collection wcTargets = (Collection)wcItems.get(wcRoot);
            if (wcTargets.size() == 1) {
                if (wcRoot.equals(wcTargets.iterator().next())) {
                    lockTargets.add(wcRoot);
                    continue;
                }
                lockTargets.add(SVNFileUtil.getParentFile((File)wcTargets.iterator().next()));
                continue;
            }
            if (wcTargets.size() <= 1) continue;
            lockTargets.add(wcRoot);
        }
        return lockTargets;
    }

    @Override
    public void disposeCommitPacket(Object lockingContext) throws SVNException {
        if (!(lockingContext instanceof Collection)) {
            return;
        }
        Collection lockedPaths = (Collection)lockingContext;
        for (File lockedPath : lockedPaths) {
            try {
                this.getWcContext().releaseWriteLock(lockedPath);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                throw e;
            }
        }
        this.getWcContext().close();
    }

    private void queueCommitted(SvnCommittedQueue queue, File localAbsPath, boolean recurse, SVNProperties wcPropChanges, boolean removeLock, boolean removeChangelist, SvnChecksum sha1Checksum) {
        SvnCommittedQueueItem cqi = new SvnCommittedQueueItem();
        cqi.localAbspath = localAbsPath;
        cqi.recurse = recurse;
        cqi.noUnlock = !removeLock;
        cqi.keepChangelist = !removeChangelist;
        cqi.sha1Checksum = sha1Checksum;
        cqi.newDavCache = wcPropChanges;
        queue.queue.put(localAbsPath, cqi);
    }

    private void processCommittedQueue(SvnCommittedQueue queue, long newRevision, Date revDate, String revAuthor) throws SVNException {
        HashSet<File> roots = new HashSet<File>();
        for (SvnCommittedQueueItem cqi : queue.queue.values()) {
            this.processCommittedInternal(cqi.localAbspath, cqi.recurse, true, newRevision, new SVNDate(revDate.getTime(), 0), revAuthor, cqi.newDavCache, cqi.noUnlock, cqi.keepChangelist, cqi.sha1Checksum, queue);
            File root = this.getWcContext().getDb().getWCRoot(cqi.localAbspath);
            roots.add(root);
        }
        for (File root : roots) {
            this.getWcContext().wqRun(root);
        }
        queue.queue.clear();
    }

    private void processCommittedInternal(File localAbspath, boolean recurse, boolean topOfRecurse, long newRevision, SVNDate revDate, String revAuthor, SVNProperties newDavCache, boolean noUnlock, boolean keepChangelist, SvnChecksum sha1Checksum, SvnCommittedQueue queue) throws SVNException {
        this.processCommittedLeaf(localAbspath, !topOfRecurse, newRevision, revDate, revAuthor, newDavCache, noUnlock, keepChangelist, sha1Checksum);
    }

    private void processCommittedLeaf(File localAbspath, boolean viaRecurse, long newRevnum, SVNDate newChangedDate, String newChangedAuthor, SVNProperties newDavCache, boolean noUnlock, boolean keepChangelist, SvnChecksum checksum) throws SVNException {
        long newChangedRev = newRevnum;
        assert (SVNFileUtil.isAbsolute(localAbspath));
        Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveWork);
        File admAbspath = nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir ? localAbspath : SVNFileUtil.getFileDir(localAbspath);
        this.getWcContext().writeCheck(admAbspath);
        if (nodeInfo.get(StructureFields.NodeInfo.status) == ISVNWCDb.SVNWCDbStatus.Deleted) {
            this.getWcContext().getDb().opRemoveNode(localAbspath, nodeInfo.is(StructureFields.NodeInfo.haveBase) && !viaRecurse ? newRevnum : -1L, (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind)));
            nodeInfo.release();
            return;
        }
        if (nodeInfo.get(StructureFields.NodeInfo.status) == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            nodeInfo.release();
            return;
        }
        SVNSkel workItem = null;
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
        if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
            if (checksum == null) {
                checksum = (SvnChecksum)nodeInfo.get(StructureFields.NodeInfo.checksum);
                if (viaRecurse && !nodeInfo.is(StructureFields.NodeInfo.propsMod)) {
                    Structure<StructureFields.NodeInfo> moreInfo = this.getWcContext().getDb().readInfo(localAbspath, StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.changedDate, StructureFields.NodeInfo.changedAuthor);
                    newChangedRev = moreInfo.lng(StructureFields.NodeInfo.changedRev);
                    newChangedDate = (SVNDate)moreInfo.get(StructureFields.NodeInfo.changedDate);
                    newChangedAuthor = (String)moreInfo.get(StructureFields.NodeInfo.changedAuthor);
                    moreInfo.release();
                }
            }
            workItem = this.getWcContext().wqBuildFileCommit(localAbspath, nodeInfo.is(StructureFields.NodeInfo.propsMod));
        }
        this.getWcContext().getDb().globalCommit(localAbspath, newRevnum, newChangedRev, newChangedDate, newChangedAuthor, checksum, null, newDavCache, keepChangelist, noUnlock, workItem);
    }

    private static class SvnCommittedQueue {
        public Map<File, SvnCommittedQueueItem> queue = new TreeMap<File, SvnCommittedQueueItem>(SVNCommitUtil.FILE_COMPARATOR);

        private SvnCommittedQueue() {
        }
    }

    private static class SvnCommittedQueueItem {
        public File localAbspath;
        public boolean recurse;
        public boolean noUnlock;
        public boolean keepChangelist;
        public SvnChecksum sha1Checksum;
        public SVNProperties newDavCache;

        private SvnCommittedQueueItem() {
        }
    }
}

