/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.netbeans.modules.versioning.util.options.CategoryRenderer;
import org.netbeans.modules.versioning.util.options.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AnnotationColorsPanel
extends JPanel
implements ActionListener,
FontsColorsController,
PropertyChangeListener {
    private boolean listen;
    private final HashMap<OptionsPanelColorProvider, VersioningSystemColors> vcsColors;
    private final Lookup.Result<OptionsPanelColorProvider> result;
    private final LookupListener vcsListener;
    private boolean changed;
    private JButton btnResetToDefaults;
    private JComboBox cbBackground;
    private JPanel containerPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lCategories;
    private JList versioningSystemsList;

    public AnnotationColorsPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_AnnotationColorsPanel.title"));
        this.result = Lookup.getDefault().lookupResult(OptionsPanelColorProvider.class);
        this.vcsColors = new HashMap();
        this.versioningSystemsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AnnotationColorsPanel.this.updateColorList();
            }
        });
        this.vcsListener = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                AnnotationColorsPanel.this.initSystems();
            }
        };
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.vcsListener, this.result));
        this.initSystems();
        ColorComboBox.init(this.cbBackground);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(6);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!AnnotationColorsPanel.this.listen) {
                    return;
                }
                AnnotationColorsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbBackground.addActionListener(this);
        this.btnResetToDefaults.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.versioningSystemsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setComponentOrientation(list.getComponentOrientation());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setText(((OptionsPanelColorProvider)value).getName());
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        });
        this.listen = true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getSource() == this.btnResetToDefaults) {
            this.resetToDefaults();
            this.refreshUI();
        } else {
            this.updateData();
            this.changed = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if ("color".equals(evt.getPropertyName())) {
            this.updateData();
            this.changed = true;
        }
    }

    public void update(ColorModel colorModel) {
        if (!this.listen) {
            return;
        }
        this.listen = false;
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
        this.vcsColors.clear();
    }

    public void applyChanges() {
        for (Map.Entry<OptionsPanelColorProvider, VersioningSystemColors> e : this.vcsColors.entrySet()) {
            e.getValue().saveColors();
        }
        this.vcsColors.clear();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String currentProfile) {
        this.refreshUI();
    }

    public void deleteProfile(String profile) {
    }

    public JComponent getComponent() {
        return this;
    }

    private void updateData() {
        if (this.versioningSystemsList.getSelectedValue() == null) {
            return;
        }
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Color color = ColorComboBox.getColor(this.cbBackground);
        VersioningSystemColors colors = this.vcsColors.get((OptionsPanelColorProvider)this.versioningSystemsList.getSelectedValue());
        colors.setColor(index, color);
    }

    private void refreshUI() {
        if (this.versioningSystemsList.getSelectedValue() == null) {
            return;
        }
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.cbBackground.setEnabled(false);
            return;
        }
        this.cbBackground.setEnabled(true);
        List<AttributeSet> categories = this.getCategories();
        AttributeSet category = categories.get(this.lCategories.getSelectedIndex());
        this.listen = false;
        ColorComboBox.setColor(this.cbBackground, (Color)category.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private List<AttributeSet> getCategories() {
        OptionsPanelColorProvider provider = (OptionsPanelColorProvider)this.versioningSystemsList.getSelectedValue();
        VersioningSystemColors colors = this.vcsColors.get(provider);
        if (colors == null) {
            colors = new VersioningSystemColors(provider);
            this.vcsColors.put(provider, colors);
            this.updateColorList();
        }
        return colors.getColorAttributes();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.versioningSystemsList = new JList();
        this.jLabel2 = new JLabel();
        this.containerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lCategories = new JList();
        this.jLabel3 = new JLabel();
        this.cbBackground = new JComboBox();
        this.btnResetToDefaults = new JButton();
        this.versioningSystemsList.setModel(new DefaultListModel());
        this.versioningSystemsList.setSelectionMode(0);
        this.versioningSystemsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AnnotationColorsPanel.this.versioningSystemsListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.versioningSystemsList);
        this.jLabel2.setLabelFor(this.versioningSystemsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AnnotationColorsPanel.class).getString("AnnotationColorsPanel.jLabel2.text"));
        this.jLabel1.setLabelFor(this.lCategories);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AnnotationColorsPanel.class, (String)"AnnotationColorsPanel.jLabel1.text"));
        this.lCategories.setMinimumSize(new Dimension(100, 0));
        this.jScrollPane1.setViewportView(this.lCategories);
        this.jLabel3.setLabelFor(this.cbBackground);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AnnotationColorsPanel.class, (String)"AnnotationColorsPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnResetToDefaults, (String)NbBundle.getMessage(AnnotationColorsPanel.class, (String)"AnnotationColorsPanel.btnResetToDefaults.text"));
        this.btnResetToDefaults.setToolTipText(NbBundle.getMessage(AnnotationColorsPanel.class, (String)"AnnotationColorsPanel.btnResetToDefaults.TTtext"));
        GroupLayout containerPanelLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(containerPanelLayout);
        containerPanelLayout.setHorizontalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addContainerGap().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 511, Short.MAX_VALUE).addGap(20, 20, 20).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(12, 12, 12).addComponent(this.cbBackground, -2, 215, -2)).addComponent(this.btnResetToDefaults)))).addContainerGap()));
        containerPanelLayout.setVerticalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cbBackground, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnResetToDefaults).addContainerGap(328, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 389, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 422, Short.MAX_VALUE)).addContainerGap()));
    }

    private void versioningSystemsListValueChanged(ListSelectionEvent evt) {
    }

    private void initSystems() {
        final Collection providers = this.result.allInstances();
        Runnable inAWT = new Runnable(){

            @Override
            public void run() {
                ((DefaultListModel)AnnotationColorsPanel.this.versioningSystemsList.getModel()).removeAllElements();
                for (OptionsPanelColorProvider provider : providers) {
                    ((DefaultListModel)AnnotationColorsPanel.this.versioningSystemsList.getModel()).addElement(provider);
                }
                if (AnnotationColorsPanel.this.versioningSystemsList.getModel().getSize() >= 1) {
                    AnnotationColorsPanel.this.versioningSystemsList.setSelectedIndex(0);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            inAWT.run();
        } else {
            EventQueue.invokeLater(inAWT);
        }
    }

    private void updateColorList() {
        if (this.versioningSystemsList.getSelectedValue() == null) {
            this.lCategories.setEnabled(false);
            this.lCategories.setListData(new Object[0]);
            return;
        }
        this.lCategories.setEnabled(true);
        this.lCategories.setListData(new Vector<AttributeSet>(this.getCategories()));
        this.lCategories.setSelectedIndex(0);
    }

    private void resetToDefaults() {
        OptionsPanelColorProvider provider = (OptionsPanelColorProvider)this.versioningSystemsList.getSelectedValue();
        VersioningSystemColors colors = this.vcsColors.get(provider);
        if (colors != null) {
            colors.resetToDefaults();
            this.changed = true;
        }
    }

    private static class VersioningSystemColors {
        private final Map<String, Color[]> colors;
        private boolean changed;
        private ArrayList<AttributeSet> colorAttributes;
        private final OptionsPanelColorProvider provider;

        public VersioningSystemColors(OptionsPanelColorProvider provider) {
            this.colors = provider.getColors();
            if (this.colors == null) {
                throw new NullPointerException("Null colors for " + provider);
            }
            this.provider = provider;
        }

        public void saveColors() {
            if (this.changed) {
                HashMap<String, Color> colorsToSave = new HashMap<String, Color>(this.colors.size());
                for (Map.Entry<String, Color[]> e : this.colors.entrySet()) {
                    colorsToSave.put(e.getKey(), e.getValue()[0]);
                }
                this.provider.colorsChanged(colorsToSave);
            }
        }

        public synchronized List<AttributeSet> getColorAttributes() {
            ArrayList<AttributeSet> attrs = this.colorAttributes;
            if (attrs == null) {
                attrs = new ArrayList(this.colors.size());
                for (Map.Entry<String, Color[]> e : this.colors.entrySet()) {
                    SimpleAttributeSet sas = new SimpleAttributeSet();
                    StyleConstants.setBackground(sas, e.getValue()[0]);
                    sas.addAttribute(StyleConstants.NameAttribute, e.getKey());
                    sas.addAttribute(EditorStyleConstants.DisplayName, e.getKey());
                    attrs.add(sas);
                }
                this.colorAttributes = attrs;
            }
            return attrs;
        }

        public void setColor(int index, Color color) {
            if (color == null) {
                return;
            }
            AttributeSet attr = this.colorAttributes.get(index);
            SimpleAttributeSet c = new SimpleAttributeSet(attr);
            if (attr != null) {
                c.addAttribute(StyleConstants.Background, color);
            } else {
                c.removeAttribute(StyleConstants.Background);
            }
            this.colorAttributes.set(index, c);
            Color[] savedColor = this.colors.get((String)c.getAttribute(StyleConstants.NameAttribute));
            savedColor[0] = color;
            this.changed = true;
        }

        public synchronized void resetToDefaults() {
            for (Map.Entry<String, Color[]> e : this.colors.entrySet()) {
                e.getValue()[0] = e.getValue()[1];
            }
            this.colorAttributes = null;
            this.changed = true;
        }
    }
}

