/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class SimpleLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SimpleLookup.class.getName());
    protected final Object dataSetLock = new Object();
    private final List<AbstractResult> results = new CopyOnWriteArrayList<AbstractResult>();
    private final Map<Lookup.Template, AbstractResult> resultsCache = new HashMap<Lookup.Template, AbstractResult>(20, 0.75f);
    private Object[] data = new Object[0];

    public void setData(Object ... data) {
        this.validateData(data);
        data = this.rectifyData(data);
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
        this.setValidatedData(data);
    }

    protected void validateData(Object[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
    }

    protected Object[] rectifyData(Object[] data) {
        return CollectionUtils.removeItem(CollectionUtils.removeDuplicates(data), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidatedData(Object[] data) {
        Object object = this.dataSetLock;
        synchronized (object) {
            this.setDataImpl(data);
        }
    }

    protected final void setDataImpl(Object[] data) {
        if (!Thread.holdsLock(this.dataSetLock)) {
            throw new IllegalStateException("This method must be called with the dataSetLock held being held by the current thread.");
        }
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
        this.data = data;
        this.dataChanged();
    }

    private void dataChanged() {
        LOG.log(Level.FINER, "dataChanged()");
        this.notifyResults();
    }

    public <T> T lookup(Class<T> clazz) {
        Object[] currData;
        LOG.log(Level.FINER, "lookup ({0})", clazz.getName());
        for (Object o : currData = this.data) {
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        AbstractResult<T> result;
        if (template.getId() != null) {
            return new EmptyResult();
        }
        List<AbstractResult> list = this.results;
        synchronized (list) {
            result = this.resultsCache.get(template);
            if (result == null) {
                result = this.createLookupResult(template);
                this.resultsCache.put(template, result);
                this.results.add(result);
            }
        }
        return result;
    }

    private <T> AbstractResult<T> createLookupResult(Lookup.Template<T> template) {
        Class templateType = template.getType();
        Object templateInstance = template.getInstance();
        assert (template.getId() == null);
        AbstractResult result = templateInstance == null ? (templateType == null ? new AllResult() : new TypeResult(templateType)) : (templateType == null ? new InstanceResult<Object>(templateInstance) : new TypeInstanceResult<Object>(templateType, templateInstance));
        return result;
    }

    private void notifyResults() {
        for (AbstractResult result : this.results) {
            result.dataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<AbstractResult> list = this.results;
        synchronized (list) {
            this.resultsCache.clear();
        }
    }

    abstract class AbstractResult<T>
    extends Lookup.Result<T> {
        private final LookupListener[] listenersArray = new LookupListener[0];
        private final LookupEvent lookupEvent = new LookupEvent((Lookup.Result)this);
        private final Set<LookupListener> listeners = Collections.synchronizedSet(new LinkedHashSet());
        protected Collection<? extends T> allInstances;
        protected Collection<? extends Lookup.Item<T>> allItems;
        protected Set<Class<? extends T>> allClasses;

        AbstractResult() {
        }

        public Collection<? extends T> allInstances() {
            Collection<? extends T> currentInstances = this.allInstances;
            if (currentInstances != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "allInstances({0}) - cache HIT", this.paramString());
                }
                return currentInstances;
            }
            this.allInstances = this.allInstancesImpl();
            return this.allInstances;
        }

        public Collection<? extends Lookup.Item<T>> allItems() {
            Collection<? extends Lookup.Item<T>> currentItems = this.allItems;
            if (currentItems != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "allItems({0}) - cache HIT", this.paramString());
                }
                return currentItems;
            }
            this.allItems = this.allItemsImpl();
            return this.allItems;
        }

        public Set<Class<? extends T>> allClasses() {
            Set<Class<? extends T>> currentClasses = this.allClasses;
            if (currentClasses != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "allClasses({0}) - cache HIT", this.paramString());
                }
                return currentClasses;
            }
            this.allClasses = this.allClassesImpl();
            return this.allClasses;
        }

        protected abstract Collection<? extends T> allInstancesImpl();

        protected abstract Collection<? extends Lookup.Item<T>> allItemsImpl();

        protected abstract Set<Class<? extends T>> allClassesImpl();

        public void addLookupListener(LookupListener l) {
            this.listeners.add(l);
        }

        public void removeLookupListener(LookupListener l) {
            this.listeners.remove(l);
        }

        protected LookupListener[] getListeners() {
            return this.listeners.toArray(this.listenersArray);
        }

        protected void notifyListeners(LookupListener[] listeners) {
            for (LookupListener l : listeners) {
                l.resultChanged(this.lookupEvent);
            }
        }

        protected void dataChanged() {
            LookupListener[] currListeners = this.getListeners();
            boolean resultChanged = this.updateData(currListeners.length != 0);
            if (resultChanged) {
                this.allInstances = null;
                this.allItems = null;
                this.allClasses = null;
                if (currListeners.length != 0) {
                    this.notifyListeners(currListeners);
                }
            }
        }

        protected abstract boolean updateData(boolean var1);

        protected abstract String paramString();
    }

    class AllResult<T>
    extends AbstractResult<T> {
        protected T[] instances;

        AllResult() {
        }

        @Override
        protected Collection<? extends T> allInstancesImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allInstances({0}) - cache miss", this.paramString());
            }
            return CollectionUtils.unmodifiableList(this.getInstances());
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItemsImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allItems({0}) - cache miss", this.paramString());
            }
            T[] insts = this.getInstances();
            Lookup.Item[] items = new Lookup.Item[insts.length];
            for (int i = 0; i < items.length; ++i) {
                items[i] = new LookupItem<T>(insts[i]);
            }
            return CollectionUtils.unmodifiableList(items);
        }

        @Override
        protected Set<Class<? extends T>> allClassesImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allClasses({0}) - cache miss", this.paramString());
            }
            T[] insts = this.getInstances();
            Class[] classes = new Class[insts.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = insts[i].getClass();
            }
            return CollectionUtils.unmodifiableSet(classes);
        }

        protected T[] getInstances() {
            T[] currentInstances = this.instances;
            if (currentInstances != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "getInstances({0}) - cache HIT", this.paramString());
                }
                return currentInstances;
            }
            this.instances = this.getInstancesImpl();
            return this.instances;
        }

        protected T[] getInstancesImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "getInstances({0}) - cache miss", this.paramString());
            }
            return SimpleLookup.this.data;
        }

        @Override
        protected boolean updateData(boolean listenersRegistered) {
            boolean dataChanged;
            Object[] newInstances;
            Object[] oldInstances = this.instances;
            if (listenersRegistered) {
                newInstances = this.getInstancesImpl();
                dataChanged = !CollectionUtils.containSameObjects(oldInstances, newInstances);
            } else {
                dataChanged = true;
                newInstances = null;
            }
            this.instances = newInstances;
            return dataChanged;
        }

        @Override
        protected String paramString() {
            return "AllResults";
        }
    }

    static class EmptyResult<T>
    extends Lookup.Result<T> {
        EmptyResult() {
        }

        public void addLookupListener(LookupListener l) {
        }

        public void removeLookupListener(LookupListener l) {
        }

        public Collection<? extends T> allInstances() {
            return Collections.emptyList();
        }
    }

    class InstanceResult<T>
    extends AbstractResult<T> {
        protected final T UNKNOWN = new Object();
        protected final T requestedInstance;
        protected T instance = this.UNKNOWN;

        InstanceResult(T requestedInstance) {
            if (requestedInstance == null) {
                throw new IllegalArgumentException("null instance");
            }
            this.requestedInstance = requestedInstance;
        }

        @Override
        protected Collection<? extends T> allInstancesImpl() {
            T inst;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allInstances({0}) - cache miss", this.paramString());
            }
            return (inst = this.getInstance()) != null ? Collections.singletonList(inst) : Collections.emptyList();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItemsImpl() {
            T inst;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allItems({0}) - cache miss", this.paramString());
            }
            LookupItem<T> item = (inst = this.getInstance()) != null ? new LookupItem<T>(inst) : null;
            return item != null ? Collections.singletonList(item) : Collections.emptyList();
        }

        @Override
        protected Set<Class<? extends T>> allClassesImpl() {
            T inst;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "allClasses({0}) - cache miss", this.paramString());
            }
            Class<?> clazz = (inst = this.getInstance()) != null ? inst.getClass() : null;
            return clazz != null ? Collections.singleton(clazz) : Collections.emptySet();
        }

        protected T getInstance() {
            T currentInstance = this.instance;
            if (currentInstance != this.UNKNOWN) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "getInstance({0}) - cache HIT", this.paramString());
                }
                return currentInstance;
            }
            this.instance = this.getInstanceImpl();
            return this.instance;
        }

        protected T getInstanceImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "getInstance({0}) - cache miss", this.paramString());
            }
            Object[] currData = SimpleLookup.this.data;
            Object result = null;
            for (Object o : currData) {
                if (o != this.requestedInstance) continue;
                result = o;
                break;
            }
            return (T)result;
        }

        @Override
        protected boolean updateData(boolean listenersRegistered) {
            boolean dataChanged;
            T newInstance;
            T oldInstance = this.instance;
            if (listenersRegistered) {
                newInstance = this.getInstanceImpl();
                dataChanged = newInstance != oldInstance;
            } else {
                dataChanged = true;
                newInstance = this.UNKNOWN;
            }
            this.instance = newInstance;
            return dataChanged;
        }

        @Override
        protected String paramString() {
            return "InstanceResult(0x" + Integer.toHexString(System.identityHashCode(this.requestedInstance)) + ')';
        }
    }

    static class LookupItem<T>
    extends Lookup.Item<T> {
        private final T instance;

        LookupItem(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            return this.instance;
        }

        public Class<? extends T> getType() {
            return this.instance.getClass();
        }

        public String getId() {
            return null;
        }

        public String getDisplayName() {
            return this.instance.toString();
        }
    }

    class TypeInstanceResult<T>
    extends InstanceResult<T> {
        protected final Class<T> requestedType;

        TypeInstanceResult(Class<T> requestedType, T requestedInstance) {
            super(requestedInstance);
            this.requestedType = requestedType;
        }

        @Override
        protected T getInstanceImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "getInstance({0}) - cache miss", this.paramString());
            }
            Object[] currData = SimpleLookup.this.data;
            Object result = null;
            for (Object o : currData) {
                if (o != this.requestedInstance) continue;
                if (!this.requestedType.isInstance(o)) break;
                result = o;
                break;
            }
            return (T)result;
        }

        @Override
        protected String paramString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("TypeInstanceResult(").append(this.requestedType.getSimpleName()).append(", 0x").append(Integer.toHexString(System.identityHashCode(this.requestedInstance))).append(')');
            return buf.toString();
        }
    }

    class TypeResult<T>
    extends AllResult<T> {
        protected final Class<T> requestedType;

        TypeResult(Class<T> requestedType) {
            this.requestedType = requestedType;
        }

        @Override
        protected T[] getInstancesImpl() {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "getInstances({0}) - cache miss", this.paramString());
            }
            Object[] currData = SimpleLookup.this.data;
            Object[] result = new Object[currData.length];
            int count = 0;
            for (Object o : currData) {
                if (!this.requestedType.isInstance(o)) continue;
                result[count++] = o;
            }
            return CollectionUtils.shortenArray(result, count);
        }

        @Override
        protected String paramString() {
            return "TypeResult(" + this.requestedType.getSimpleName() + ')';
        }
    }
}

