/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class SummaryCellRenderer
implements ListCellRenderer {
    private static final double DARKEN_FACTOR = 0.95;
    private static final double DARKEN_FACTOR_UNINTERESTING = 0.975;
    private final AbstractSummaryView summaryView;
    private final Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap;
    private final VCSHyperlinkSupport linkerSupport;
    private Color selectionBackgroundColor;
    private Color selectionBackground;
    private Color selectionForeground;
    private ActionRenderer ar;
    private MoreRevisionsRenderer mr;
    private DefaultListCellRenderer dlcr;
    private ListCellRenderer remainingFilesRenderer;
    private AttributeSet searchHiliteAttrs;
    private static final Icon ICON_COLLAPSED = UIManager.getIcon("Tree.collapsedIcon");
    private static final Icon ICON_EXPANDED = UIManager.getIcon("Tree.expandedIcon");
    private static final int INDENT = ICON_EXPANDED.getIconWidth() + 3;
    private static final JLabel EMPTY_SPACE_LABEL = new JLabel();
    private static final String PREFIX_PATH_FROM = NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_SummaryCellRenderer.pathPrefixFrom");
    private Collection<VCSHyperlinkProvider> hpInstances;
    Map<Object, ListCellRenderer> renderers;
    private static final String FIELDS_SEPARATOR = "      ";
    private static final String LINK_STRING = "...";
    private static final int LINK_STRING_LEN = "...".length();

    public SummaryCellRenderer(AbstractSummaryView summaryView, VCSHyperlinkSupport linkerSupport, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap) {
        this.selectionBackground = this.selectionBackgroundColor = new JList().getSelectionBackground();
        this.selectionForeground = new JList().getSelectionForeground();
        this.ar = new ActionRenderer();
        this.mr = new MoreRevisionsRenderer();
        this.dlcr = new DefaultListCellRenderer();
        this.remainingFilesRenderer = new RemainingFilesRenderer();
        this.renderers = new WeakHashMap<Object, ListCellRenderer>();
        this.summaryView = summaryView;
        this.kenaiUsersMap = kenaiUsersMap;
        this.linkerSupport = linkerSupport;
        this.searchHiliteAttrs = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getFontColors("highlight-search");
    }

    private static Color darker(Color c) {
        return SummaryCellRenderer.darker(c, 0.95);
    }

    private static Color darkerUninteresting(Color c) {
        return SummaryCellRenderer.darker(c, 0.975);
    }

    private static Color darker(Color c, double factor) {
        return new Color(Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0));
    }

    private static Color lessInteresting(Color c, Color bg) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r += (bg.getRed() - r) / 5;
        g += (bg.getGreen() - g) / 5;
        b += (bg.getBlue() - b) / 5;
        return new Color(r, g, b);
    }

    private static String getColorString(Color c) {
        return "#" + SummaryCellRenderer.getHex(c.getRed()) + SummaryCellRenderer.getHex(c.getGreen()) + SummaryCellRenderer.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof AbstractSummaryView.RevisionItem) {
            ListCellRenderer ren = this.renderers.get(value);
            if (ren == null) {
                ren = new RevisionRenderer();
                this.renderers.put(value, ren);
            }
            return ren.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.EventItem) {
            ListCellRenderer ren = this.renderers.get(value);
            if (ren == null) {
                ren = new EventRenderer();
                this.renderers.put(value, ren);
            }
            return ren.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.LoadingEventsItem) {
            Component comp = this.dlcr.getListCellRendererComponent((JList<?>)list, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_LoadingEvents"), index, selected, hasFocus);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 0));
            }
            return comp;
        }
        if (value instanceof AbstractSummaryView.ShowAllEventsItem) {
            return this.remainingFilesRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.ActionsItem) {
            return this.ar.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.MoreRevisionsItem) {
            return this.mr.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        return EMPTY_SPACE_LABEL;
    }

    private int getMaxPathWidth(JList list, AbstractSummaryView.RevisionItem revision, Graphics g) {
        assert (revision.revisionExpanded);
        assert (EventQueue.isDispatchThread());
        Collection<AbstractSummaryView.LogEntry.Event> events = ((AbstractSummaryView.LogEntry)revision.getUserData()).isEventsInitialized() ? ((AbstractSummaryView.LogEntry)revision.getUserData()).getEvents() : ((AbstractSummaryView.LogEntry)revision.getUserData()).getDummyEvents();
        int maxWidth = -1;
        block0: for (AbstractSummaryView.LogEntry.Event event : events) {
            int i = 0;
            for (String path : SummaryCellRenderer.getInterestingPaths(event)) {
                if (++i == 2) {
                    if (path == null) continue block0;
                    path = PREFIX_PATH_FROM + path;
                }
                StringBuilder sb = new StringBuilder(event.getAction()).append(" ").append(path);
                FontMetrics fm = list.getFontMetrics(list.getFont());
                Rectangle2D rect = fm.getStringBounds(sb.toString(), g);
                maxWidth = Math.max(maxWidth, (int)rect.getWidth() + 1);
            }
        }
        return maxWidth;
    }

    public Collection<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpInstances == null) {
            Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
            this.hpInstances = hpResult.allInstances();
        }
        return this.hpInstances;
    }

    public VCSKenaiAccessor.KenaiUser getKenaiUser(String author) {
        VCSKenaiAccessor.KenaiUser kenaiUser = null;
        if (this.kenaiUsersMap != null && author != null && !author.isEmpty()) {
            kenaiUser = this.kenaiUsersMap.get(author);
        }
        return kenaiUser;
    }

    private static String[] getInterestingPaths(AbstractSummaryView.LogEntry.Event event) {
        ArrayList<String> paths = new ArrayList<String>(2);
        String path = event.getPath();
        String original = event.getOriginalPath();
        paths.add(path);
        if (original != null && !path.equals(original)) {
            paths.add(original);
        }
        return paths.toArray(new String[paths.size()]);
    }

    static /* synthetic */ Color access$1100(Color x0, Color x1) {
        return SummaryCellRenderer.lessInteresting(x0, x1);
    }

    private class ActionHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Map<Component, Rectangle> bounds = Collections.emptyMap();
        private Map<Component, Action> labels;

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(Map<Component, Action> labels) {
            this.labels = labels;
            this.bounds = new HashMap<Component, Rectangle>(labels.size());
            for (Map.Entry<Component, Action> e : labels.entrySet()) {
                this.bounds.put(e.getKey(), e.getKey().getBounds());
            }
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                if (!e.getValue().contains(p)) continue;
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText((String)this.labels.get(e.getKey()).getValue("Name"));
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mouseClicked(Point p) {
            for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                if (!e.getValue().contains(p)) continue;
                Utils.setWaitCursor(true);
                try {
                    this.labels.get(e.getKey()).actionPerformed(new ActionEvent(this.labels.get(e.getKey()), 1001, null));
                }
                finally {
                    Utils.setWaitCursor(false);
                }
                return true;
            }
            return false;
        }
    }

    private class ActionRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private Map<Component, Action> labels;
        private final Map<String, JLabel> ACTION_LABELS = new HashMap<String, JLabel>();

        public ActionRenderer() {
            this.setLayout(new FlowLayout(0, 5, 0));
            this.setBorder(BorderFactory.createEmptyBorder(3, INDENT - 5, 5, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Action[] actions = ((AbstractSummaryView.LogEntry)((AbstractSummaryView.ActionsItem)value).getParent().getUserData()).getActions();
            this.id = ((AbstractSummaryView.ActionsItem)value).getItemId();
            this.removeAll();
            this.labels = new HashMap<Component, Action>(actions.length);
            Component comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"action\">ACTION_NAME</a>", index, isSelected, cellHasFocus);
            this.setBackground(comp.getBackground());
            for (Action a : actions) {
                JLabel label = this.getLabelFor((String)a.getValue("Name"), isSelected ? comp.getForeground() : null);
                label.setForeground(comp.getForeground());
                label.setBackground(comp.getBackground());
                label.setBorder(BorderFactory.createEmptyBorder());
                this.labels.put(label, a);
                this.add(label);
            }
            if (SummaryCellRenderer.this.linkerSupport.getLinker(ActionHyperlink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ActionHyperlink(), this.id);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ActionHyperlink link = SummaryCellRenderer.this.linkerSupport.getLinker(ActionHyperlink.class, this.id);
            if (link != null) {
                link.computeBounds(this.labels);
            }
        }

        private JLabel getLabelFor(String actionName, Color fontColor) {
            JLabel lbl = this.ACTION_LABELS.get(actionName);
            if (lbl == null) {
                lbl = new JLabel();
                this.ACTION_LABELS.put(actionName, lbl);
            }
            StringBuilder sb = new StringBuilder("<html><a href=\"action\">");
            if (fontColor == null) {
                sb.append(actionName);
            } else {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(fontColor)).append("\">").append(actionName).append("</font>");
            }
            sb.append("</a></html>");
            lbl.setText(sb.toString());
            return lbl;
        }
    }

    public class EventActionsLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.EventItem item;

        private EventActionsLink(AbstractSummaryView.EventItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(JButton button) {
            this.bounds = button.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowActions"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.item.actionsToPopup(p);
                return true;
            }
            return false;
        }
    }

    private class EventRenderer
    extends JPanel
    implements ListCellRenderer {
        private boolean lastSelection = false;
        private final JLabel pathLabel;
        private final JLabel actionLabel;
        private final JButton actionButton;
        private String id;
        private final String PATH_COLOR = SummaryCellRenderer.access$1200(SummaryCellRenderer.access$1100(UIManager.getColor("List.foreground"), UIManager.getColor("List.background")));

        public EventRenderer() {
            this.pathLabel = new JLabel();
            this.actionLabel = new JLabel();
            this.actionButton = new LinkButton(SummaryCellRenderer.LINK_STRING);
            this.actionButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            FlowLayout l = new FlowLayout(0, 0, 0);
            l.setAlignOnBaseline(true);
            this.setLayout(l);
            this.add(this.actionLabel);
            this.actionLabel.setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 10));
            this.add(this.pathLabel);
            this.add(this.actionButton);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AbstractSummaryView.EventItem item = (AbstractSummaryView.EventItem)value;
            if (this.pathLabel.getText().isEmpty() || this.lastSelection != selected) {
                Color backgroundColor;
                Color foregroundColor;
                this.lastSelection = selected;
                if (selected) {
                    foregroundColor = SummaryCellRenderer.this.selectionForeground;
                    backgroundColor = SummaryCellRenderer.this.selectionBackground;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                }
                this.id = item.getItemId();
                if (SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id) == null) {
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new EventActionsLink(item), this.id);
                }
                this.pathLabel.setFont(list.getFont());
                this.pathLabel.setForeground(foregroundColor);
                this.pathLabel.setBackground(backgroundColor);
                this.actionLabel.setBackground(backgroundColor);
                this.setBackground(backgroundColor);
                StringBuilder sb = new StringBuilder("<html><body>");
                sb.append("<b>");
                String action = ((AbstractSummaryView.LogEntry.Event)item.getUserData()).getAction();
                String color = SummaryCellRenderer.this.summaryView.getActionColors().get(action);
                if (color != null && !selected) {
                    sb.append("<font color=\"").append(color).append("\">").append(action).append("</font>");
                } else {
                    this.actionLabel.setForeground(foregroundColor);
                    sb.append(action);
                }
                sb.append("</b></body></html>");
                this.actionLabel.setText(sb.toString());
                sb = new StringBuilder("<html><body>");
                int i = 0;
                for (String path : SummaryCellRenderer.getInterestingPaths((AbstractSummaryView.LogEntry.Event)item.getUserData())) {
                    if (++i == 2 && path == null) continue;
                    int idx = path.lastIndexOf("/");
                    if (i == 2) {
                        sb.append("<br>").append(PREFIX_PATH_FROM);
                    }
                    if (idx < 0 || selected) {
                        sb.append(path);
                        continue;
                    }
                    sb.append("<font color=\"").append(this.PATH_COLOR).append("\">").append(path.substring(0, ++idx)).append("</font>");
                    sb.append(path.substring(idx, path.length()));
                }
                this.pathLabel.setText(sb.append("</body></html>").toString());
                int width = SummaryCellRenderer.this.getMaxPathWidth(list, item.getParent(), this.pathLabel.getGraphics());
                width = width + 15 + INDENT - this.actionLabel.getPreferredSize().width;
                this.pathLabel.setPreferredSize(new Dimension(width, this.pathLabel.getPreferredSize().height));
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            EventActionsLink link = SummaryCellRenderer.this.linkerSupport.getLinker(EventActionsLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.actionButton);
            }
        }
    }

    public class ExpandLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.RevisionItem item;

        private ExpandLink(AbstractSummaryView.RevisionItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(JButton button) {
            this.bounds = button.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                if (this.item.revisionExpanded) {
                    component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_CollapseRevision"));
                } else {
                    component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ExpandRevision"));
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                ((AbstractSummaryView.LogEntry)this.item.getUserData()).cancelExpand();
                this.item.setExpanded(!this.item.revisionExpanded);
                SummaryCellRenderer.this.summaryView.itemChanged(p);
                return true;
            }
            return false;
        }
    }

    private class ExpandMsgHyperlink
    extends VCSHyperlinkSupport.StyledDocumentHyperlink {
        private Rectangle bounds;
        private final int startoffset;
        private final AbstractSummaryView.RevisionItem item;
        private final String revision;

        public ExpandMsgHyperlink(AbstractSummaryView.RevisionItem item, int startoffset, String revision) {
            this.startoffset = startoffset;
            this.revision = revision;
            this.item = item;
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ExpandCommitMessage"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.item.messageExpanded = true;
                SummaryCellRenderer.this.linkerSupport.remove(this, this.revision);
                SummaryCellRenderer.this.summaryView.itemChanged(p);
                return true;
            }
            return false;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle mtv = tui.modelToView(textPane, this.startoffset, Position.Bias.Forward);
                if (mtv == null) {
                    return;
                }
                Rectangle startr = mtv.getBounds();
                mtv = tui.modelToView(textPane, this.startoffset + LINK_STRING_LEN, Position.Bias.Backward);
                if (mtv == null) {
                    return;
                }
                Rectangle endr = mtv.getBounds();
                this.bounds = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            sd.insertString(this.startoffset, SummaryCellRenderer.LINK_STRING, style);
        }
    }

    private static class MessageTooltip
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle[] bounds;
        private final int start;
        private final int end;
        private final String text;

        private MessageTooltip(String text, int start, int end) {
            this.start = start;
            this.end = end;
            this.text = this.prepareText(text);
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && component.getToolTipText() == null) {
                for (Rectangle b : this.bounds) {
                    if (!b.contains(p)) continue;
                    component.setToolTipText(this.text);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            return false;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            try {
                int lastY = -1;
                Rectangle rec = null;
                LinkedList<Rectangle> rects = new LinkedList<Rectangle>();
                for (int pos = this.start; pos <= this.end; ++pos) {
                    Rectangle startr = tui.modelToView(textPane, pos, Position.Bias.Forward);
                    Rectangle endr = tui.modelToView(textPane, pos + 1, Position.Bias.Backward);
                    if (startr.y > lastY) {
                        rects.add(rec);
                        rec = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                        lastY = rec.y;
                        continue;
                    }
                    rec.setSize(rec.width + endr.x - startr.x, rec.height);
                }
                rects.add(rec);
                rects.remove(0);
                this.bounds = rects.toArray(new Rectangle[rects.size()]);
            }
            catch (BadLocationException ex) {
                this.bounds = null;
            }
        }

        private String prepareText(String text) {
            text = text.replaceAll("\n", "<br>");
            return "<html><body>" + text + "</body></html>";
        }
    }

    private class MoreRevisionsRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private final List<JLabel> labels;
        private final Color backgroundColor;
        private final JLabel more10Label;
        private final JLabel allLabel;
        private final JLabel more100Label;
        private final JLabel more50Label;
        private final Map<Component, String> tooltips;
        private final Map<Component, Integer> moreLabelValues;

        public MoreRevisionsRenderer() {
            this.setLayout(new FlowLayout(0, 0, 3));
            this.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, UIManager.getColor("List.background")));
            this.labels = new ArrayList<JLabel>();
            this.labels.add(new JLabel(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMore")));
            this.more10Label = new JLabel();
            this.labels.add(this.more10Label);
            this.labels.add(new JLabel("/"));
            this.more50Label = new JLabel();
            this.labels.add(this.more50Label);
            this.labels.add(new JLabel("/"));
            this.more100Label = new JLabel();
            this.labels.add(this.more100Label);
            this.labels.add(new JLabel("/"));
            this.allLabel = new JLabel();
            this.labels.add(this.allLabel);
            for (JLabel lbl : this.labels) {
                lbl.setBorder(BorderFactory.createEmptyBorder());
                this.add(lbl);
            }
            this.labels.get(0).setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 0));
            this.backgroundColor = SummaryCellRenderer.darker(UIManager.getColor("List.background"));
            this.moreLabelValues = new HashMap<Component, Integer>(4);
            this.moreLabelValues.put(this.more10Label, 10);
            this.moreLabelValues.put(this.more50Label, 50);
            this.moreLabelValues.put(this.more100Label, 100);
            this.moreLabelValues.put(this.allLabel, -1);
            this.tooltips = new HashMap<Component, String>(4);
            this.tooltips.put(this.more10Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show10MoreRevisions"));
            this.tooltips.put(this.more50Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show50MoreRevisions"));
            this.tooltips.put(this.more100Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show100MoreRevisions"));
            this.tooltips.put(this.allLabel, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMoreRevisionsAll"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.id = ((AbstractSummaryView.MoreRevisionsItem)value).getItemId();
            if (SummaryCellRenderer.this.linkerSupport.getLinker(MoreRevisionsHyperlink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new MoreRevisionsHyperlink(), this.id);
            }
            Component comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"more\">MORE</a>", index, isSelected, cellHasFocus);
            this.setLabelLinkText(this.more10Label, "10", isSelected ? comp.getForeground() : null);
            this.setLabelLinkText(this.more50Label, "50", isSelected ? comp.getForeground() : null);
            this.setLabelLinkText(this.more100Label, "100", isSelected ? comp.getForeground() : null);
            this.setLabelLinkText(this.allLabel, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_AllRevisions"), isSelected ? comp.getForeground() : null);
            for (JLabel lbl : this.labels) {
                lbl.setForeground(comp.getForeground());
                lbl.setBackground(isSelected ? comp.getBackground() : this.backgroundColor);
            }
            this.setBackground(isSelected ? comp.getBackground() : this.backgroundColor);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            MoreRevisionsHyperlink link = SummaryCellRenderer.this.linkerSupport.getLinker(MoreRevisionsHyperlink.class, this.id);
            if (link != null) {
                link.computeBounds();
            }
        }

        private JLabel setLabelLinkText(JLabel lbl, String text, Color fgColor) {
            StringBuilder sb = new StringBuilder("<html><a href=\"more\">");
            if (fgColor == null) {
                sb.append(text);
            } else {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(fgColor)).append("\">").append(text).append("</font>");
            }
            sb.append("</a></html>");
            lbl.setText(sb.toString());
            return lbl;
        }

        private class MoreRevisionsHyperlink
        extends VCSHyperlinkSupport.Hyperlink {
            private Map<Component, Rectangle> bounds = Collections.emptyMap();

            private MoreRevisionsHyperlink() {
            }

            @Override
            public void computeBounds(JTextPane textPane) {
            }

            public void computeBounds() {
                this.bounds = new HashMap<Component, Rectangle>(MoreRevisionsRenderer.this.labels.size());
                for (JLabel lbl : new JLabel[]{MoreRevisionsRenderer.this.more10Label, MoreRevisionsRenderer.this.more50Label, MoreRevisionsRenderer.this.more100Label, MoreRevisionsRenderer.this.allLabel}) {
                    this.bounds.put(lbl, lbl.getBounds());
                }
            }

            @Override
            public boolean mouseMoved(Point p, JComponent component) {
                for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                    if (!e.getValue().contains(p)) continue;
                    component.setCursor(Cursor.getPredefinedCursor(12));
                    component.setToolTipText((String)MoreRevisionsRenderer.this.tooltips.get(e.getKey()));
                    return true;
                }
                return false;
            }

            @Override
            public boolean mouseClicked(Point p) {
                for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                    if (!e.getValue().contains(p)) continue;
                    SummaryCellRenderer.this.summaryView.moreRevisions((Integer)MoreRevisionsRenderer.this.moreLabelValues.get(e.getKey()));
                    return true;
                }
                return false;
            }
        }
    }

    private class RemainingFilesRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private Component comp;

        public RemainingFilesRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, INDENT, 3, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.id = ((AbstractSummaryView.ShowAllEventsItem)value).getItemId();
            if (SummaryCellRenderer.this.linkerSupport.getLinker(ShowRemainingFilesLink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ShowRemainingFilesLink(((AbstractSummaryView.ShowAllEventsItem)value).getParent()), this.id);
            }
            StringBuilder sb = new StringBuilder("<html><a href=\"expand\">");
            String string = label = ((AbstractSummaryView.ShowAllEventsItem)value).getParent().isAllEventsExpanded() ? NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowLessFiles") : NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowAllFiles");
            if (isSelected) {
                Component c = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"expand\">ACTION_NAME</a>", index, isSelected, cellHasFocus);
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(c.getForeground())).append("\">").append(label).append("</font>");
            } else {
                sb.append(label);
            }
            sb.append("</a></html>");
            this.comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
            this.removeAll();
            this.add(this.comp);
            this.comp.setMaximumSize(this.comp.getPreferredSize());
            this.setBackground(this.comp.getBackground());
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ShowRemainingFilesLink link = SummaryCellRenderer.this.linkerSupport.getLinker(ShowRemainingFilesLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.comp);
            }
        }
    }

    private class RevisionRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private final Style selectedStyle;
        private final Style normalStyle;
        private final Style indentStyle;
        private final Style noindentStyle;
        private final Style issueHyperlinkStyle;
        private final Style linkStyle;
        private final Style authorStyle;
        private final Style hiliteStyle;
        private boolean lastSelection = false;
        private final JTextPane textPane;
        private final JButton expandButton;
        private String commitMessage = "";
        private boolean lastMessageExpanded;
        private boolean lastRevisionExpanded;
        private int lastWidth;
        private Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> lastHighlights;

        public RevisionRenderer() {
            SummaryCellRenderer.this.selectionForeground = new JList().getSelectionForeground();
            this.textPane = new JTextPane();
            this.expandButton = new LinkButton(ICON_COLLAPSED);
            this.expandButton.setBorder(BorderFactory.createEmptyBorder());
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, SummaryCellRenderer.this.selectionForeground);
            StyleConstants.setBackground(this.selectedStyle, SummaryCellRenderer.this.selectionBackground);
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.issueHyperlinkStyle = this.textPane.addStyle("issuehyperlink", this.normalStyle);
            StyleConstants.setForeground(this.issueHyperlinkStyle, Color.BLUE);
            StyleConstants.setUnderline(this.issueHyperlinkStyle, true);
            this.linkStyle = this.textPane.addStyle("link", this.normalStyle);
            StyleConstants.setForeground(this.linkStyle, Color.BLUE);
            StyleConstants.setBold(this.linkStyle, true);
            this.authorStyle = this.textPane.addStyle("author", this.normalStyle);
            StyleConstants.setForeground(this.authorStyle, Color.BLUE);
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color c = (Color)SummaryCellRenderer.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (c != null) {
                StyleConstants.setBackground(this.hiliteStyle, c);
            }
            if ((c = (Color)SummaryCellRenderer.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, c);
            }
            this.textPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, UIManager.getColor("List.background")));
            this.add(this.expandButton);
            this.expandButton.setMaximumSize(this.expandButton.getPreferredSize());
            this.expandButton.setMinimumSize(this.expandButton.getPreferredSize());
            this.add(this.textPane);
        }

        /*
         * WARNING - void declaration
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AbstractSummaryView.RevisionItem item = (AbstractSummaryView.RevisionItem)value;
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)item.getUserData();
            StyledDocument sd = this.textPane.getStyledDocument();
            Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights = SummaryCellRenderer.this.summaryView.getMaster().getSearchHighlights();
            if (sd.getLength() == 0 || selected != this.lastSelection || item.messageExpanded != this.lastMessageExpanded || item.revisionExpanded != this.lastRevisionExpanded || !((Object)highlights).equals(this.lastHighlights)) {
                Style style;
                Color backgroundColor;
                Color foregroundColor;
                this.lastSelection = selected;
                this.lastMessageExpanded = item.messageExpanded;
                this.lastRevisionExpanded = item.revisionExpanded;
                this.lastHighlights = highlights;
                if (selected) {
                    foregroundColor = SummaryCellRenderer.this.selectionForeground;
                    backgroundColor = SummaryCellRenderer.this.selectionBackground;
                    style = this.selectedStyle;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                    backgroundColor = entry.isLessInteresting() ? SummaryCellRenderer.darkerUninteresting(backgroundColor) : SummaryCellRenderer.darker(backgroundColor);
                    style = this.normalStyle;
                }
                this.textPane.setOpaque(false);
                this.textPane.setBackground(new Color(0, 0, 0, 0));
                this.setBackground(backgroundColor);
                if (item.revisionExpanded) {
                    this.expandButton.setIcon(ICON_EXPANDED);
                } else {
                    this.expandButton.setIcon(ICON_COLLAPSED);
                }
                this.id = item.getItemId();
                if (SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id) == null) {
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ExpandLink(item), this.id);
                }
                try {
                    int lineEnd;
                    void var14_24;
                    void var14_23;
                    void var14_20;
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    sd.remove(0, sd.getLength());
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                    sd.insertString(0, ((AbstractSummaryView.LogEntry)item.getUserData()).getRevision(), null);
                    sd.setCharacterAttributes(0, sd.getLength(), this.normalStyle, false);
                    if (!selected) {
                        for (AbstractSummaryView.LogEntry.RevisionHighlight revisionHighlight : ((AbstractSummaryView.LogEntry)item.getUserData()).getRevisionHighlights()) {
                            Style s = this.textPane.addStyle(null, this.normalStyle);
                            StyleConstants.setForeground(s, revisionHighlight.getForeground());
                            StyleConstants.setBackground(s, revisionHighlight.getBackground());
                            sd.setCharacterAttributes(revisionHighlight.getStart(), revisionHighlight.getLength(), s, false);
                        }
                        for (AbstractSummaryView.SummaryViewMaster.SearchHighlight searchHighlight : highlights) {
                            if (searchHighlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.REVISION) continue;
                            int doclen = sd.getLength();
                            String highlightMessage = searchHighlight.getSearchText();
                            String revisionText = ((AbstractSummaryView.LogEntry)item.getUserData()).getRevision().toLowerCase();
                            int idx = revisionText.indexOf(highlightMessage);
                            if (idx <= -1) continue;
                            sd.setCharacterAttributes(doclen - revisionText.length() + idx, highlightMessage.length(), this.hiliteStyle, false);
                        }
                    }
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR, style);
                    String author = entry.getAuthor();
                    VCSHyperlinkSupport.StyledDocumentHyperlink styledDocumentHyperlink = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, this.id);
                    if (styledDocumentHyperlink == null && (kenaiUser = SummaryCellRenderer.this.getKenaiUser(author)) != null) {
                        VCSHyperlinkSupport.AuthorLinker authorLinker = new VCSHyperlinkSupport.AuthorLinker(kenaiUser, this.authorStyle, sd, author);
                        SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)authorLinker, this.id);
                    }
                    int pos = sd.getLength();
                    if (var14_20 != null) {
                        var14_20.insertString(sd, selected ? style : null);
                    } else {
                        sd.insertString(sd.getLength(), author, style);
                    }
                    if (!selected) {
                        for (AbstractSummaryView.SummaryViewMaster.SearchHighlight highlight : highlights) {
                            if (highlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR) continue;
                            int doclen = sd.getLength();
                            String highlightMessage = highlight.getSearchText();
                            String authorText = sd.getText(pos, doclen - pos).toLowerCase();
                            int idx = authorText.indexOf(highlightMessage);
                            if (idx <= -1) continue;
                            sd.setCharacterAttributes(doclen - authorText.length() + idx, highlightMessage.length(), this.hiliteStyle, false);
                        }
                    }
                    sd.insertString(sd.getLength(), SummaryCellRenderer.FIELDS_SEPARATOR + entry.getDate(), null);
                    boolean messageChanged = !entry.getMessage().equals(this.commitMessage);
                    this.commitMessage = entry.getMessage();
                    if (this.commitMessage.endsWith("\n")) {
                        this.commitMessage = this.commitMessage.substring(0, this.commitMessage.length() - 1);
                    }
                    sd.insertString(sd.getLength(), "\n", null);
                    int i = 0;
                    int nlc = -1;
                    while (i != -1) {
                        i = this.commitMessage.indexOf(10, i + 1);
                        ++nlc;
                    }
                    if (nlc > 0 && !item.messageExpanded) {
                        this.commitMessage = this.commitMessage.substring(0, this.commitMessage.indexOf("\n"));
                    }
                    VCSHyperlinkSupport.StyledDocumentHyperlink styledDocumentHyperlink2 = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, this.id);
                    if (messageChanged) {
                        this.lastWidth = -1;
                        if (styledDocumentHyperlink2 != null) {
                            SummaryCellRenderer.this.linkerSupport.remove(styledDocumentHyperlink2, this.id);
                            Object var14_22 = null;
                        }
                    }
                    if (var14_23 == null) {
                        for (VCSHyperlinkProvider hp : SummaryCellRenderer.this.getHyperlinkProviders()) {
                            VCSHyperlinkSupport.IssueLinker issueLinker = VCSHyperlinkSupport.IssueLinker.create(hp, this.issueHyperlinkStyle, SummaryCellRenderer.this.summaryView.getRoot(), sd, this.commitMessage);
                            if (issueLinker == null) continue;
                            SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)issueLinker, this.id);
                            break;
                        }
                    }
                    pos = sd.getLength();
                    if (var14_24 != null) {
                        var14_24.insertString(sd, style);
                    } else {
                        sd.insertString(sd.getLength(), this.commitMessage, style);
                    }
                    MessageTooltip mtt = SummaryCellRenderer.this.linkerSupport.getLinker(MessageTooltip.class, this.id);
                    if (messageChanged) {
                        SummaryCellRenderer.this.linkerSupport.remove(mtt, this.id);
                        mtt = null;
                    }
                    if (mtt == null) {
                        SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new MessageTooltip(entry.getMessage(), pos, sd.getLength()), this.id);
                    }
                    if ((lineEnd = sd.getText(pos, sd.getLength() - pos).indexOf("\n")) == -1) {
                        lineEnd = sd.getLength() - pos;
                    }
                    Style s = this.textPane.addStyle(null, style);
                    StyleConstants.setBold(s, true);
                    sd.setCharacterAttributes(pos, lineEnd, s, false);
                    int msglen = this.commitMessage.length();
                    int doclen = sd.getLength();
                    if (nlc > 0 && !item.messageExpanded) {
                        void var14_28;
                        VCSHyperlinkSupport.StyledDocumentHyperlink styledDocumentHyperlink3 = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandMsgHyperlink.class, this.id);
                        if (styledDocumentHyperlink3 == null) {
                            ExpandMsgHyperlink expandMsgHyperlink = new ExpandMsgHyperlink(item, sd.getLength(), this.id);
                            SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)expandMsgHyperlink, this.id);
                        }
                        var14_28.insertString(sd, this.linkStyle);
                    }
                    if (!selected) {
                        for (AbstractSummaryView.SummaryViewMaster.SearchHighlight highlight : highlights) {
                            if (highlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE) continue;
                            String highlightMessage = highlight.getSearchText();
                            int idx = this.commitMessage.toLowerCase().indexOf(highlightMessage);
                            if (idx == -1) {
                                if (nlc <= 0 || item.messageExpanded || !entry.getMessage().toLowerCase().contains(highlightMessage)) continue;
                                sd.setCharacterAttributes(doclen, sd.getLength(), this.hiliteStyle, false);
                                continue;
                            }
                            sd.setCharacterAttributes(doclen - msglen + idx, highlightMessage.length(), this.hiliteStyle, false);
                        }
                    }
                    if (selected) {
                        sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            this.lastWidth = this.resizePane(this.textPane.getText(), list, this.lastWidth);
            return this;
        }

        private int resizePane(String text, JList list, int lastWidth) {
            int width;
            if (text == null) {
                text = "";
            }
            if ((width = SummaryCellRenderer.this.summaryView.getMaster().getComponent().getWidth()) > 0 && width != lastWidth) {
                String[] rows = text.split("\n");
                FontMetrics fm = list.getFontMetrics(list.getFont());
                int lines = 0;
                for (String row : rows) {
                    Rectangle2D rect = fm.getStringBounds(row, this.textPane.getGraphics());
                    lines += (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                }
                int ph = fm.getHeight() * lines + 9;
                this.textPane.setPreferredSize(new Dimension(width - 50 - ICON_COLLAPSED.getIconWidth(), ph));
                this.setPreferredSize(this.textPane.getPreferredSize());
            }
            return width;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            SummaryCellRenderer.this.linkerSupport.computeBounds(this.textPane, this.id);
            ExpandLink link = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.expandButton);
            }
        }
    }

    public class ShowRemainingFilesLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.RevisionItem item;

        private ShowRemainingFilesLink(AbstractSummaryView.RevisionItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(Component component) {
            this.bounds = component.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowAllFiles"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                SummaryCellRenderer.this.summaryView.showRemainingFiles(this.item);
                return true;
            }
            return false;
        }
    }
}

