/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MappingOptionsPanel
extends JPanel {
    private JComboBox collectionTypeComboBox;
    private JLabel collectionTypeLabel;
    private JCheckBox defaultsCheckBox;
    private JLabel descLabel;
    private JComboBox fetchComboBox;
    private JLabel fetchLabel;
    private JPanel paddingPanel;
    private JCheckBox regenTablesCheckBox;
    private JCheckBox relationshipColumnNamesCheckBox;
    private JCheckBox relationshipsUnresolvedCheckBox;
    private JCheckBox tableNameCheckBox;

    public MappingOptionsPanel() {
        this.initComponents();
        this.fetchComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_FETCH_DEFAULT"), NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_FETCH_EAGER"), NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_FETCH_LAZY")}));
        this.fetchComboBox.setSelectedIndex(0);
        this.collectionTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"java.util.Collection", "java.util.List", "java.util.Set"}));
        this.collectionTypeComboBox.setSelectedIndex(0);
    }

    public void initialize(EntityRelation.CollectionType collectionType, EntityRelation.FetchType fetchType, boolean fullyQualifiedTblName, boolean regenSchemaAttrs, boolean useColumnNamesInRelationships) {
        switch (fetchType) {
            case EAGER: {
                this.fetchComboBox.setSelectedIndex(1);
                break;
            }
            case LAZY: {
                this.fetchComboBox.setSelectedIndex(2);
                break;
            }
            default: {
                this.fetchComboBox.setSelectedIndex(0);
            }
        }
        switch (collectionType) {
            case LIST: {
                this.collectionTypeComboBox.setSelectedIndex(1);
                break;
            }
            case SET: {
                this.collectionTypeComboBox.setSelectedIndex(2);
                break;
            }
            default: {
                this.collectionTypeComboBox.setSelectedIndex(0);
            }
        }
        this.tableNameCheckBox.setSelected(fullyQualifiedTblName);
        this.regenTablesCheckBox.setSelected(regenSchemaAttrs);
        this.relationshipColumnNamesCheckBox.setSelected(useColumnNamesInRelationships);
    }

    public EntityRelation.FetchType getFetchType() {
        int selected = this.fetchComboBox.getSelectedIndex();
        if (selected == 0) {
            return EntityRelation.FetchType.DEFAULT;
        }
        if (selected == 1) {
            return EntityRelation.FetchType.EAGER;
        }
        return EntityRelation.FetchType.LAZY;
    }

    public EntityRelation.CollectionType getCollectionType() {
        int selected = this.collectionTypeComboBox.getSelectedIndex();
        if (selected == 0) {
            return EntityRelation.CollectionType.COLLECTION;
        }
        if (selected == 1) {
            return EntityRelation.CollectionType.LIST;
        }
        return EntityRelation.CollectionType.SET;
    }

    public boolean isFullyQualifiedTableName() {
        return this.tableNameCheckBox.isSelected();
    }

    public boolean isRegenSchemaAttributes() {
        return this.regenTablesCheckBox.isSelected();
    }

    public boolean isUseColumnNamesInRelationships() {
        return this.relationshipColumnNamesCheckBox.isSelected();
    }

    public boolean isUseDefaults() {
        return this.defaultsCheckBox.isSelected();
    }

    public boolean isGenerateUnresolved() {
        return this.relationshipsUnresolvedCheckBox.isSelected();
    }

    private void initComponents() {
        this.fetchLabel = new JLabel();
        this.fetchComboBox = new JComboBox();
        this.tableNameCheckBox = new JCheckBox();
        this.regenTablesCheckBox = new JCheckBox();
        this.paddingPanel = new JPanel();
        this.descLabel = new JLabel();
        this.collectionTypeLabel = new JLabel();
        this.collectionTypeComboBox = new JComboBox();
        this.relationshipColumnNamesCheckBox = new JCheckBox();
        this.defaultsCheckBox = new JCheckBox();
        this.relationshipsUnresolvedCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_MappingOptions"));
        this.setLayout(new GridBagLayout());
        this.fetchLabel.setLabelFor(this.fetchComboBox);
        Mnemonics.setLocalizedText((JLabel)this.fetchLabel, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_FETCH"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.fetchLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.fetchComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.tableNameCheckBox, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_TABLE_NAME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.tableNameCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.regenTablesCheckBox, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_REGENERATE_TABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.regenTablesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.paddingPanel, gridBagConstraints);
        this.descLabel.setText(NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_TABLE_MAPPING_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.descLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.collectionTypeLabel, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"LBL_COLLECTOIN_TYPE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.collectionTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.collectionTypeComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.relationshipColumnNamesCheckBox, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"MappingOptionsPanel.relationshipColumnNamesCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.relationshipColumnNamesCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultsCheckBox, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"MappingOptionsPanel.defaultsCheckBox.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.defaultsCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.relationshipsUnresolvedCheckBox, (String)NbBundle.getMessage(MappingOptionsPanel.class, (String)"MappingOptionsPanel.relationshipsUnresolvedCheckBox.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.relationshipsUnresolvedCheckBox, gridBagConstraints);
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        private MappingOptionsPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private boolean cmp;

        public MappingOptionsPanel getComponent() {
            if (this.component == null) {
                this.component = new MappingOptionsPanel();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            if (this.cmp) {
                return new HelpCtx("org.netbeans.modules.j2ee.ejbcore.ejb.wizard.cmp." + MappingOptionsPanel.class.getSimpleName());
            }
            return new HelpCtx(MappingOptionsPanel.class);
        }

        public void readSettings(WizardDescriptor settings) {
            this.wizardDescriptor = settings;
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                this.cmp = RelatedCMPWizard.isCMP(this.wizardDescriptor);
                RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
                EntityRelation.FetchType fetchType = helper.getFetchType();
                boolean fullTblName = helper.isFullyQualifiedTableNames();
                boolean regenSchema = helper.isRegenTablesAttrs();
                boolean useColumnNamesInRelationships = helper.isUseColumnNamesInRelationships();
                EntityRelation.CollectionType clcType = helper.getCollectionType();
                this.getComponent().initialize(clcType, fetchType, fullTblName, regenSchema, useColumnNamesInRelationships);
            }
        }

        public boolean isValid() {
            return true;
        }

        public void storeSettings(WizardDescriptor settings) {
            RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            MappingOptionsPanel mPanel = this.getComponent();
            helper.setFetchType(mPanel.getFetchType());
            helper.setFullyQualifiedTableNames(mPanel.isFullyQualifiedTableName());
            helper.setRegenTablesAttrs(mPanel.isRegenSchemaAttributes());
            helper.setUseColumnNamesInRelationships(mPanel.isUseColumnNamesInRelationships());
            helper.setCollectionType(mPanel.getCollectionType());
            helper.setUseDefaults(mPanel.isUseDefaults());
            helper.setGenerateUnresolvedRelationships(mPanel.isGenerateUnresolved());
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

