/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql.support;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.jpa.jpql.spi.IMappingType;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embedded;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EmbeddedId;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToOne;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToOne;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.modules.j2ee.persistence.spi.jpql.support.Utils;

public class JPAAttribute {
    private Object attr;
    private IMappingType mType = IMappingType.TRANSIENT;
    private String name;
    private PersistentObject parent;
    private TypeElement typeElement;
    private String typeName;

    public JPAAttribute(PersistentObject parent, ManyToMany attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.MANY_TO_MANY;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, ManyToOne attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.MANY_TO_ONE;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, OneToMany attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.ONE_TO_MANY;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, OneToOne attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.ONE_TO_ONE;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, Basic attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.BASIC;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, Id attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.ID;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, Embedded attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.EMBEDDED;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, EmbeddedId attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.EMBEDDED_ID;
        this.parent = parent;
    }

    public JPAAttribute(PersistentObject parent, Version attr) {
        this.attr = attr;
        this.name = attr.getName();
        this.mType = IMappingType.VERSION;
        this.parent = parent;
    }

    public IMappingType getMappingType() {
        return this.mType;
    }

    public String getName() {
        return this.name;
    }

    public TypeElement getType() {
        if (this.typeElement == null) {
            this.buildType();
        }
        return this.typeElement;
    }

    public String getTypeName() {
        if (this.typeName == null) {
            this.buildType();
        }
        return this.typeName;
    }

    private void buildType() {
        TypeMirror tm = null;
        VariableElement var = Utils.getField(this.parent.getTypeElement(), this.name);
        if (var == null) {
            ExecutableElement acc = Utils.getAccesor(this.parent.getTypeElement(), this.name);
            if (acc != null) {
                tm = acc.getReturnType();
            }
        } else {
            tm = var.asType();
        }
        if (tm != null) {
            if (tm.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)tm;
                this.typeElement = (TypeElement)declaredType.asElement();
                this.typeName = this.typeElement.getQualifiedName().toString();
            } else if (TypeKind.BOOLEAN == tm.getKind()) {
                this.typeName = "boolean";
            } else if (TypeKind.BYTE == tm.getKind()) {
                this.typeName = "byte";
            } else if (TypeKind.CHAR == tm.getKind()) {
                this.typeName = "char";
            } else if (TypeKind.DOUBLE == tm.getKind()) {
                this.typeName = "double";
            } else if (TypeKind.FLOAT == tm.getKind()) {
                this.typeName = "float";
            } else if (TypeKind.INT == tm.getKind()) {
                this.typeName = "int";
            } else if (TypeKind.LONG == tm.getKind()) {
                this.typeName = "long";
            } else if (TypeKind.SHORT == tm.getKind()) {
                this.typeName = "short";
            }
        }
    }
}

