/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Constructor;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeDeclaration;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeRepository;

public class Type
implements IType {
    private final Element element;
    private PersistentObject po;
    private final ITypeRepository repository;
    private ITypeDeclaration tDeclaration;
    private final Class<?> type;
    private Collection<IConstructor> constructors;
    private String[] enumConstants;
    private String typeName;

    public Type(ITypeRepository typeRepository, PersistentObject po) {
        this.element = null;
        this.po = po;
        this.repository = typeRepository;
        this.type = null;
        this.typeName = po.getTypeElementHandle().getQualifiedName();
    }

    public Type(ITypeRepository typeRepository, Element element) {
        this.element = element;
        this.repository = typeRepository;
        this.type = null;
    }

    public Type(ITypeRepository typeRepository, Class<?> type) {
        this.type = type;
        this.repository = typeRepository;
        this.element = null;
    }

    Type(ITypeRepository typeRepository, String typeName) {
        this.repository = typeRepository;
        this.typeName = typeName;
        this.element = null;
        this.enumConstants = new String[0];
        this.constructors = Collections.emptyList();
        this.type = null;
    }

    public Iterable<IConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = new ArrayList<IConstructor>();
            if (this.po != null) {
                this.collectConstructors(this.constructors, this.getTypeElement(this.po));
            } else if (this.element != null) {
                this.collectConstructors(this.constructors, this.element);
            } else if (this.type != null) {
                this.collectConstructors(this.constructors, this.type);
            }
        }
        return this.constructors;
    }

    public boolean equals(IType itype) {
        return this == itype || this.getName().equals(itype.getName());
    }

    public boolean equals(Object itype) {
        return this == itype || this.equals((IType)itype);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String[] getEnumConstants() {
        if (this.enumConstants == null) {
            Element elt;
            Element element = elt = this.po != null ? this.getTypeElement(this.po) : this.element;
            if (elt != null) {
                ArrayList<String> constants = new ArrayList<String>();
                for (Element element2 : elt.getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    constants.add(element2.getSimpleName().toString());
                }
                this.enumConstants = constants.toArray(new String[0]);
            } else if (this.type != null) {
                if (!this.type.isEnum()) {
                    this.enumConstants = new String[0];
                } else {
                    ?[] enumC = this.type.getEnumConstants();
                    this.enumConstants = new String[enumC.length];
                    int index = enumC.length;
                    while (--index >= 0) {
                        this.enumConstants[index] = ((Enum)enumC[index]).name();
                    }
                }
            } else {
                this.enumConstants = new String[0];
            }
        }
        return this.enumConstants;
    }

    public String getName() {
        if (this.typeName == null) {
            Element elt;
            Element element = elt = this.po != null ? this.getTypeElement(this.po) : this.element;
            if (elt != null) {
                this.typeName = elt instanceof TypeElement ? ((TypeElement)elt).getQualifiedName().toString() : ((Object)elt.asType()).toString();
            } else if (this.type != null) {
                this.typeName = this.type.getName();
            }
        }
        return this.typeName;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.tDeclaration == null) {
            this.tDeclaration = this.type != null ? new TypeDeclaration(this.repository, this, null, this.type.isArray()) : new TypeDeclaration(this, new ITypeDeclaration[0], 0);
        }
        return this.tDeclaration;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        Element elt;
        Element element = elt = this.po != null ? this.getTypeElement(this.po) : this.element;
        return elt != null ? elt.getAnnotation(type) != null : type != null && type.isAnnotationPresent(type);
    }

    public boolean isAssignableTo(IType itype) {
        Element elt2;
        if (this == itype) {
            return true;
        }
        Type tp = (Type)itype;
        Element elt1 = this.po != null ? this.getTypeElement(this.po) : this.element;
        Element element = elt2 = tp.po != null ? this.getTypeElement(tp.po) : tp.element;
        if (elt1 != null && elt2 != null) {
            String rootName = itype.getName();
            TypeElement tEl = (TypeElement)(elt1 instanceof TypeElement ? elt1 : null);
            return this.haveInHierarchy(tEl, rootName);
        }
        if (this.type != null && tp.type != null) {
            return tp.type.isAssignableFrom(this.type);
        }
        return false;
    }

    public boolean isEnum() {
        Element elt;
        Element element = elt = this.po != null ? this.getTypeElement(this.po) : this.element;
        return elt instanceof TypeElement ? ((TypeElement)elt).getKind() == ElementKind.ENUM : this.type != null && this.type.isEnum();
    }

    public boolean isResolvable() {
        return this.type != null || this.element != null || this.po != null;
    }

    public String toString() {
        return super.toString() + ", name = " + this.getName();
    }

    private void collectConstructors(Collection<IConstructor> constructors, Element element) {
        if (element == null || element.getKind() != ElementKind.CLASS) {
            return;
        }
        TypeElement el = (TypeElement)element;
        for (Element element2 : el.getEnclosedElements()) {
            TypeMirror supMirror;
            if (element2.getKind() == ElementKind.CONSTRUCTOR) {
                constructors.add(new Constructor((IType)this, (ExecutableElement)element2));
                continue;
            }
            if (element2.getKind() != ElementKind.CLASS || ((TypeElement)element2).getSuperclass() == null || (supMirror = ((TypeElement)element2).getSuperclass()).getKind() != TypeKind.DECLARED) continue;
            DeclaredType superclassDeclaredType = (DeclaredType)supMirror;
            Element superclassElement = superclassDeclaredType.asElement();
            this.collectConstructors(constructors, superclassElement);
        }
    }

    private void collectConstructors(Collection<IConstructor> constructors, Class<?> type) {
        java.lang.reflect.Constructor<?>[] javaConstructors;
        for (java.lang.reflect.Constructor<?> javaConstructor : javaConstructors = type.getDeclaredConstructors()) {
            constructors.add(new Constructor((IType)this, javaConstructor));
        }
    }

    private boolean haveInHierarchy(TypeElement el, String name) {
        TypeElement tmpEl = el;
        while (tmpEl != null) {
            if (tmpEl.getQualifiedName().contentEquals(name)) {
                return true;
            }
            TypeMirror supMirror = tmpEl.getSuperclass();
            if (supMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)supMirror;
                Element superclassElement = declaredType.asElement();
                if (superclassElement instanceof TypeElement) {
                    tmpEl = (TypeElement)superclassElement;
                    continue;
                }
                tmpEl = null;
                continue;
            }
            tmpEl = null;
        }
        for (TypeMirror typeMirror : el.getInterfaces()) {
            DeclaredType intDeclType;
            Element intElement;
            if (typeMirror.getKind() != TypeKind.DECLARED || !((intElement = (intDeclType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement) || !this.haveInHierarchy(tmpEl = (TypeElement)intElement, name)) continue;
            return true;
        }
        return false;
    }

    ITypeRepository getTypeRepository() {
        return this.repository;
    }

    private TypeElement getTypeElement(PersistentObject po) {
        if (((TypeRepository)this.repository).isValid()) {
            return po.getTypeElement();
        }
        return null;
    }
}

