/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.j2ee.persistence.editor.CompletionContext;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.PUCompletionManager;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBCompletionContextResolver;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class PUCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1 && queryType != 9) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new PUCompletionQuery(queryType, component, component.getSelectionStart(), true), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static int getRowFirstNonWhite(StyledDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        int start = lineElement.getStartOffset();
        while (start + 1 < lineElement.getEndOffset()) {
            try {
                if (doc.getText(start, 1).charAt(0) != ' ') {
                    break;
                }
            }
            catch (BadLocationException ex) {
                throw (BadLocationException)new BadLocationException("calling getText(" + start + ", " + (start + 1) + ") on doc of length: " + doc.getLength(), start).initCause(ex);
            }
            ++start;
        }
        return start;
    }

    static int indexOfWhite(char[] line) {
        int i = line.length;
        while (--i > -1) {
            char c = line[i];
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        ExtSyntaxSupport f = new ExtSyntaxSupport(null);
        return -1;
    }

    class PUCompletionQuery
    extends AsyncCompletionQuery {
        private ArrayList<CompletionContextResolver> resolvers;
        private List<JPACompletionItem> results;
        private byte hasAdditionalItems = 0;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private int toolTipOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;
        private boolean hasTask;

        public PUCompletionQuery(int queryType, JTextComponent component, int caretOffset, boolean hasTask) {
            this.queryType = queryType;
            this.caretOffset = caretOffset;
            this.hasTask = hasTask;
            this.component = component;
            this.initResolvers();
        }

        private void initResolvers() {
            this.resolvers = new ArrayList();
            this.resolvers.add(new DBCompletionContextResolver());
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            System.out.println("QUERY");
            ArrayList<JPACompletionItem> completionItems = new ArrayList<JPACompletionItem>();
            int anchorOffset = this.getCompletionItems(doc, caretOffset, completionItems);
            if (completionItems == null || completionItems.size() == 0) {
                System.out.println("EMPTY");
            }
            resultSet.addAllItems(completionItems);
            if (anchorOffset != -1) {
                resultSet.setAnchorOffset(anchorOffset);
            }
            resultSet.finish();
        }

        int getCompletionItems(Document doc, int caretOffset, List<JPACompletionItem> completionItems) {
            int anchorOffset = -1;
            CompletionContext context = new CompletionContext(doc, caretOffset);
            if (context.getCompletionType() == CompletionContext.CompletionType.NONE) {
                return anchorOffset;
            }
            switch (context.getCompletionType()) {
                case ATTRIBUTE_VALUE: {
                    anchorOffset = PUCompletionManager.getDefault().completeAttributeValues(context, completionItems);
                    break;
                }
                case ATTRIBUTE: {
                    anchorOffset = PUCompletionManager.getDefault().completeAttributes(context, completionItems);
                    break;
                }
                case TAG: {
                    anchorOffset = PUCompletionManager.getDefault().completeElements(context, completionItems);
                    break;
                }
                case VALUE: {
                    anchorOffset = PUCompletionManager.getDefault().completeValues(context, completionItems);
                }
            }
            return anchorOffset;
        }

        protected boolean canFilter(JTextComponent component) {
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            try {
                if ((this.queryType & 1) != 0 && this.results != null) {
                    if (this.filterPrefix != null) {
                        resultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems > 0);
                    } else {
                        Completion.get().hideDocumentation();
                        Completion.get().hideCompletion();
                    }
                }
                resultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            resultSet.finish();
        }

        private Collection getFilteredData(Collection<JPACompletionItem> data, String prefix) {
            if (prefix.length() == 0) {
                return data;
            }
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : data) {
                if (!((Object)completionItem.getInsertPrefix()).toString().startsWith(prefix)) continue;
                ret.add(completionItem);
            }
            return ret;
        }
    }
}

